/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_mzn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_SK = "اسلواکی";
        final String metaValue_ar = "عربی";
        final String metaValue_hy = "ارمنی";
        final String metaValue_bn = "بنگالی";
        final String metaValue_ka = "گرجی";
        final String metaValue_el = "یونانی";
        final String metaValue_gu = "گجراتی";
        final String metaValue_he = "عبری";
        final String metaValue_ja = "جاپونی";
        final String metaValue_MD = "مولداوی";
        final Object[][] data = new Object[][] {
            { "001", "جهون" },
            { "002", "آفریقا" },
            { "003", "شمالی آمریکا" },
            { "005", "جنوبی آمریکا" },
            { "009", "اوقیانوسیه" },
            { "011", "غربی آفریقا" },
            { "013", "میونی آمریکا" },
            { "014", "شرقی آفریقا" },
            { "015", "شمالی ۀفریقا" },
            { "017", "میونی آفریقا" },
            { "018", "جنوبی آفریقا" },
            { "019", "آمریکا" },
            { "021", "شمالی امریکا" },
            { "029", "کاراییب" },
            { "030", "شرقی آسیا" },
            { "034", "جنوبی آسیا" },
            { "035", "آسیای ِجنوب‌شرقی‌وَر" },
            { "039", "جنوبی اروپا" },
            { "053", "اوسترالزی" },
            { "054", "ملانزی" },
            { "057", "میکرونزی منقطه" },
            { "061", "پولی‌نزی" },
            { "142", "آسیا" },
            { "143", "میونی آسیا" },
            { "145", "غربی آسیا" },
            { "150", "اروپا" },
            { "151", "شرقی اروپا" },
            { "154", "شمالی اروپا" },
            { "155", "غربی اروپا" },
            { "419", "لاتین آمریکا" },
            { "AC", "آسنسیون جزیره" },
            { "AD", "آندورا" },
            { "AE", "متحده عربی امارات" },
            { "AF", "افغانستون" },
            { "AG", "آنتیگوا و باربودا" },
            { "AI", "آنگویلا" },
            { "AL", "آلبانی" },
            { "AM", "ارمنستون" },
            { "AO", "آنگولا" },
            { "AQ", "جنوبی یخ‌بزه قطب" },
            { "AR", "آرژانتین" },
            { "AS", "آمریکای ِساموآ" },
            { "AT", "اتریش" },
            { "AU", "استرالیا" },
            { "AW", "آروبا" },
            { "AX", "آلند جزیره" },
            { "AZ", "آذربایجون" },
            { "BA", "بوسنی و هرزگوین" },
            { "BB", "باربادوس" },
            { "BD", "بنگلادش" },
            { "BE", "بلژیک" },
            { "BF", "بورکینا فاسو" },
            { "BG", "بلغارستون" },
            { "BH", "بحرین" },
            { "BI", "بوروندی" },
            { "BJ", "بنین" },
            { "BL", "سنت بارتلمی" },
            { "BM", "برمودا" },
            { "BN", "برونئی" },
            { "BO", "بولیوی" },
            { "BQ", "هلند ِکاراییبی جزایر" },
            { "BR", "برزیل" },
            { "BS", "باهاما" },
            { "BT", "بوتان" },
            { "BV", "بووت جزیره" },
            { "BW", "بوتساوانا" },
            { "BY", "بلاروس" },
            { "BZ", "بلیز" },
            { "CA", "کانادا" },
            { "CC", "کوک (کیلینگ) جزایر" },
            { "CD", "کنگو کینشاسا" },
            { "CF", "مرکزی آفریقای جمهوری" },
            { "CG", "کنگو برازاویل" },
            { "CH", "سوییس" },
            { "CI", "عاج ِساحل" },
            { "CK", "کوک جزایر" },
            { "CL", "شیلی" },
            { "CM", "کامرون" },
            { "CN", "چین" },
            { "CO", "کلمبیا" },
            { "CP", "کلیپرتون جزیره" },
            { "CR", "کاستاریکا" },
            { "CU", "کوبا" },
            { "CV", "کیپ ورد" },
            { "CW", "کوراسائو" },
            { "CX", "کریسمس جزیره" },
            { "CY", "قبرس" },
            { "CZ", "چک جمهوری" },
            { "DE", "آلمان" },
            { "DG", "دیگو گارسیا" },
            { "DJ", "جیبوتی" },
            { "DK", "دانمارک" },
            { "DM", "دومنیکا" },
            { "DO", "دومنیکن جمهوری" },
            { "DZ", "الجزیره" },
            { "EA", "سوتا و ملیله" },
            { "EC", "اکوادر" },
            { "EE", "استونی" },
            { "EG", "مصر" },
            { "EH", "غربی صحرا" },
            { "ER", "اریتره" },
            { "ES", "ایسپانیا" },
            { "ET", "اتیوپی" },
            { "EU", "اروپا اتحادیه" },
            { "FI", "فنلاند" },
            { "FJ", "فیجی" },
            { "FK", "فالکلند جزیره‌ئون" },
            { "FM", "میکرونزی" },
            { "FO", "فارو جزایر" },
            { "FR", "فرانسه" },
            { "GA", "گابون" },
            { "GB", "بریتانیا" },
            { "GD", "گرانادا" },
            { "GE", "گرجستون" },
            { "GF", "فرانسه‌ی ِگویان" },
            { "GG", "گرنزی" },
            { "GH", "غنا" },
            { "GI", "جبل طارق" },
            { "GL", "گرینلند" },
            { "GM", "گامبیا" },
            { "GN", "گینه" },
            { "GP", "گوادلوپ" },
            { "GQ", "استوایی گینه" },
            { "GR", "یونان" },
            { "GS", "جنوبی جورجیا و جنوبی ساندویچ جزایر" },
            { "GT", "گواتمالا" },
            { "GU", "گوئام" },
            { "GW", "گینه بیسائو" },
            { "GY", "گویان" },
            { "HK", "هنگ کنگ" },
            { "HM", "هارد و مک‌دونالد جزایر" },
            { "HN", "هندوراس" },
            { "HR", "کرواسی" },
            { "HT", "هاییتی" },
            { "HU", "مجارستون" },
            { "IC", "قناری جزایر" },
            { "ID", "اندونزی" },
            { "IE", "ایرلند" },
            { "IL", "ایسراییل" },
            { "IM", "من ِجزیره" },
            { "IN", "هند" },
            { "IQ", "عراق" },
            { "IR", "ایران" },
            { "IS", "ایسلند" },
            { "IT", "ایتالیا" },
            { "JE", "جرسی" },
            { "JM", "جاماییکا" },
            { "JO", "اردن" },
            { "JP", "جاپون" },
            { "KE", "کنیا" },
            { "KG", "قرقیزستون" },
            { "KH", "کامبوج" },
            { "KI", "کیریباتی" },
            { "KM", "کومور" },
            { "KN", "سنت کیتس و نویس" },
            { "KP", "شمالی کُره" },
            { "KR", "جنوبی کُره" },
            { "KW", "کویت" },
            { "KY", "کیمن جزیره‌ئون" },
            { "KZ", "قزاقستون" },
            { "LA", "لائوس" },
            { "LB", "لبنان" },
            { "LC", "سنت لوسیا" },
            { "LI", "لیختن اشتاین" },
            { "LK", "سریلانکا" },
            { "LR", "لیبریا" },
            { "LS", "لسوتو" },
            { "LT", "لتونی" },
            { "LU", "لوکزامبورگ" },
            { "LV", "لاتویا" },
            { "LY", "لیبی" },
            { "MA", "مراکش" },
            { "MC", "موناکو" },
            { "MD", metaValue_MD },
            { "ME", "مونته‌نگرو" },
            { "MF", "سنت مارتین" },
            { "MG", "ماداگاسکار" },
            { "MH", "مارشال جزایر" },
            { "ML", "مالی" },
            { "MM", "میانمار" },
            { "MN", "مغولستون" },
            { "MO", "ماکائو (چین دله)" },
            { "MP", "شمالی ماریانا جزایر" },
            { "MQ", "مارتینیک جزیره‌ئون" },
            { "MR", "موریتانی" },
            { "MS", "مونتسرات" },
            { "MT", "مالت" },
            { "MU", "مورى تيوس" },
            { "MV", "مالدیو" },
            { "MW", "مالاوی" },
            { "MX", "مکزیک" },
            { "MY", "مالزی" },
            { "MZ", "موزامبیک" },
            { "NA", "نامبیا" },
            { "NC", "نیو کالیدونیا" },
            { "NE", "نیجر" },
            { "NF", "نورفولک جزیره" },
            { "NG", "نیجریه" },
            { "NI", "نیکاراگوئه" },
            { "NL", "هلند" },
            { "NO", "نروژ" },
            { "NP", "نپال" },
            { "NR", "نائورو" },
            { "NU", "نیئو" },
            { "NZ", "نیوزلند" },
            { "OM", "عمان" },
            { "PA", "پاناما" },
            { "PE", "پرو" },
            { "PF", "فرانسه‌ی پولی‌نزی" },
            { "PG", "پاپوا نو گینه" },
            { "PH", "فیلیپین" },
            { "PK", "پاکستون" },
            { "PL", "لهستون" },
            { "PM", "سن پییر و میکلن" },
            { "PN", "پیتکارین جزایر" },
            { "PR", "پورتوریکو" },
            { "PS", "فلسطین ِسرزمین" },
            { "PT", "پرتغال" },
            { "PW", "پالائو" },
            { "PY", "پاراگوئه" },
            { "QA", "قطر" },
            { "QO", "اوقیانوسیه‌ی ِپرت ِجائون" },
            { "RE", "رئونیون" },
            { "RO", "رومانی" },
            { "RS", "صربستون" },
            { "RU", "روسیه" },
            { "RW", "روآندا" },
            { "SA", "عربستون" },
            { "SB", "سلیمون جزیره" },
            { "SC", "سیشل" },
            { "SD", "سودان" },
            { "SE", "سوئد" },
            { "SG", "سنگاپور" },
            { "SH", "سنت هلنا" },
            { "SI", "اسلوونی" },
            { "SJ", "سوالبارد و يان ماين" },
            { "SK", metaValue_SK },
            { "SL", "سیرالئون" },
            { "SM", "سن مارینو" },
            { "SN", "سنگال" },
            { "SO", "سومالی" },
            { "SR", "سورینام" },
            { "SS", "جنوبی سودان" },
            { "ST", "سائوتومه و پرینسیپ" },
            { "SV", "السالوادور" },
            { "SX", "سنت مارتن" },
            { "SY", "سوریه" },
            { "SZ", "سوازیلند" },
            { "TA", "تریستان دا جونها" },
            { "TC", "تورکس و کایکوس جزایر" },
            { "TD", "چاد" },
            { "TF", "فرانسه‌ی جنوبی مناطق" },
            { "TG", "توگو" },
            { "TH", "تایلند" },
            { "TJ", "تاجیکستون" },
            { "TK", "توکلائو" },
            { "TL", "تیمور شرقی" },
            { "TM", "ترکمونستون" },
            { "TN", "تونس" },
            { "TO", "تونگا" },
            { "TR", "ترکیه" },
            { "TT", "ترینیداد و توباگو" },
            { "TV", "تووالو" },
            { "TW", "تایوان" },
            { "TZ", "تانزانیا" },
            { "UA", "اوکراین" },
            { "UG", "اوگاندا" },
            { "UM", "آمریکای پَرتِ‌پِلا جزیره‌ئون" },
            { "US", "متحده ایالات" },
            { "UY", "اروگوئه" },
            { "UZ", "ازبکستون" },
            { "VA", "واتیکان" },
            { "VC", "سنت وینسنت و گرنادین" },
            { "VE", "ونزوئلا" },
            { "VG", "بریتانیای ویرجین" },
            { "VI", "آمریکای ویرجین" },
            { "VN", "ویتنام" },
            { "VU", "وانواتو" },
            { "WF", "والیس و فوتونا" },
            { "WS", "ساموآ" },
            { "XK", "کوزوو" },
            { "YE", "یمن" },
            { "YT", "مایوت" },
            { "ZA", "جنوبی افریقا" },
            { "ZM", "زامبیا" },
            { "ZW", "زیمبابوه" },
            { "ZZ", "نامَیِّن منطقه" },
            { "ab", "آبخازی" },
            { "af", "آفریکانس" },
            { "ak", "آکان" },
            { "am", "امهری" },
            { "ar", metaValue_ar },
            { "as", "آسامی" },
            { "az", "آذری ِترکی" },
            { "ba", "باشقیری" },
            { "be", "بلاروسی" },
            { "bg", "بلغاری" },
            { "bm", "بامبارایی" },
            { "bn", metaValue_bn },
            { "bo", "تبتی" },
            { "br", "برِتونی" },
            { "bs", "بوسنیایی" },
            { "ca", "کاتالونی" },
            { "ce", "چچنی" },
            { "co", "کورسیکان" },
            { "cs", "چکی" },
            { "cv", "چوواشی" },
            { "cy", "ولزی" },
            { "da", "دانمارکی" },
            { "de", "آلمانی" },
            { "dz", "دزونگخا" },
            { "ee", "اوه‌یی" },
            { "el", metaValue_el },
            { "en", "انگلیسی" },
            { "eo", "اسپرانتو" },
            { "es", "ایسپانیولی" },
            { "et", "استونیایی" },
            { "eu", "باسکی" },
            { "fa", "فارسی" },
            { "fi", "فینیش" },
            { "fj", "فیجیایی" },
            { "fo", "فارویی" },
            { "fr", "فرانسوی" },
            { "fy", "غربی فیریزی" },
            { "ga", "ایریش" },
            { "gl", "گالیک" },
            { "gn", "گورانی" },
            { "gu", metaValue_gu },
            { "gv", "مانکس" },
            { "ha", "هوسا" },
            { "he", metaValue_he },
            { "hi", "هندی" },
            { "hr", "کرواتی" },
            { "ht", "هائتیایی" },
            { "hu", "مجاری" },
            { "hy", metaValue_hy },
            { "id", "اندونزیایی" },
            { "ig", "ایگبو" },
            { "ii", "سیچوئان یی" },
            { "is", "ایسلندی" },
            { "it", "ایتالیایی" },
            { "iu", "انوکتیتوت" },
            { "ja", metaValue_ja },
            { "jv", "جاوایی" },
            { "ka", metaValue_ka },
            { "ki", "کیکویو" },
            { "kk", "قزاقی" },
            { "kl", "کالائلیسوت" },
            { "km", "خمری" },
            { "kn", "کانّادا" },
            { "ko", "کُره‌یی" },
            { "ks", "کشمیری" },
            { "ku", "کوردی" },
            { "kw", "کورنیش" },
            { "ky", "قرقیزی" },
            { "la", "لاتین" },
            { "lb", "لوکزامبورگی" },
            { "lg", "گاندا" },
            { "ln", "لینگالا" },
            { "lo", "لائویی" },
            { "lt", "لتونیایی" },
            { "lu", "لوبا-کاتانگا" },
            { "lv", "لاتویایی" },
            { "mg", "مالاگاسی" },
            { "mi", "مائوری" },
            { "mk", "مقدونی" },
            { "ml", "مالایالام" },
            { "mn", "مغولی" },
            { "mr", "ماراتی" },
            { "ms", "مالایی" },
            { "mt", "مالتی" },
            { "my", "برمه‌یی" },
            { "nb", "نروژی بوکمال" },
            { "nd", "شمالی ندبله" },
            { "ne", "نپالی" },
            { "nl", "هلندی" },
            { "nn", "نروژی نینورسک" },
            { "om", "اورومو" },
            { "or", "اوریا" },
            { "pa", "پنجابی" },
            { "pl", "لهستونی" },
            { "ps", "پشتو" },
            { "pt", "پرتغالی" },
            { "qu", "قوئچوئا" },
            { "rm", "رومانش" },
            { "rn", "روندی" },
            { "ro", "رومانیایی" },
            { "ru", "روسی" },
            { "rw", "کنیاروآندایی" },
            { "sa", "سانسکریت" },
            { "sd", "سندی" },
            { "se", "شمالی سامی" },
            { "sg", "سانگو" },
            { "si", "سینهالا" },
            { "sk", metaValue_SK },
            { "sl", "اسلوونیایی" },
            { "sn", "شونا" },
            { "so", "سومالیایی" },
            { "sq", "آلبانیایی" },
            { "sr", "صربی" },
            { "su", "سوندانسی" },
            { "sv", "سوئدی" },
            { "sw", "سواحیلی" },
            { "ta", "تامیلی" },
            { "te", "تلوگویی" },
            { "tg", "تاجیکی" },
            { "th", "تایی" },
            { "ti", "تیگرینیایی" },
            { "tk", "ترکمونی" },
            { "to", "تونگانی" },
            { "tr", "ترکی" },
            { "tt", "تاتاری" },
            { "ug", "ئوغوری" },
            { "uk", "اوکراینی" },
            { "ur", "اردو" },
            { "uz", "ازبکی" },
            { "vi", "ویتنامی" },
            { "wo", "وولفی" },
            { "xh", "خوسا" },
            { "yo", "یوروبا" },
            { "zh", "چینی" },
            { "zu", "زولو" },
            { "agq", "آقم" },
            { "arn", "ماپوچه" },
            { "asa", "آسو" },
            { "bem", "بمبایی" },
            { "bez", "بنایی" },
            { "bgn", "غربی بلوچی" },
            { "brx", "بدویی" },
            { "cgg", "چیگا" },
            { "chr", "چروکیایی" },
            { "ckb", "میونی کوردی" },
            { "dav", "تایتا" },
            { "dje", "زارمایی" },
            { "dsb", "پایین صربی" },
            { "dua", "دوئالایی" },
            { "dyo", "جولا-فونی" },
            { "ebu", "امبو" },
            { "fil", "فیلیپینو" },
            { "gag", "گاگائوزی" },
            { "gsw", "سوییس آلمانی" },
            { "guz", "گوسی" },
            { "haw", "هاواییایی" },
            { "hsb", "بالایی صربی" },
            { "jgo", "نگومبا" },
            { "jmc", "ماچامه" },
            { "kab", "قبایلی" },
            { "kam", "کامبایی" },
            { "kde", "ماکونده" },
            { "kea", "کیپ وُردی" },
            { "khq", "کویرا چیینی" },
            { "kln", "کالنجین" },
            { "koi", "کومی-پرمیاک" },
            { "kok", "کونکانی" },
            { "ksb", "شامبالا" },
            { "ksf", "بافیایی" },
            { "lag", "لانگی" },
            { "lkt", "لاکوتا" },
            { "lrc", "شمالی لُری" },
            { "luo", "لوئو" },
            { "luy", "لوییا" },
            { "mas", "ماسایی" },
            { "mer", "مِرویی" },
            { "mfe", "موریسین" },
            { "mgh", "ماخوئا-میتو" },
            { "mgo", "مِتاء" },
            { "moh", "موهاک" },
            { "mua", "موندانگ" },
            { "mzn", "مازرونی" },
            { "naq", "ناما" },
            { "nds", "پایین آلمانی" },
            { "nmg", "کوئاسیو" },
            { "nqo", "نئکو" },
            { "nus", "نوئر" },
            { "nyn", "نیانکوله" },
            { "quc", "کئیچه‌ئی" },
            { "rof", "رومبو" },
            { "rwk", "روآیی" },
            { "saq", "سامبورو" },
            { "sbp", "سانگوو" },
            { "sdh", "جنوبی کردی" },
            { "seh", "سِنایی" },
            { "ses", "کویرابورا سنی" },
            { "shi", "تاچلهیت" },
            { "sma", "جنوبی سامی" },
            { "smj", "لوله سامی" },
            { "smn", "ایناری سامی" },
            { "sms", "سکولت سامی" },
            { "teo", "تسویی" },
            { "twq", "تاساواقی" },
            { "tzm", "میونی اطلس تامزیقی" },
            { "und", "نشناسی‌یه زوون" },
            { "vai", "وایی" },
            { "vun", "وونجویی" },
            { "wbp", "والرپیری" },
            { "xog", "سوگا" },
            { "zgh", "مراکش ِاستاندارد ِتامازیقتی" },
            { "zxx", "این زوون بشناسی‌یه نیّه" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "بوپوموفو" },
            { "Cyrl", "سیریلیک" },
            { "Deva", "دیوانانگری" },
            { "Ethi", "اتیوپیایی" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "گورموخی" },
            { "Hang", "هانگول" },
            { "Hani", "هان" },
            { "Hans", "ساده‌بَیی هان" },
            { "Hant", "سنتی هانت" },
            { "Hebr", metaValue_he },
            { "Hira", "هیراگانا" },
            { "Jpan", metaValue_ja },
            { "Kana", "کاتاکانا" },
            { "de_AT", "اتریش ِآلمانی" },
            { "de_CH", "سوییس ِآلمانی" },
            { "en_AU", "استرالیای ِانگلیسی" },
            { "en_CA", "کانادای ِانگلیسی" },
            { "en_GB", "بریتیش انگلیسی" },
            { "en_US", "امریکن انگلیسی" },
            { "es_ES", "اروپای ِایسپانیولی" },
            { "es_MX", "مکزیک ِایسپانیولی" },
            { "fr_CA", "کانادای ِفرانسوی" },
            { "fr_CH", "سوییس ِفرانسوی" },
            { "nl_BE", "فلمیش" },
            { "pt_BR", "برزیل ِپرتغالی" },
            { "pt_PT", "اروپای ِپرتغالی" },
            { "ro_MD", metaValue_MD },
            { "sw_CD", "کنگو سواحیلی" },
            { "ar_001", "مدرن استاندارد عربی" },
            { "es_419", "جنوبی آمریکای ِایسپانیولی" },
            { "nds_NL", "پایین ساکسونی" },
            { "az_Arab", "جنوبی آذری ترکی" },
            { "zh_Hans", "ساده چینی" },
            { "zh_Hant", "سنتی چینی" },
        };
        return data;
    }
}
