/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.palette;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.jface.resource.ImageDescriptor;

public class PaletteStack
extends PaletteContainer {
    private final PropertyChangeListener childListener = evt -> {
        if (evt.getPropertyName().equals("Visible") && evt.getNewValue() == Boolean.FALSE && this.activeEntry == evt.getSource()) {
            this.checkActiveEntry();
        }
    };
    public static final String PALETTE_TYPE_STACK = "$PaletteStack";
    public static final String PROPERTY_ACTIVE_ENTRY = "Active Entry";
    private PaletteEntry activeEntry;

    public PaletteStack(String name, String desc, ImageDescriptor icon) {
        super(name, desc, icon, PALETTE_TYPE_STACK);
        this.setUserModificationPermission(7);
    }

    @Override
    public boolean acceptsType(Object type) {
        if (!type.equals(ToolEntry.PALETTE_TYPE_TOOL)) {
            return false;
        }
        return super.acceptsType(type);
    }

    @Override
    public void add(int index, PaletteEntry entry) {
        super.add(index, entry);
        this.checkActiveEntry();
    }

    @Override
    public void addAll(List<? extends PaletteEntry> list) {
        super.addAll(list);
        this.checkActiveEntry();
        this.updateListeners(list, true);
    }

    private void checkActiveEntry() {
        PaletteEntry currEntry = this.activeEntry;
        if (!this.getChildren().contains(this.activeEntry)) {
            this.activeEntry = null;
        }
        if (this.activeEntry == null && !this.getChildren().isEmpty()) {
            this.activeEntry = this.getChildren().get(0);
        }
        if (this.activeEntry != null && !this.activeEntry.isVisible()) {
            for (PaletteEntry paletteEntry : this.getChildren()) {
                if (paletteEntry.isVisible()) {
                    this.activeEntry = paletteEntry;
                    break;
                }
                this.activeEntry = null;
            }
        }
        this.listeners.firePropertyChange(PROPERTY_ACTIVE_ENTRY, currEntry, this.activeEntry);
    }

    public PaletteEntry getActiveEntry() {
        this.checkActiveEntry();
        return this.activeEntry;
    }

    @Override
    public void remove(PaletteEntry entry) {
        super.remove(entry);
        this.checkActiveEntry();
        this.updateListeners(Collections.singletonList(entry), false);
    }

    public void setActiveEntry(PaletteEntry entry) {
        PaletteEntry oldEntry = this.activeEntry;
        if (this.activeEntry != null && (this.activeEntry.equals(entry) || !this.getChildren().contains(entry))) {
            return;
        }
        this.activeEntry = entry;
        this.listeners.firePropertyChange(PROPERTY_ACTIVE_ENTRY, oldEntry, this.activeEntry);
    }

    @Override
    public void add(PaletteEntry entry) {
        super.add(entry);
        this.updateListeners(Collections.singletonList(entry), true);
    }

    @Override
    public void setChildren(List<PaletteEntry> list) {
        this.updateListeners(this.getChildren(), false);
        super.setChildren(list);
        this.updateListeners(this.getChildren(), true);
        this.checkActiveEntry();
    }

    private void updateListeners(Collection<? extends PaletteEntry> entries, boolean add) {
        for (PaletteEntry paletteEntry : entries) {
            if (add) {
                paletteEntry.addPropertyChangeListener(this.childListener);
                continue;
            }
            paletteEntry.removePropertyChangeListener(this.childListener);
        }
    }
}

