/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceProviderSynchronizable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.AbstractDataSourceHandler;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceInvalidateHandler;
import org.jkiss.dbeaver.ui.dialogs.MessageBoxBuilder;
import org.jkiss.dbeaver.ui.dialogs.Reply;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DataSourceSynchronizeHandler
extends AbstractDataSourceHandler {
    private static final Reply REPLY_KEEP_LOCAL_CHANGES = new Reply(CoreMessages.dialog_data_source_synchronize_reply_keep_local_label);
    private static final Reply REPLY_KEEP_REMOTE_CHANGES = new Reply(CoreMessages.dialog_data_source_synchronize_reply_keep_remote_label);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        DBCExecutionContext context = DataSourceSynchronizeHandler.getActiveExecutionContext((ExecutionEvent)event, (boolean)false);
        if (context == null) {
            return null;
        }
        final DBPDataSource dataSource = context.getDataSource();
        final DBPDataSourceContainer dataSourceContainer = dataSource.getContainer();
        final DBPDataSourceProviderSynchronizable dataSourceProvider = (DBPDataSourceProviderSynchronizable)dataSourceContainer.getDriver().getDataSourceProvider();
        new AbstractJob("Synchronize data source [" + dataSource.getName() + "]"){

            protected IStatus run(DBRProgressMonitor monitor) {
                try {
                    boolean localSynchronized = dataSourceProvider.isLocalDataSourceSynchronized(monitor, dataSourceContainer);
                    boolean remoteSynchronized = dataSourceProvider.isRemoteDataSourceSynchronized(monitor, dataSourceContainer);
                    if (localSynchronized != remoteSynchronized) {
                        Reply[] reply = new Reply[1];
                        UIUtils.syncExec(() -> {
                            Reply reply = MessageBoxBuilder.builder().setTitle(CoreMessages.dialog_data_source_synchronize_title).setMessage(NLS.bind((String)CoreMessages.dialog_data_source_synchronize_message, (Object)dataSource.getName())).setPrimaryImage((DBPImage)DBIcon.STATUS_QUESTION).setReplies(new Reply[]{REPLY_KEEP_LOCAL_CHANGES, REPLY_KEEP_REMOTE_CHANGES, Reply.CANCEL}).setDefaultReply(Reply.CANCEL).showMessageBox();
                        });
                        if (reply[0] == REPLY_KEEP_LOCAL_CHANGES) {
                            dataSourceProvider.syncRemoteDataSource(monitor, dataSourceContainer);
                        } else if (reply[0] == REPLY_KEEP_REMOTE_CHANGES) {
                            dataSourceProvider.syncLocalDataSource(monitor, dataSourceContainer);
                            DataSourceInvalidateHandler.invalidateDataSource(dataSourceContainer.getDataSource());
                        }
                    }
                    return Status.OK_STATUS;
                }
                catch (DBException e) {
                    return GeneralUtils.makeExceptionStatus((Throwable)e);
                }
            }
        }.schedule();
        return null;
    }
}

