/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.lightgrid;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UITextUtils;
import org.jkiss.dbeaver.ui.controls.lightgrid.AbstractRenderer;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridColumn;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridContentProvider;
import org.jkiss.dbeaver.ui.controls.lightgrid.IGridItem;
import org.jkiss.dbeaver.ui.controls.lightgrid.LightGrid;
import org.jkiss.utils.CommonUtils;

class GridColumnRenderer
extends AbstractRenderer {
    public static final int LEFT_MARGIN = 6;
    public static final int RIGHT_MARGIN = 6;
    public static final int BOTTOM_MARGIN = 6;
    public static final int TOP_MARGIN = 4;
    public static final int ARROW_MARGIN = 6;
    public static final int IMAGE_SPACING = 3;
    public static final Image IMAGE_ASTERISK = DBeaverIcons.getImage((DBPImage)UIIcon.SORT_UNKNOWN);
    public static final Image IMAGE_DESC = DBeaverIcons.getImage((DBPImage)UIIcon.SORT_INCREASE);
    public static final Image IMAGE_ASC = DBeaverIcons.getImage((DBPImage)UIIcon.SORT_DECREASE);
    public static final Image IMAGE_FILTER = DBeaverIcons.getImage((DBPImage)UIIcon.DROP_DOWN);
    public static final int SORT_WIDTH = GridColumnRenderer.IMAGE_DESC.getBounds().width;
    public static final int SORT_HEIGHT = GridColumnRenderer.IMAGE_DESC.getBounds().height;
    public static final int FILTER_WIDTH = GridColumnRenderer.IMAGE_FILTER.getBounds().width;
    private static final boolean PAINT_COLUMN_FOCUS_BORDER = true;
    private static final boolean SHIFT_PAINT_ON_SELECTION = false;

    public GridColumnRenderer(LightGrid grid) {
        super(grid);
    }

    public static Rectangle getSortControlBounds() {
        return IMAGE_DESC.getBounds();
    }

    public static Rectangle getFilterControlBounds() {
        return IMAGE_FILTER.getBounds();
    }

    @Nullable
    protected Image getColumnImage(IGridItem element) {
        return this.grid.getLabelProvider().getImage(element);
    }

    protected String getColumnText(IGridItem item) {
        return this.grid.getLabelProvider().getText(item);
    }

    protected String getColumnDescription(IGridColumn item) {
        return this.grid.getLabelProvider().getDescription(item);
    }

    protected Font getColumnFont(IGridColumn element) {
        Font font = this.grid.getLabelProvider().getFont(element);
        return font != null ? font : this.grid.normalFont;
    }

    public void paint(GC gc, Rectangle bounds, boolean selected, boolean hovering, GridColumn element) {
        IGridContentProvider contentProvider;
        boolean hasFilters;
        boolean isFocused;
        GridColumn.HintsInfo hintInfo = element.getHintInfo();
        gc.setBackground(this.grid.getLabelProvider().getHeaderBackground(element, selected || hovering));
        gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
        boolean bl = isFocused = element == this.grid.getFocusColumn();
        if (isFocused) {
            gc.setForeground(this.getDisplay().getSystemColor(18));
            gc.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
            gc.drawLine(bounds.x, bounds.y, bounds.x, bounds.y + bounds.height - 1);
            gc.drawLine(bounds.x + bounds.width - 1, bounds.y, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
            gc.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
        } else {
            gc.setForeground(this.grid.getLabelProvider().getHeaderBorder(element));
            gc.drawLine(bounds.x + bounds.width - 1, bounds.y, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
            gc.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
        }
        if (hintInfo.readOnly) {
            gc.setForeground(this.grid.getLabelProvider().getHeaderReadOnlyColor());
            gc.setLineWidth(1);
            gc.drawLine(isFocused ? bounds.x + 1 : bounds.x, bounds.y + bounds.height - 2, bounds.x + bounds.width - 2, bounds.y + bounds.height - 2);
            gc.setLineWidth(1);
        }
        bounds.x += 6;
        bounds.y += 4;
        bounds.width -= 12;
        bounds.height -= 10;
        int fontHeight = this.grid.fontMetrics.getHeight();
        Image columnImage = this.getColumnImage(element);
        if (columnImage != null) {
            Rectangle imageBounds = columnImage.getBounds();
            gc.drawImage(columnImage, bounds.x, bounds.y);
            int width = imageBounds.width + 3;
            bounds.x += width;
            bounds.width -= width;
        }
        if (!CommonUtils.isEmpty(hintInfo.icons)) {
            int hy = bounds.y;
            if (hintInfo.icons.size() > 1) {
                hy -= 4;
            }
            int maxWidth = 0;
            for (DBPImage hi : hintInfo.icons) {
                Image hintImage = DBeaverIcons.getImage((DBPImage)hi);
                Rectangle imageBounds = hintImage.getBounds();
                if (hintInfo.icons.size() == 1) {
                    hy = (bounds.height - imageBounds.height) / 2;
                }
                gc.drawImage(hintImage, bounds.x, hy);
                maxWidth = Math.max(maxWidth, imageBounds.width);
                hy += imageBounds.height + 1;
            }
            if (maxWidth > 0) {
                maxWidth += 3;
            }
            bounds.x += maxWidth;
            bounds.width -= maxWidth;
        }
        if (hasFilters = (contentProvider = this.grid.getContentProvider()).isElementSupportsFilter(element)) {
            bounds.width -= GridColumnRenderer.getFilterControlBounds().width;
            gc.drawImage(IMAGE_FILTER, bounds.x + bounds.width, bounds.y);
            bounds.width -= 3;
        }
        int sortOrder = contentProvider.getSortOrder(element);
        boolean showSortIconAlways = contentProvider.isElementSupportsSort(element);
        if (showSortIconAlways || sortOrder > 0) {
            bounds.width -= GridColumnRenderer.getSortControlBounds().width;
            GridColumnRenderer.paintSort(gc, new Rectangle(bounds.x + bounds.width, bounds.y, 0, 0), sortOrder, showSortIconAlways);
            bounds.width -= 3;
        }
        gc.setForeground(this.grid.getLabelProvider().getHeaderForeground(element, selected || hovering));
        String text = UITextUtils.getShortString((FontMetrics)this.grid.fontMetrics, (String)this.getColumnText(element), (int)bounds.width);
        gc.setFont(this.getColumnFont(element));
        gc.setClipping(bounds.x, bounds.y, bounds.width, fontHeight);
        gc.drawString(text, bounds.x, bounds.y, true);
        gc.setClipping(null);
        text = this.getColumnDescription(element);
        if (!CommonUtils.isEmpty((String)text)) {
            text = UITextUtils.getShortString((FontMetrics)this.grid.fontMetrics, (String)text, (int)bounds.width);
            bounds.y += 4 + fontHeight;
            gc.setForeground(this.grid.getLabelProvider().getHeaderForeground(element, selected || hovering));
            gc.setFont(this.grid.commentFont);
            gc.setClipping(bounds.x, bounds.y, bounds.width, fontHeight);
            gc.drawString(text, bounds.x, bounds.y, true);
            gc.setClipping(null);
        }
        gc.setFont(this.grid.normalFont);
    }

    public static void paintSort(GC gc, Rectangle bounds, int sort, boolean forcePaintDefault) {
        switch (sort) {
            case -1: {
                if (!forcePaintDefault) break;
                gc.drawImage(IMAGE_ASTERISK, bounds.x, bounds.y);
                break;
            }
            case 128: {
                gc.drawImage(IMAGE_ASC, bounds.x, bounds.y);
                break;
            }
            case 1024: {
                gc.drawImage(IMAGE_DESC, bounds.x, bounds.y);
            }
        }
    }
}

