//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
#[cfg(feature = "objc2-core-graphics")]
use objc2_core_graphics::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/calayercontentsgravity?language=objc)
// NS_TYPED_ENUM
pub type CALayerContentsGravity = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/calayercontentsformat?language=objc)
// NS_TYPED_ENUM
pub type CALayerContentsFormat = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/calayercontentsfilter?language=objc)
// NS_TYPED_ENUM
pub type CALayerContentsFilter = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/calayercornercurve?language=objc)
// NS_TYPED_ENUM
pub type CALayerCornerCurve = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/caautoresizingmask?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CAAutoresizingMask(pub c_uint);
bitflags::bitflags! {
    impl CAAutoresizingMask: c_uint {
        #[doc(alias = "kCALayerNotSizable")]
        const LayerNotSizable = 0;
        #[doc(alias = "kCALayerMinXMargin")]
        const LayerMinXMargin = 1<<0;
        #[doc(alias = "kCALayerWidthSizable")]
        const LayerWidthSizable = 1<<1;
        #[doc(alias = "kCALayerMaxXMargin")]
        const LayerMaxXMargin = 1<<2;
        #[doc(alias = "kCALayerMinYMargin")]
        const LayerMinYMargin = 1<<3;
        #[doc(alias = "kCALayerHeightSizable")]
        const LayerHeightSizable = 1<<4;
        #[doc(alias = "kCALayerMaxYMargin")]
        const LayerMaxYMargin = 1<<5;
    }
}

unsafe impl Encode for CAAutoresizingMask {
    const ENCODING: Encoding = c_uint::ENCODING;
}

unsafe impl RefEncode for CAAutoresizingMask {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/catonemapmode?language=objc)
// NS_TYPED_ENUM
pub type CAToneMapMode = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/catonemapmodeautomatic?language=objc)
    pub static CAToneMapModeAutomatic: &'static CAToneMapMode;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/catonemapmodenever?language=objc)
    pub static CAToneMapModeNever: &'static CAToneMapMode;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/catonemapmodeifsupported?language=objc)
    pub static CAToneMapModeIfSupported: &'static CAToneMapMode;
}

/// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/cadynamicrange?language=objc)
// NS_TYPED_ENUM
pub type CADynamicRange = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/cadynamicrangeautomatic?language=objc)
    pub static CADynamicRangeAutomatic: &'static CADynamicRange;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/cadynamicrangestandard?language=objc)
    pub static CADynamicRangeStandard: &'static CADynamicRange;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/cadynamicrangeconstrainedhigh?language=objc)
    pub static CADynamicRangeConstrainedHigh: &'static CADynamicRange;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/cadynamicrangehigh?language=objc)
    pub static CADynamicRangeHigh: &'static CADynamicRange;
}

/// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/caedgeantialiasingmask?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CAEdgeAntialiasingMask(pub c_uint);
bitflags::bitflags! {
    impl CAEdgeAntialiasingMask: c_uint {
        #[doc(alias = "kCALayerLeftEdge")]
        const LayerLeftEdge = 1<<0;
        #[doc(alias = "kCALayerRightEdge")]
        const LayerRightEdge = 1<<1;
        #[doc(alias = "kCALayerBottomEdge")]
        const LayerBottomEdge = 1<<2;
        #[doc(alias = "kCALayerTopEdge")]
        const LayerTopEdge = 1<<3;
    }
}

unsafe impl Encode for CAEdgeAntialiasingMask {
    const ENCODING: Encoding = c_uint::ENCODING;
}

unsafe impl RefEncode for CAEdgeAntialiasingMask {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/cacornermask?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CACornerMask(pub NSUInteger);
bitflags::bitflags! {
    impl CACornerMask: NSUInteger {
        #[doc(alias = "kCALayerMinXMinYCorner")]
        const LayerMinXMinYCorner = 1<<0;
        #[doc(alias = "kCALayerMaxXMinYCorner")]
        const LayerMaxXMinYCorner = 1<<1;
        #[doc(alias = "kCALayerMinXMaxYCorner")]
        const LayerMinXMaxYCorner = 1<<2;
        #[doc(alias = "kCALayerMaxXMaxYCorner")]
        const LayerMaxXMaxYCorner = 1<<3;
    }
}

unsafe impl Encode for CACornerMask {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for CACornerMask {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// The base layer class. *
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/quartzcore/calayer?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CALayer;
);

#[cfg(feature = "CAMediaTiming")]
extern_conformance!(
    unsafe impl CAMediaTiming for CALayer {}
);

extern_conformance!(
    unsafe impl NSCoding for CALayer {}
);

extern_conformance!(
    unsafe impl NSObjectProtocol for CALayer {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CALayer {}
);

impl CALayer {
    extern_methods!(
        /// Layer creation and initialization. *
        #[unsafe(method(layer))]
        #[unsafe(method_family = none)]
        pub fn layer() -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        /// # Safety
        ///
        /// `layer` should be of the correct type.
        #[unsafe(method(initWithLayer:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithLayer(this: Allocated<Self>, layer: &AnyObject) -> Retained<Self>;

        #[unsafe(method(presentationLayer))]
        #[unsafe(method_family = none)]
        pub unsafe fn presentationLayer(&self) -> Option<Retained<Self>>;

        #[unsafe(method(modelLayer))]
        #[unsafe(method_family = none)]
        pub unsafe fn modelLayer(&self) -> Retained<Self>;

        /// Property methods. *
        #[unsafe(method(defaultValueForKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn defaultValueForKey(key: &NSString) -> Option<Retained<AnyObject>>;

        #[unsafe(method(needsDisplayForKey:))]
        #[unsafe(method_family = none)]
        pub fn needsDisplayForKey(key: &NSString) -> bool;

        #[unsafe(method(shouldArchiveValueForKey:))]
        #[unsafe(method_family = none)]
        pub fn shouldArchiveValueForKey(&self, key: &NSString) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        /// Geometry and layer hierarchy properties. *
        #[unsafe(method(bounds))]
        #[unsafe(method_family = none)]
        pub fn bounds(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`bounds`][Self::bounds].
        #[unsafe(method(setBounds:))]
        #[unsafe(method_family = none)]
        pub fn setBounds(&self, bounds: CGRect);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(position))]
        #[unsafe(method_family = none)]
        pub fn position(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`position`][Self::position].
        #[unsafe(method(setPosition:))]
        #[unsafe(method_family = none)]
        pub fn setPosition(&self, position: CGPoint);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(zPosition))]
        #[unsafe(method_family = none)]
        pub fn zPosition(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`zPosition`][Self::zPosition].
        #[unsafe(method(setZPosition:))]
        #[unsafe(method_family = none)]
        pub fn setZPosition(&self, z_position: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(anchorPoint))]
        #[unsafe(method_family = none)]
        pub fn anchorPoint(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`anchorPoint`][Self::anchorPoint].
        #[unsafe(method(setAnchorPoint:))]
        #[unsafe(method_family = none)]
        pub fn setAnchorPoint(&self, anchor_point: CGPoint);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(anchorPointZ))]
        #[unsafe(method_family = none)]
        pub fn anchorPointZ(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`anchorPointZ`][Self::anchorPointZ].
        #[unsafe(method(setAnchorPointZ:))]
        #[unsafe(method_family = none)]
        pub fn setAnchorPointZ(&self, anchor_point_z: CGFloat);

        #[cfg(all(feature = "CATransform3D", feature = "objc2-core-foundation"))]
        #[unsafe(method(transform))]
        #[unsafe(method_family = none)]
        pub fn transform(&self) -> CATransform3D;

        #[cfg(all(feature = "CATransform3D", feature = "objc2-core-foundation"))]
        /// Setter for [`transform`][Self::transform].
        #[unsafe(method(setTransform:))]
        #[unsafe(method_family = none)]
        pub fn setTransform(&self, transform: CATransform3D);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(affineTransform))]
        #[unsafe(method_family = none)]
        pub fn affineTransform(&self) -> CGAffineTransform;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setAffineTransform:))]
        #[unsafe(method_family = none)]
        pub fn setAffineTransform(&self, m: CGAffineTransform);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(frame))]
        #[unsafe(method_family = none)]
        pub fn frame(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`frame`][Self::frame].
        #[unsafe(method(setFrame:))]
        #[unsafe(method_family = none)]
        pub fn setFrame(&self, frame: CGRect);

        #[unsafe(method(isHidden))]
        #[unsafe(method_family = none)]
        pub fn isHidden(&self) -> bool;

        /// Setter for [`isHidden`][Self::isHidden].
        #[unsafe(method(setHidden:))]
        #[unsafe(method_family = none)]
        pub fn setHidden(&self, hidden: bool);

        #[unsafe(method(isDoubleSided))]
        #[unsafe(method_family = none)]
        pub fn isDoubleSided(&self) -> bool;

        /// Setter for [`isDoubleSided`][Self::isDoubleSided].
        #[unsafe(method(setDoubleSided:))]
        #[unsafe(method_family = none)]
        pub fn setDoubleSided(&self, double_sided: bool);

        #[unsafe(method(isGeometryFlipped))]
        #[unsafe(method_family = none)]
        pub fn isGeometryFlipped(&self) -> bool;

        /// Setter for [`isGeometryFlipped`][Self::isGeometryFlipped].
        #[unsafe(method(setGeometryFlipped:))]
        #[unsafe(method_family = none)]
        pub fn setGeometryFlipped(&self, geometry_flipped: bool);

        #[unsafe(method(contentsAreFlipped))]
        #[unsafe(method_family = none)]
        pub fn contentsAreFlipped(&self) -> bool;

        #[unsafe(method(superlayer))]
        #[unsafe(method_family = none)]
        pub fn superlayer(&self) -> Option<Retained<CALayer>>;

        #[unsafe(method(removeFromSuperlayer))]
        #[unsafe(method_family = none)]
        pub fn removeFromSuperlayer(&self);

        #[unsafe(method(sublayers))]
        #[unsafe(method_family = none)]
        pub unsafe fn sublayers(&self) -> Option<Retained<NSArray<CALayer>>>;

        /// Setter for [`sublayers`][Self::sublayers].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSublayers:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSublayers(&self, sublayers: Option<&NSArray<CALayer>>);

        #[unsafe(method(addSublayer:))]
        #[unsafe(method_family = none)]
        pub fn addSublayer(&self, layer: &CALayer);

        #[unsafe(method(insertSublayer:atIndex:))]
        #[unsafe(method_family = none)]
        pub fn insertSublayer_atIndex(&self, layer: &CALayer, idx: c_uint);

        #[unsafe(method(insertSublayer:below:))]
        #[unsafe(method_family = none)]
        pub fn insertSublayer_below(&self, layer: &CALayer, sibling: Option<&CALayer>);

        #[unsafe(method(insertSublayer:above:))]
        #[unsafe(method_family = none)]
        pub fn insertSublayer_above(&self, layer: &CALayer, sibling: Option<&CALayer>);

        #[unsafe(method(replaceSublayer:with:))]
        #[unsafe(method_family = none)]
        pub unsafe fn replaceSublayer_with(&self, old_layer: &CALayer, new_layer: &CALayer);

        #[cfg(all(feature = "CATransform3D", feature = "objc2-core-foundation"))]
        #[unsafe(method(sublayerTransform))]
        #[unsafe(method_family = none)]
        pub fn sublayerTransform(&self) -> CATransform3D;

        #[cfg(all(feature = "CATransform3D", feature = "objc2-core-foundation"))]
        /// Setter for [`sublayerTransform`][Self::sublayerTransform].
        #[unsafe(method(setSublayerTransform:))]
        #[unsafe(method_family = none)]
        pub fn setSublayerTransform(&self, sublayer_transform: CATransform3D);

        #[unsafe(method(mask))]
        #[unsafe(method_family = none)]
        pub fn mask(&self) -> Option<Retained<CALayer>>;

        /// Setter for [`mask`][Self::mask].
        #[unsafe(method(setMask:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMask(&self, mask: Option<&CALayer>);

        #[unsafe(method(masksToBounds))]
        #[unsafe(method_family = none)]
        pub fn masksToBounds(&self) -> bool;

        /// Setter for [`masksToBounds`][Self::masksToBounds].
        #[unsafe(method(setMasksToBounds:))]
        #[unsafe(method_family = none)]
        pub fn setMasksToBounds(&self, masks_to_bounds: bool);

        #[cfg(feature = "objc2-core-foundation")]
        /// Mapping between layer coordinate and time spaces. *
        #[unsafe(method(convertPoint:fromLayer:))]
        #[unsafe(method_family = none)]
        pub fn convertPoint_fromLayer(&self, p: CGPoint, l: Option<&CALayer>) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(convertPoint:toLayer:))]
        #[unsafe(method_family = none)]
        pub fn convertPoint_toLayer(&self, p: CGPoint, l: Option<&CALayer>) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(convertRect:fromLayer:))]
        #[unsafe(method_family = none)]
        pub fn convertRect_fromLayer(&self, r: CGRect, l: Option<&CALayer>) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(convertRect:toLayer:))]
        #[unsafe(method_family = none)]
        pub fn convertRect_toLayer(&self, r: CGRect, l: Option<&CALayer>) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(convertTime:fromLayer:))]
        #[unsafe(method_family = none)]
        pub fn convertTime_fromLayer(
            &self,
            t: CFTimeInterval,
            l: Option<&CALayer>,
        ) -> CFTimeInterval;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(convertTime:toLayer:))]
        #[unsafe(method_family = none)]
        pub fn convertTime_toLayer(&self, t: CFTimeInterval, l: Option<&CALayer>)
            -> CFTimeInterval;

        #[cfg(feature = "objc2-core-foundation")]
        /// Hit testing methods. *
        #[unsafe(method(hitTest:))]
        #[unsafe(method_family = none)]
        pub fn hitTest(&self, p: CGPoint) -> Option<Retained<CALayer>>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(containsPoint:))]
        #[unsafe(method_family = none)]
        pub fn containsPoint(&self, p: CGPoint) -> bool;

        /// Layer content properties and methods. *
        #[unsafe(method(contents))]
        #[unsafe(method_family = none)]
        pub unsafe fn contents(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`contents`][Self::contents].
        ///
        /// # Safety
        ///
        /// `contents` should be of the correct type.
        #[unsafe(method(setContents:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContents(&self, contents: Option<&AnyObject>);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(contentsRect))]
        #[unsafe(method_family = none)]
        pub fn contentsRect(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`contentsRect`][Self::contentsRect].
        #[unsafe(method(setContentsRect:))]
        #[unsafe(method_family = none)]
        pub fn setContentsRect(&self, contents_rect: CGRect);

        #[unsafe(method(contentsGravity))]
        #[unsafe(method_family = none)]
        pub fn contentsGravity(&self) -> Retained<CALayerContentsGravity>;

        /// Setter for [`contentsGravity`][Self::contentsGravity].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setContentsGravity:))]
        #[unsafe(method_family = none)]
        pub fn setContentsGravity(&self, contents_gravity: &CALayerContentsGravity);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(contentsScale))]
        #[unsafe(method_family = none)]
        pub fn contentsScale(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`contentsScale`][Self::contentsScale].
        #[unsafe(method(setContentsScale:))]
        #[unsafe(method_family = none)]
        pub fn setContentsScale(&self, contents_scale: CGFloat);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(contentsCenter))]
        #[unsafe(method_family = none)]
        pub fn contentsCenter(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`contentsCenter`][Self::contentsCenter].
        #[unsafe(method(setContentsCenter:))]
        #[unsafe(method_family = none)]
        pub fn setContentsCenter(&self, contents_center: CGRect);

        #[unsafe(method(contentsFormat))]
        #[unsafe(method_family = none)]
        pub fn contentsFormat(&self) -> Retained<CALayerContentsFormat>;

        /// Setter for [`contentsFormat`][Self::contentsFormat].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setContentsFormat:))]
        #[unsafe(method_family = none)]
        pub fn setContentsFormat(&self, contents_format: &CALayerContentsFormat);

        #[deprecated = "Use preferredDynamicRange instead"]
        #[unsafe(method(wantsExtendedDynamicRangeContent))]
        #[unsafe(method_family = none)]
        pub fn wantsExtendedDynamicRangeContent(&self) -> bool;

        /// Setter for [`wantsExtendedDynamicRangeContent`][Self::wantsExtendedDynamicRangeContent].
        #[deprecated = "Use preferredDynamicRange instead"]
        #[unsafe(method(setWantsExtendedDynamicRangeContent:))]
        #[unsafe(method_family = none)]
        pub fn setWantsExtendedDynamicRangeContent(
            &self,
            wants_extended_dynamic_range_content: bool,
        );

        #[unsafe(method(toneMapMode))]
        #[unsafe(method_family = none)]
        pub fn toneMapMode(&self) -> Retained<CAToneMapMode>;

        /// Setter for [`toneMapMode`][Self::toneMapMode].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setToneMapMode:))]
        #[unsafe(method_family = none)]
        pub fn setToneMapMode(&self, tone_map_mode: &CAToneMapMode);

        #[unsafe(method(preferredDynamicRange))]
        #[unsafe(method_family = none)]
        pub fn preferredDynamicRange(&self) -> Retained<CADynamicRange>;

        /// Setter for [`preferredDynamicRange`][Self::preferredDynamicRange].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setPreferredDynamicRange:))]
        #[unsafe(method_family = none)]
        pub fn setPreferredDynamicRange(&self, preferred_dynamic_range: &CADynamicRange);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(contentsHeadroom))]
        #[unsafe(method_family = none)]
        pub fn contentsHeadroom(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`contentsHeadroom`][Self::contentsHeadroom].
        #[unsafe(method(setContentsHeadroom:))]
        #[unsafe(method_family = none)]
        pub fn setContentsHeadroom(&self, contents_headroom: CGFloat);

        #[unsafe(method(wantsDynamicContentScaling))]
        #[unsafe(method_family = none)]
        pub fn wantsDynamicContentScaling(&self) -> bool;

        /// Setter for [`wantsDynamicContentScaling`][Self::wantsDynamicContentScaling].
        #[unsafe(method(setWantsDynamicContentScaling:))]
        #[unsafe(method_family = none)]
        pub fn setWantsDynamicContentScaling(&self, wants_dynamic_content_scaling: bool);

        #[unsafe(method(minificationFilter))]
        #[unsafe(method_family = none)]
        pub fn minificationFilter(&self) -> Retained<CALayerContentsFilter>;

        /// Setter for [`minificationFilter`][Self::minificationFilter].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setMinificationFilter:))]
        #[unsafe(method_family = none)]
        pub fn setMinificationFilter(&self, minification_filter: &CALayerContentsFilter);

        #[unsafe(method(magnificationFilter))]
        #[unsafe(method_family = none)]
        pub fn magnificationFilter(&self) -> Retained<CALayerContentsFilter>;

        /// Setter for [`magnificationFilter`][Self::magnificationFilter].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setMagnificationFilter:))]
        #[unsafe(method_family = none)]
        pub fn setMagnificationFilter(&self, magnification_filter: &CALayerContentsFilter);

        #[unsafe(method(minificationFilterBias))]
        #[unsafe(method_family = none)]
        pub fn minificationFilterBias(&self) -> c_float;

        /// Setter for [`minificationFilterBias`][Self::minificationFilterBias].
        #[unsafe(method(setMinificationFilterBias:))]
        #[unsafe(method_family = none)]
        pub fn setMinificationFilterBias(&self, minification_filter_bias: c_float);

        #[unsafe(method(isOpaque))]
        #[unsafe(method_family = none)]
        pub fn isOpaque(&self) -> bool;

        /// Setter for [`isOpaque`][Self::isOpaque].
        #[unsafe(method(setOpaque:))]
        #[unsafe(method_family = none)]
        pub fn setOpaque(&self, opaque: bool);

        #[unsafe(method(display))]
        #[unsafe(method_family = none)]
        pub fn display(&self);

        #[unsafe(method(setNeedsDisplay))]
        #[unsafe(method_family = none)]
        pub fn setNeedsDisplay(&self);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(setNeedsDisplayInRect:))]
        #[unsafe(method_family = none)]
        pub fn setNeedsDisplayInRect(&self, r: CGRect);

        #[unsafe(method(needsDisplay))]
        #[unsafe(method_family = none)]
        pub fn needsDisplay(&self) -> bool;

        #[unsafe(method(displayIfNeeded))]
        #[unsafe(method_family = none)]
        pub fn displayIfNeeded(&self);

        #[unsafe(method(needsDisplayOnBoundsChange))]
        #[unsafe(method_family = none)]
        pub fn needsDisplayOnBoundsChange(&self) -> bool;

        /// Setter for [`needsDisplayOnBoundsChange`][Self::needsDisplayOnBoundsChange].
        #[unsafe(method(setNeedsDisplayOnBoundsChange:))]
        #[unsafe(method_family = none)]
        pub fn setNeedsDisplayOnBoundsChange(&self, needs_display_on_bounds_change: bool);

        #[unsafe(method(drawsAsynchronously))]
        #[unsafe(method_family = none)]
        pub fn drawsAsynchronously(&self) -> bool;

        /// Setter for [`drawsAsynchronously`][Self::drawsAsynchronously].
        #[unsafe(method(setDrawsAsynchronously:))]
        #[unsafe(method_family = none)]
        pub fn setDrawsAsynchronously(&self, draws_asynchronously: bool);

        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(drawInContext:))]
        #[unsafe(method_family = none)]
        pub fn drawInContext(&self, ctx: &CGContext);

        #[cfg(feature = "objc2-core-graphics")]
        /// Rendering properties and methods. *
        #[unsafe(method(renderInContext:))]
        #[unsafe(method_family = none)]
        pub fn renderInContext(&self, ctx: &CGContext);

        #[unsafe(method(edgeAntialiasingMask))]
        #[unsafe(method_family = none)]
        pub fn edgeAntialiasingMask(&self) -> CAEdgeAntialiasingMask;

        /// Setter for [`edgeAntialiasingMask`][Self::edgeAntialiasingMask].
        #[unsafe(method(setEdgeAntialiasingMask:))]
        #[unsafe(method_family = none)]
        pub fn setEdgeAntialiasingMask(&self, edge_antialiasing_mask: CAEdgeAntialiasingMask);

        #[unsafe(method(allowsEdgeAntialiasing))]
        #[unsafe(method_family = none)]
        pub fn allowsEdgeAntialiasing(&self) -> bool;

        /// Setter for [`allowsEdgeAntialiasing`][Self::allowsEdgeAntialiasing].
        #[unsafe(method(setAllowsEdgeAntialiasing:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsEdgeAntialiasing(&self, allows_edge_antialiasing: bool);

        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(backgroundColor))]
        #[unsafe(method_family = none)]
        pub fn backgroundColor(&self) -> Option<Retained<CGColor>>;

        #[cfg(feature = "objc2-core-graphics")]
        /// Setter for [`backgroundColor`][Self::backgroundColor].
        #[unsafe(method(setBackgroundColor:))]
        #[unsafe(method_family = none)]
        pub fn setBackgroundColor(&self, background_color: Option<&CGColor>);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(cornerRadius))]
        #[unsafe(method_family = none)]
        pub fn cornerRadius(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`cornerRadius`][Self::cornerRadius].
        #[unsafe(method(setCornerRadius:))]
        #[unsafe(method_family = none)]
        pub fn setCornerRadius(&self, corner_radius: CGFloat);

        #[unsafe(method(maskedCorners))]
        #[unsafe(method_family = none)]
        pub fn maskedCorners(&self) -> CACornerMask;

        /// Setter for [`maskedCorners`][Self::maskedCorners].
        #[unsafe(method(setMaskedCorners:))]
        #[unsafe(method_family = none)]
        pub fn setMaskedCorners(&self, masked_corners: CACornerMask);

        #[unsafe(method(cornerCurve))]
        #[unsafe(method_family = none)]
        pub fn cornerCurve(&self) -> Retained<CALayerCornerCurve>;

        /// Setter for [`cornerCurve`][Self::cornerCurve].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setCornerCurve:))]
        #[unsafe(method_family = none)]
        pub fn setCornerCurve(&self, corner_curve: &CALayerCornerCurve);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(cornerCurveExpansionFactor:))]
        #[unsafe(method_family = none)]
        pub fn cornerCurveExpansionFactor(curve: &CALayerCornerCurve) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(borderWidth))]
        #[unsafe(method_family = none)]
        pub fn borderWidth(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`borderWidth`][Self::borderWidth].
        #[unsafe(method(setBorderWidth:))]
        #[unsafe(method_family = none)]
        pub fn setBorderWidth(&self, border_width: CGFloat);

        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(borderColor))]
        #[unsafe(method_family = none)]
        pub fn borderColor(&self) -> Option<Retained<CGColor>>;

        #[cfg(feature = "objc2-core-graphics")]
        /// Setter for [`borderColor`][Self::borderColor].
        #[unsafe(method(setBorderColor:))]
        #[unsafe(method_family = none)]
        pub fn setBorderColor(&self, border_color: Option<&CGColor>);

        #[unsafe(method(opacity))]
        #[unsafe(method_family = none)]
        pub fn opacity(&self) -> c_float;

        /// Setter for [`opacity`][Self::opacity].
        #[unsafe(method(setOpacity:))]
        #[unsafe(method_family = none)]
        pub fn setOpacity(&self, opacity: c_float);

        #[unsafe(method(allowsGroupOpacity))]
        #[unsafe(method_family = none)]
        pub fn allowsGroupOpacity(&self) -> bool;

        /// Setter for [`allowsGroupOpacity`][Self::allowsGroupOpacity].
        #[unsafe(method(setAllowsGroupOpacity:))]
        #[unsafe(method_family = none)]
        pub fn setAllowsGroupOpacity(&self, allows_group_opacity: bool);

        #[unsafe(method(compositingFilter))]
        #[unsafe(method_family = none)]
        pub fn compositingFilter(&self) -> Option<Retained<AnyObject>>;

        /// Setter for [`compositingFilter`][Self::compositingFilter].
        ///
        /// # Safety
        ///
        /// `compositing_filter` should be of the correct type.
        #[unsafe(method(setCompositingFilter:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCompositingFilter(&self, compositing_filter: Option<&AnyObject>);

        #[unsafe(method(filters))]
        #[unsafe(method_family = none)]
        pub fn filters(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`filters`][Self::filters].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `filters` generic should be of the correct type.
        #[unsafe(method(setFilters:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setFilters(&self, filters: Option<&NSArray>);

        #[unsafe(method(backgroundFilters))]
        #[unsafe(method_family = none)]
        pub fn backgroundFilters(&self) -> Option<Retained<NSArray>>;

        /// Setter for [`backgroundFilters`][Self::backgroundFilters].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `background_filters` generic should be of the correct type.
        #[unsafe(method(setBackgroundFilters:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBackgroundFilters(&self, background_filters: Option<&NSArray>);

        #[unsafe(method(shouldRasterize))]
        #[unsafe(method_family = none)]
        pub fn shouldRasterize(&self) -> bool;

        /// Setter for [`shouldRasterize`][Self::shouldRasterize].
        #[unsafe(method(setShouldRasterize:))]
        #[unsafe(method_family = none)]
        pub fn setShouldRasterize(&self, should_rasterize: bool);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(rasterizationScale))]
        #[unsafe(method_family = none)]
        pub fn rasterizationScale(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`rasterizationScale`][Self::rasterizationScale].
        #[unsafe(method(setRasterizationScale:))]
        #[unsafe(method_family = none)]
        pub fn setRasterizationScale(&self, rasterization_scale: CGFloat);

        #[cfg(feature = "objc2-core-graphics")]
        /// Shadow properties. *
        #[unsafe(method(shadowColor))]
        #[unsafe(method_family = none)]
        pub fn shadowColor(&self) -> Option<Retained<CGColor>>;

        #[cfg(feature = "objc2-core-graphics")]
        /// Setter for [`shadowColor`][Self::shadowColor].
        #[unsafe(method(setShadowColor:))]
        #[unsafe(method_family = none)]
        pub fn setShadowColor(&self, shadow_color: Option<&CGColor>);

        #[unsafe(method(shadowOpacity))]
        #[unsafe(method_family = none)]
        pub fn shadowOpacity(&self) -> c_float;

        /// Setter for [`shadowOpacity`][Self::shadowOpacity].
        #[unsafe(method(setShadowOpacity:))]
        #[unsafe(method_family = none)]
        pub fn setShadowOpacity(&self, shadow_opacity: c_float);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(shadowOffset))]
        #[unsafe(method_family = none)]
        pub fn shadowOffset(&self) -> CGSize;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`shadowOffset`][Self::shadowOffset].
        #[unsafe(method(setShadowOffset:))]
        #[unsafe(method_family = none)]
        pub fn setShadowOffset(&self, shadow_offset: CGSize);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(shadowRadius))]
        #[unsafe(method_family = none)]
        pub fn shadowRadius(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`shadowRadius`][Self::shadowRadius].
        #[unsafe(method(setShadowRadius:))]
        #[unsafe(method_family = none)]
        pub fn setShadowRadius(&self, shadow_radius: CGFloat);

        #[cfg(feature = "objc2-core-graphics")]
        #[unsafe(method(shadowPath))]
        #[unsafe(method_family = none)]
        pub fn shadowPath(&self) -> Option<Retained<CGPath>>;

        #[cfg(feature = "objc2-core-graphics")]
        /// Setter for [`shadowPath`][Self::shadowPath].
        #[unsafe(method(setShadowPath:))]
        #[unsafe(method_family = none)]
        pub fn setShadowPath(&self, shadow_path: Option<&CGPath>);

        /// Layout methods. *
        #[unsafe(method(autoresizingMask))]
        #[unsafe(method_family = none)]
        pub fn autoresizingMask(&self) -> CAAutoresizingMask;

        /// Setter for [`autoresizingMask`][Self::autoresizingMask].
        #[unsafe(method(setAutoresizingMask:))]
        #[unsafe(method_family = none)]
        pub fn setAutoresizingMask(&self, autoresizing_mask: CAAutoresizingMask);

        #[unsafe(method(layoutManager))]
        #[unsafe(method_family = none)]
        pub fn layoutManager(&self) -> Option<Retained<ProtocolObject<dyn CALayoutManager>>>;

        /// Setter for [`layoutManager`][Self::layoutManager].
        #[unsafe(method(setLayoutManager:))]
        #[unsafe(method_family = none)]
        pub fn setLayoutManager(
            &self,
            layout_manager: Option<&ProtocolObject<dyn CALayoutManager>>,
        );

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(preferredFrameSize))]
        #[unsafe(method_family = none)]
        pub fn preferredFrameSize(&self) -> CGSize;

        #[unsafe(method(setNeedsLayout))]
        #[unsafe(method_family = none)]
        pub fn setNeedsLayout(&self);

        #[unsafe(method(needsLayout))]
        #[unsafe(method_family = none)]
        pub fn needsLayout(&self) -> bool;

        #[unsafe(method(layoutIfNeeded))]
        #[unsafe(method_family = none)]
        pub fn layoutIfNeeded(&self);

        #[unsafe(method(layoutSublayers))]
        #[unsafe(method_family = none)]
        pub fn layoutSublayers(&self);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(resizeSublayersWithOldSize:))]
        #[unsafe(method_family = none)]
        pub fn resizeSublayersWithOldSize(&self, size: CGSize);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(resizeWithOldSuperlayerSize:))]
        #[unsafe(method_family = none)]
        pub fn resizeWithOldSuperlayerSize(&self, size: CGSize);

        /// Action methods. *
        #[unsafe(method(defaultActionForKey:))]
        #[unsafe(method_family = none)]
        pub fn defaultActionForKey(
            event: &NSString,
        ) -> Option<Retained<ProtocolObject<dyn CAAction>>>;

        #[unsafe(method(actionForKey:))]
        #[unsafe(method_family = none)]
        pub fn actionForKey(
            &self,
            event: &NSString,
        ) -> Option<Retained<ProtocolObject<dyn CAAction>>>;

        #[unsafe(method(actions))]
        #[unsafe(method_family = none)]
        pub fn actions(
            &self,
        ) -> Option<Retained<NSDictionary<NSString, ProtocolObject<dyn CAAction>>>>;

        /// Setter for [`actions`][Self::actions].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setActions:))]
        #[unsafe(method_family = none)]
        pub fn setActions(
            &self,
            actions: Option<&NSDictionary<NSString, ProtocolObject<dyn CAAction>>>,
        );

        #[cfg(feature = "CAAnimation")]
        /// Animation methods. *
        #[unsafe(method(addAnimation:forKey:))]
        #[unsafe(method_family = none)]
        pub fn addAnimation_forKey(&self, anim: &CAAnimation, key: Option<&NSString>);

        #[unsafe(method(removeAllAnimations))]
        #[unsafe(method_family = none)]
        pub fn removeAllAnimations(&self);

        #[unsafe(method(removeAnimationForKey:))]
        #[unsafe(method_family = none)]
        pub fn removeAnimationForKey(&self, key: &NSString);

        #[unsafe(method(animationKeys))]
        #[unsafe(method_family = none)]
        pub fn animationKeys(&self) -> Option<Retained<NSArray<NSString>>>;

        #[cfg(feature = "CAAnimation")]
        #[unsafe(method(animationForKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn animationForKey(&self, key: &NSString) -> Option<Retained<CAAnimation>>;

        /// Miscellaneous properties. *
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub fn name(&self) -> Option<Retained<NSString>>;

        /// Setter for [`name`][Self::name].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setName:))]
        #[unsafe(method_family = none)]
        pub fn setName(&self, name: Option<&NSString>);

        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub fn delegate(&self) -> Option<Retained<ProtocolObject<dyn CALayerDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// This is a [weak property][objc2::topics::weak_property].
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn CALayerDelegate>>);

        #[unsafe(method(style))]
        #[unsafe(method_family = none)]
        pub fn style(&self) -> Option<Retained<NSDictionary>>;

        /// Setter for [`style`][Self::style].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        ///
        /// # Safety
        ///
        /// `style` generic should be of the correct type.
        #[unsafe(method(setStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setStyle(&self, style: Option<&NSDictionary>);
    );
}

/// Methods declared on superclass `NSObject`.
impl CALayer {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for CALayer {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern_protocol!(
    /// Layout manager protocol. *
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/quartzcore/calayoutmanager?language=objc)
    pub unsafe trait CALayoutManager: NSObjectProtocol {
        #[cfg(feature = "objc2-core-foundation")]
        #[optional]
        #[unsafe(method(preferredSizeOfLayer:))]
        #[unsafe(method_family = none)]
        fn preferredSizeOfLayer(&self, layer: &CALayer) -> CGSize;

        #[optional]
        #[unsafe(method(invalidateLayoutOfLayer:))]
        #[unsafe(method_family = none)]
        fn invalidateLayoutOfLayer(&self, layer: &CALayer);

        #[optional]
        #[unsafe(method(layoutSublayersOfLayer:))]
        #[unsafe(method_family = none)]
        fn layoutSublayersOfLayer(&self, layer: &CALayer);
    }
);

extern_protocol!(
    /// Action (event handler) protocol. *
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/quartzcore/caaction?language=objc)
    pub unsafe trait CAAction {
        /// # Safety
        ///
        /// - `an_object` should be of the correct type.
        /// - `dict` generic should be of the correct type.
        #[unsafe(method(runActionForKey:object:arguments:))]
        #[unsafe(method_family = none)]
        unsafe fn runActionForKey_object_arguments(
            &self,
            event: &NSString,
            an_object: &AnyObject,
            dict: Option<&NSDictionary>,
        );
    }
);

extern_conformance!(
    unsafe impl CAAction for NSNull {}
);

extern_protocol!(
    /// Delegate methods. *
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/quartzcore/calayerdelegate?language=objc)
    pub unsafe trait CALayerDelegate: NSObjectProtocol {
        #[optional]
        #[unsafe(method(displayLayer:))]
        #[unsafe(method_family = none)]
        fn displayLayer(&self, layer: &CALayer);

        #[cfg(feature = "objc2-core-graphics")]
        #[optional]
        #[unsafe(method(drawLayer:inContext:))]
        #[unsafe(method_family = none)]
        fn drawLayer_inContext(&self, layer: &CALayer, ctx: &CGContext);

        #[optional]
        #[unsafe(method(layerWillDraw:))]
        #[unsafe(method_family = none)]
        fn layerWillDraw(&self, layer: &CALayer);

        #[optional]
        #[unsafe(method(layoutSublayersOfLayer:))]
        #[unsafe(method_family = none)]
        fn layoutSublayersOfLayer(&self, layer: &CALayer);

        #[optional]
        #[unsafe(method(actionForLayer:forKey:))]
        #[unsafe(method_family = none)]
        fn actionForLayer_forKey(
            &self,
            layer: &CALayer,
            event: &NSString,
        ) -> Option<Retained<ProtocolObject<dyn CAAction>>>;
    }
);

extern "C" {
    /// Layer `contentsGravity' values. *
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcagravitycenter?language=objc)
    pub static kCAGravityCenter: &'static CALayerContentsGravity;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcagravitytop?language=objc)
    pub static kCAGravityTop: &'static CALayerContentsGravity;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcagravitybottom?language=objc)
    pub static kCAGravityBottom: &'static CALayerContentsGravity;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcagravityleft?language=objc)
    pub static kCAGravityLeft: &'static CALayerContentsGravity;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcagravityright?language=objc)
    pub static kCAGravityRight: &'static CALayerContentsGravity;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcagravitytopleft?language=objc)
    pub static kCAGravityTopLeft: &'static CALayerContentsGravity;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcagravitytopright?language=objc)
    pub static kCAGravityTopRight: &'static CALayerContentsGravity;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcagravitybottomleft?language=objc)
    pub static kCAGravityBottomLeft: &'static CALayerContentsGravity;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcagravitybottomright?language=objc)
    pub static kCAGravityBottomRight: &'static CALayerContentsGravity;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcagravityresize?language=objc)
    pub static kCAGravityResize: &'static CALayerContentsGravity;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcagravityresizeaspect?language=objc)
    pub static kCAGravityResizeAspect: &'static CALayerContentsGravity;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcagravityresizeaspectfill?language=objc)
    pub static kCAGravityResizeAspectFill: &'static CALayerContentsGravity;
}

extern "C" {
    /// Layer `contentsFormat` values. *
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcacontentsformatrgba8uint?language=objc)
    pub static kCAContentsFormatRGBA8Uint: &'static CALayerContentsFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcacontentsformatrgba16float?language=objc)
    pub static kCAContentsFormatRGBA16Float: &'static CALayerContentsFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcacontentsformatgray8uint?language=objc)
    pub static kCAContentsFormatGray8Uint: &'static CALayerContentsFormat;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcacontentsformatautomatic?language=objc)
    pub static kCAContentsFormatAutomatic: &'static CALayerContentsFormat;
}

extern "C" {
    /// Contents filter names. *
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcafilternearest?language=objc)
    pub static kCAFilterNearest: &'static CALayerContentsFilter;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcafilterlinear?language=objc)
    pub static kCAFilterLinear: &'static CALayerContentsFilter;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcafiltertrilinear?language=objc)
    pub static kCAFilterTrilinear: &'static CALayerContentsFilter;
}

extern "C" {
    /// Corner curve names. *
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcacornercurvecircular?language=objc)
    pub static kCACornerCurveCircular: &'static CALayerCornerCurve;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcacornercurvecontinuous?language=objc)
    pub static kCACornerCurveContinuous: &'static CALayerCornerCurve;
}

extern "C" {
    /// Layer event names. *
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcaonorderin?language=objc)
    pub static kCAOnOrderIn: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcaonorderout?language=objc)
    pub static kCAOnOrderOut: &'static NSString;
}

extern "C" {
    /// The animation key used for transitions. *
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/quartzcore/kcatransition?language=objc)
    pub static kCATransition: &'static NSString;
}
