/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.number;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ArithmeticPredicate
implements JSElementPredicate {
    private static final Set<IElementType> ARITHMETIC_OPERATIONS = Set.of(JSTokenTypes.PLUS, JSTokenTypes.MINUS, JSTokenTypes.MULT, JSTokenTypes.XOR, JSTokenTypes.MULTMULT, JSTokenTypes.DIV);

    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            ArithmeticPredicate.$$$reportNull$$$0(0);
        }
        if (!(element instanceof JSBinaryExpression)) {
            return false;
        }
        JSBinaryExpression expression = (JSBinaryExpression)element;
        if (PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
            return false;
        }
        IElementType operationSign = expression.getOperationSign();
        return operationSign != null && ARITHMETIC_OPERATIONS.contains(operationSign);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/number/ArithmeticPredicate", "satisfiedBy"));
    }
}

