/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.psi.HttpHeaderField;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.annotations.NotNull;

public class HttpRequestTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            HttpRequestTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            HttpRequestTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            HttpRequestTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            HttpRequestTypedHandler.$$$reportNull$$$0(3);
        }
        if (!(file instanceof HttpRequestPsiFile) || c != '%' && c != '{') {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                HttpRequestTypedHandler.$$$reportNull$$$0(4);
            }
            return result2;
        }
        int offset = editor2.getCaretModel().getOffset();
        PsiElement elementAtOffset = file.findElementAt(offset - 1);
        if (elementAtOffset == null) {
            TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
            if (result3 == null) {
                HttpRequestTypedHandler.$$$reportNull$$$0(5);
            }
            return result3;
        }
        Document document = editor2.getDocument();
        char charBefore = HttpRequestTypedHandler.getCharAt(document, offset - 1);
        char charAfter = HttpRequestTypedHandler.getCharAt(document, offset);
        if (charBefore == '{') {
            if (c == '%' && charAfter != '%') {
                TypedHandlerDelegate.Result result4 = this.addBrace(project, editor2, document, "%  %}", 2);
                if (result4 == null) {
                    HttpRequestTypedHandler.$$$reportNull$$$0(6);
                }
                return result4;
            }
            if (c == '{' && charAfter != '}') {
                TypedHandlerDelegate.Result result5 = this.addBrace(project, editor2, document, "{}}", 1);
                if (result5 == null) {
                    HttpRequestTypedHandler.$$$reportNull$$$0(7);
                }
                return result5;
            }
        } else if (c == '{' && charAfter != '{' && HttpRequestTypedHandler.couldCompleteToMessageBody(elementAtOffset, document, offset)) {
            TypedHandlerDelegate.Result result6 = this.addBrace(project, editor2, document, "{}", 1);
            if (result6 == null) {
                HttpRequestTypedHandler.$$$reportNull$$$0(8);
            }
            return result6;
        }
        TypedHandlerDelegate.Result result7 = TypedHandlerDelegate.Result.CONTINUE;
        if (result7 == null) {
            HttpRequestTypedHandler.$$$reportNull$$$0(9);
        }
        return result7;
    }

    @NotNull
    public TypedHandlerDelegate.Result addBrace(@NotNull Project project, @NotNull Editor editor2, @NotNull Document document, @NotNull String s, int caretShift) {
        PsiDocumentManager documentManager;
        if (project == null) {
            HttpRequestTypedHandler.$$$reportNull$$$0(10);
        }
        if (editor2 == null) {
            HttpRequestTypedHandler.$$$reportNull$$$0(11);
        }
        if (document == null) {
            HttpRequestTypedHandler.$$$reportNull$$$0(12);
        }
        if (s == null) {
            HttpRequestTypedHandler.$$$reportNull$$$0(13);
        }
        if ((documentManager = PsiDocumentManager.getInstance((Project)project)) != null) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)s, (boolean)true, (int)caretShift);
            documentManager.commitDocument(document);
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.STOP;
            if (result2 == null) {
                HttpRequestTypedHandler.$$$reportNull$$$0(14);
            }
            return result2;
        }
        TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
        if (result3 == null) {
            HttpRequestTypedHandler.$$$reportNull$$$0(15);
        }
        return result3;
    }

    private static char getCharAt(Document document, int offset) {
        if (offset >= document.getTextLength() || offset < 0) {
            return '\u0000';
        }
        return document.getCharsSequence().charAt(offset);
    }

    private static boolean couldCompleteToMessageBody(@NotNull PsiElement element, @NotNull Document document, int offset) {
        HttpRequest request;
        if (element == null) {
            HttpRequestTypedHandler.$$$reportNull$$$0(16);
        }
        if (document == null) {
            HttpRequestTypedHandler.$$$reportNull$$$0(17);
        }
        if (!(element instanceof PsiWhiteSpace)) {
            return false;
        }
        PsiElement sibling = element.getPrevSibling();
        if (sibling instanceof HttpRequestBlock ? (request = ((HttpRequestBlock)sibling).getRequest()).getHeaderFieldList().isEmpty() : !(sibling instanceof HttpHeaderField)) {
            return false;
        }
        int prevOffset = offset - 1;
        int countOfLineBreaks = 0;
        while (StringUtil.isWhiteSpace((char)HttpRequestTypedHandler.getCharAt(document, prevOffset))) {
            if (StringUtil.isLineBreak((char)HttpRequestTypedHandler.getCharAt(document, prevOffset))) {
                ++countOfLineBreaks;
            }
            --prevOffset;
        }
        return countOfLineBreaks > 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 9, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/HttpRequestTypedHandler";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/HttpRequestTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addBrace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addBrace";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "couldCompleteToMessageBody";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 9, 14, 15 -> new IllegalStateException(string);
        };
    }
}

