/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

public class DotNode
extends Node {
    private Node beginNode;
    private Node endNode;
    private boolean exclusive;
    private boolean isLiteral;

    public DotNode(SourcePosition position, Node beginNode, Node endNode, boolean exclusive, boolean isLiteral) {
        super(position);
        assert (beginNode != null) : "beginNode is not null";
        assert (endNode != null) : "endNode is not null";
        this.beginNode = this.adopt(beginNode);
        this.endNode = this.adopt(endNode);
        this.exclusive = exclusive;
        this.isLiteral = isLiteral;
    }

    public boolean isSame(Node node) {
        if (!super.isSame(node)) {
            return false;
        }
        DotNode other = (DotNode)node;
        return this.getBegin().isSame(other.getBegin()) && this.getEnd().isSame(other.getEnd()) && this.isExclusive() == other.isExclusive();
    }

    public NodeType getNodeType() {
        return NodeType.DOTNODE;
    }

    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitDotNode(this);
    }

    public Node getBegin() {
        return this.beginNode;
    }

    @Deprecated
    public Node getBeginNode() {
        return this.getBegin();
    }

    public Node getEnd() {
        return this.endNode;
    }

    @Deprecated
    public Node getEndNode() {
        return this.getEnd();
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isLiteral() {
        return this.isLiteral;
    }
}

