/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementDescriptorProvider;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.impl.util.table.CssVendorSpecificPropertyUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CssUnknownPropertyInspectionBase
extends CssBaseInspection {
    @NonNls
    public static final Key<CssUnknownPropertyInspectionBase> SHORT_NAME_KEY = Key.create((String)"CssUnknownProperty");
    public boolean myCustomPropertiesEnabled;
    public boolean myIgnoreVendorSpecificProperties;
    public JDOMExternalizableStringList myCustomPropertiesList = new JDOMExternalizableStringList();

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssUnknownPropertyInspectionBase.$$$reportNull$$$0(0);
        }
        return new UnknownPropertyVisitor(holder);
    }

    @NlsSafe
    protected String createPropertiesString() {
        return StringUtil.join((Collection)this.myCustomPropertiesList, (String)",");
    }

    public boolean isCustomProperty(@NotNull String property) {
        if (property == null) {
            CssUnknownPropertyInspectionBase.$$$reportNull$$$0(1);
        }
        return this.myCustomPropertiesList.contains((Object)StringUtil.toLowerCase((String)property));
    }

    public boolean isIgnoreVendorSpecificProperties() {
        return this.myIgnoreVendorSpecificProperties;
    }

    public boolean isCustomPropertiesEnabled() {
        return this.myCustomPropertiesEnabled;
    }

    public JDOMExternalizableStringList getCustomPropertiesList() {
        return this.myCustomPropertiesList;
    }

    protected void reparseProperties(@NotNull String properties) {
        if (properties == null) {
            CssUnknownPropertyInspectionBase.$$$reportNull$$$0(2);
        }
        this.myCustomPropertiesList = new JDOMExternalizableStringList();
        StringTokenizer tokenizer = new StringTokenizer(properties, ",");
        while (tokenizer.hasMoreTokens()) {
            this.myCustomPropertiesList.add((Object)StringUtil.toLowerCase((String)tokenizer.nextToken()).trim());
        }
    }

    public void addCustomPropertyName(@NotNull String text) {
        String s;
        if (text == null) {
            CssUnknownPropertyInspectionBase.$$$reportNull$$$0(3);
        }
        if (!this.isCustomProperty(s = StringUtil.toLowerCase((String)text.trim()))) {
            this.myCustomPropertiesList.add((Object)s);
        }
        if (!this.isCustomPropertiesEnabled()) {
            this.myCustomPropertiesEnabled = true;
        }
    }

    private static LocalQuickFix createUnknownPropertyFix(String postfix) {
        return CssFixFactory.getInstance().cssUnknownPropertyIntentionAction(postfix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomProperty";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reparseProperties";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addCustomPropertyName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class UnknownPropertyVisitor
    extends CssElementVisitor {
        private final ProblemsHolder myHolder;

        UnknownPropertyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitCssDeclaration(CssDeclaration declaration) {
            if (declaration.isCustomProperty()) {
                return;
            }
            PsiElement propertyNameElement = declaration.getPropertyNameElement();
            if (propertyNameElement == null) {
                return;
            }
            Collection<? extends CssPropertyDescriptor> descriptors = declaration.getDescriptors();
            if (!descriptors.isEmpty()) {
                descriptors = CssInspectionsUtil.filterDescriptorsByContextAndCheck(descriptors, propertyNameElement, this.myHolder);
                CssInspectionsUtil.filterDescriptorsByMediaTypeAndCheck(descriptors, propertyNameElement, this.myHolder);
                return;
            }
            if (!CssInspectionsUtil.isPureCssPropertyName(propertyNameElement)) {
                return;
            }
            if (!propertyNameElement.getLanguage().isKindOf((Language)CSSLanguage.INSTANCE) || PsiTreeUtil.hasErrorElements((PsiElement)declaration)) {
                return;
            }
            CssElementDescriptorProvider descriptorProvider = CssDescriptorsUtil.findDescriptorProvider(declaration);
            if (descriptorProvider != null && descriptorProvider.skipCssPropertyCheck(declaration)) {
                return;
            }
            String propertyName = declaration.getPropertyName();
            ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>();
            boolean reportError = false;
            if (CssVendorSpecificPropertyUtil.isVendorSpecificElement(propertyName)) {
                if (!CssUnknownPropertyInspectionBase.this.isIgnoreVendorSpecificProperties()) {
                    quickFixes.add(new CssIgnoreVendorSpecificPropertiesQuickFix());
                    String postfix = CssVendorSpecificPropertyUtil.getElementNameWithoutVendorPrefix(propertyName);
                    if (this.isReallyUnknownProperty(declaration, postfix)) {
                        propertyName = postfix;
                        quickFixes.add(CssUnknownPropertyInspectionBase.createUnknownPropertyFix(postfix));
                        reportError = true;
                    }
                }
            } else if (this.isReallyUnknownProperty(declaration, propertyName)) {
                quickFixes.add(CssUnknownPropertyInspectionBase.createUnknownPropertyFix(propertyName));
                reportError = true;
            }
            if (reportError) {
                quickFixes.addAll(CssDescriptorsUtil.getQuickFixesForUnknownProperty(propertyName, declaration, this.myHolder.isOnTheFly()));
                this.myHolder.registerProblem(propertyNameElement, CssBundle.message("css.inspections.unknown.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }

        private boolean isReallyUnknownProperty(CssDeclaration declaration, String propertyName) {
            return (!CssUnknownPropertyInspectionBase.this.isCustomPropertiesEnabled() || !CssUnknownPropertyInspectionBase.this.isCustomProperty(propertyName)) && !UnknownPropertyVisitor.isToIgnore(propertyName, declaration);
        }

        private static boolean isToIgnore(String propertyName, CssDeclaration declaration) {
            return propertyName != null && declaration != null && propertyName.equals("src") && CssUtil.isInsideFontFace(declaration);
        }
    }

    private static class CssIgnoreVendorSpecificPropertiesQuickFix
    implements LocalQuickFix {
        private CssIgnoreVendorSpecificPropertiesQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = CssBundle.message("css.unknown.vendor.property.fix.name", new Object[0]);
            if (string == null) {
                CssIgnoreVendorSpecificPropertiesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                CssIgnoreVendorSpecificPropertiesQuickFix.$$$reportNull$$$0(1);
            }
            if (previewDescriptor == null) {
                CssIgnoreVendorSpecificPropertiesQuickFix.$$$reportNull$$$0(2);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                CssIgnoreVendorSpecificPropertiesQuickFix.$$$reportNull$$$0(3);
            }
            return intentionPreviewInfo;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CssIgnoreVendorSpecificPropertiesQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                CssIgnoreVendorSpecificPropertiesQuickFix.$$$reportNull$$$0(5);
            }
            PsiElement element = descriptor.getPsiElement();
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
            profile.modifyToolSettings(SHORT_NAME_KEY, element, inspection -> {
                inspection.myIgnoreVendorSpecificProperties = true;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase$CssIgnoreVendorSpecificPropertiesQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/css/inspections/CssUnknownPropertyInspectionBase$CssIgnoreVendorSpecificPropertiesQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

