/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.fixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssAtRule;
import org.jetbrains.annotations.NotNull;

public class CssAddPrefixQuickFix
implements LocalQuickFix {
    @NotNull
    private final String myPrefix;
    @NotNull
    private final Class<? extends CssAtRule> myClass;
    @IntentionFamilyName
    @NotNull
    private final String myFamilyName;

    public CssAddPrefixQuickFix(@NotNull String prefix, @NotNull Class<? extends CssAtRule> elementClass, @IntentionFamilyName @NotNull String familyName) {
        if (prefix == null) {
            CssAddPrefixQuickFix.$$$reportNull$$$0(0);
        }
        if (elementClass == null) {
            CssAddPrefixQuickFix.$$$reportNull$$$0(1);
        }
        if (familyName == null) {
            CssAddPrefixQuickFix.$$$reportNull$$$0(2);
        }
        this.myPrefix = prefix;
        this.myClass = elementClass;
        this.myFamilyName = familyName;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            CssAddPrefixQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement startElement;
        if (project == null) {
            CssAddPrefixQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            CssAddPrefixQuickFix.$$$reportNull$$$0(5);
        }
        if (this.myClass.isInstance(startElement = descriptor.getStartElement())) {
            TextRange textRange = descriptor.getTextRangeInElement();
            Object text = textRange.substring(startElement.getText());
            for (int i = 0; i < this.myPrefix.length(); ++i) {
                if (StringUtil.startsWith((CharSequence)text, (CharSequence)this.myPrefix.substring(0, i + 1))) continue;
                text = this.myPrefix + ((String)text).substring(i);
                break;
            }
            PsiFile psiFile = descriptor.getPsiElement().getContainingFile();
            Document document = psiFile.getViewProvider().getDocument();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            TextRange psiElementRange = descriptor.getPsiElement().getTextRange();
            document.replaceString(psiElementRange.getStartOffset() + textRange.getStartOffset(), psiElementRange.getStartOffset() + textRange.getEndOffset(), (CharSequence)text);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "familyName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/fixes/CssAddPrefixQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/fixes/CssAddPrefixQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

