/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.usages;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.impl.CssTokenImpl;
import com.intellij.psi.css.usages.CssClassOrIdUsagesProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import org.jetbrains.annotations.NotNull;

public final class CssSearchHelper {
    private CssSearchHelper() {
    }

    public static boolean isClassOrIdUsed(@NotNull CssSelectorSuffix selectorSuffix, @NotNull SearchScope scope) {
        if (selectorSuffix == null) {
            CssSearchHelper.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            CssSearchHelper.$$$reportNull$$$0(1);
        }
        return CssSearchHelper.isUsed(selectorSuffix, scope);
    }

    private static boolean isUsed(@NotNull CssSelectorSuffix selectorSuffix, @NotNull SearchScope scope) {
        if (selectorSuffix == null) {
            CssSearchHelper.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            CssSearchHelper.$$$reportNull$$$0(3);
        }
        if (selectorSuffix.isValid()) {
            boolean[] used = new boolean[]{false};
            Project project = selectorSuffix.getProject();
            String name = selectorSuffix.getName();
            if (StringUtil.isNotEmpty((String)name)) {
                PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)project);
                PsiFile file = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)selectorSuffix);
                FileViewProvider viewProvider = file.getViewProvider();
                file = viewProvider.getPsi(viewProvider.getBaseLanguage());
                if (scope instanceof GlobalSearchScope && searchHelper.isCheapEnoughToSearch(name, (GlobalSearchScope)scope, file) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return true;
                }
                searchHelper.processElementsWithWord((current, offsetInElement) -> {
                    ProgressManager.checkCanceled();
                    if (used[0]) {
                        return false;
                    }
                    if (current instanceof CssTokenImpl) {
                        return true;
                    }
                    for (CssClassOrIdUsagesProvider usagesProvider : CssClassOrIdUsagesProvider.EXTENSION_POINT_NAME.getExtensionList()) {
                        if (!usagesProvider.isUsage(selectorSuffix, current, offsetInElement)) continue;
                        used[0] = true;
                        return false;
                    }
                    return true;
                }, scope, name, (short)15, false);
                return used[0];
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorSuffix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/usages/CssSearchHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isClassOrIdUsed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isUsed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

