/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs.frontend.split.diff;

import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.platform.vcs.frontend.split.diff.DiffInnerModel;
import com.intellij.platform.vcs.frontend.split.diff.DiffLineModel;
import com.intellij.platform.vcs.frontend.split.diff.FrontendDiffMarkModelSupportKt;
import com.intellij.platform.vcs.frontend.split.diff.UtilKt;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IntPair;
import com.intellij.util.Processor;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/DiffEditorHighlightingSynchronizer;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/editor/ex/EditorEx;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "highlighters", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "initHighlighters", "", "clearHighlighters", "updateHighlighterFor", "highlighter", "HighlightingMarkupModelListener", "intellij.platform.vcs.frontend.split"})
@SourceDebugExtension(value={"SMAP\nDiffEditorHighlightingSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffEditorHighlightingSynchronizer.kt\ncom/intellij/platform/vcs/frontend/split/diff/DiffEditorHighlightingSynchronizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1869#2,2:79\n1869#2,2:81\n1869#2,2:83\n1869#2,2:85\n*S KotlinDebug\n*F\n+ 1 DiffEditorHighlightingSynchronizer.kt\ncom/intellij/platform/vcs/frontend/split/diff/DiffEditorHighlightingSynchronizer\n*L\n31#1:79,2\n36#1:81,2\n44#1:83,2\n54#1:85,2\n*E\n"})
public final class DiffEditorHighlightingSynchronizer {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final Map<RangeHighlighterEx, List<RangeHighlighter>> highlighters;

    public DiffEditorHighlightingSynchronizer(@NotNull Lifetime lifetime, @NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.lifetime = lifetime;
        this.editor = editor;
        this.highlighters = new LinkedHashMap();
        HighlightingMarkupModelListener markupListener = new HighlightingMarkupModelListener();
        this.editor.getMarkupModel().addMarkupModelListener(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.lifetime, null, (int)1, null), (MarkupModelListener)markupListener);
        this.initHighlighters();
        this.lifetime.onTermination(() -> DiffEditorHighlightingSynchronizer._init_$lambda$0(this));
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    private final void initHighlighters() {
        CommonProcessors.CollectProcessor<RangeHighlighterEx> processor2 = new CommonProcessors.CollectProcessor<RangeHighlighterEx>(){

            protected boolean accept(RangeHighlighterEx highlighter) {
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                return FrontendDiffMarkModelSupportKt.getDiffLineModel((RangeHighlighter)highlighter) != null || FrontendDiffMarkModelSupportKt.getDiffInnerModel((RangeHighlighter)highlighter) != null;
            }
        };
        this.editor.getMarkupModel().processRangeHighlightersOverlappingWith(0, this.editor.getDocument().getTextLength(), (Processor)processor2);
        Collection collection = processor2.getResults();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getResults(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighterEx p0 = (RangeHighlighterEx)element$iv;
            boolean bl = false;
            this.updateHighlighterFor(p0);
        }
    }

    private final void clearHighlighters() {
        for (List<RangeHighlighter> highlighter : this.highlighters.values()) {
            Iterable $this$forEach$iv = highlighter;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RangeHighlighter it = (RangeHighlighter)element$iv;
                boolean bl = false;
                it.dispose();
            }
        }
        this.highlighters.clear();
    }

    private final void updateHighlighterFor(RangeHighlighterEx highlighter) {
        DiffInnerModel innerModel;
        DiffLineModel lineModel = FrontendDiffMarkModelSupportKt.getDiffLineModel((RangeHighlighter)highlighter);
        if (lineModel != null) {
            List<RangeHighlighter> list = this.highlighters.remove(highlighter);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RangeHighlighter it = (RangeHighlighter)element$iv;
                    boolean bl = false;
                    it.dispose();
                }
            }
            IntPair lines = UtilKt.getHighlighterLineRange(highlighter, lineModel.isEmptyRange(), lineModel.isEOF());
            this.highlighters.put(highlighter, DiffDrawUtil.createHighlighter((Editor)((Editor)this.editor), (int)lines.first, (int)lines.second, (TextDiffType)UtilKt.toTextDiffType(lineModel.getType()), (DiffDrawUtil.PaintMode)UtilKt.fromModel(lineModel.getEditorMode()), (DiffDrawUtil.PaintMode)UtilKt.fromModel(lineModel.getGutterMode())));
        }
        if ((innerModel = FrontendDiffMarkModelSupportKt.getDiffInnerModel((RangeHighlighter)highlighter)) != null) {
            List<RangeHighlighter> list = this.highlighters.remove(highlighter);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RangeHighlighter it = (RangeHighlighter)element$iv;
                    boolean bl = false;
                    it.dispose();
                }
            }
            this.highlighters.put(highlighter, DiffDrawUtil.createInlineHighlighter((Editor)((Editor)this.editor), (int)highlighter.getStartOffset(), (int)highlighter.getEndOffset(), (TextDiffType)UtilKt.toTextDiffType(innerModel.getType())));
        }
    }

    private static final Unit _init_$lambda$0(DiffEditorHighlightingSynchronizer this$0) {
        this$0.clearHighlighters();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J(\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/vcs/frontend/split/diff/DiffEditorHighlightingSynchronizer$HighlightingMarkupModelListener;", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "<init>", "(Lcom/intellij/platform/vcs/frontend/split/diff/DiffEditorHighlightingSynchronizer;)V", "afterAdded", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterRemoved", "attributesChanged", "renderersChanged", "", "fontStyleChanged", "foregroundColorChanged", "intellij.platform.vcs.frontend.split"})
    @SourceDebugExtension(value={"SMAP\nDiffEditorHighlightingSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffEditorHighlightingSynchronizer.kt\ncom/intellij/platform/vcs/frontend/split/diff/DiffEditorHighlightingSynchronizer$HighlightingMarkupModelListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1869#2,2:79\n*S KotlinDebug\n*F\n+ 1 DiffEditorHighlightingSynchronizer.kt\ncom/intellij/platform/vcs/frontend/split/diff/DiffEditorHighlightingSynchronizer$HighlightingMarkupModelListener\n*L\n67#1:79,2\n*E\n"})
    private final class HighlightingMarkupModelListener
    implements MarkupModelListener {
        public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            DiffEditorHighlightingSynchronizer.this.updateHighlighterFor(highlighter);
        }

        public void afterRemoved(@NotNull RangeHighlighterEx highlighter) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                List list = (List)DiffEditorHighlightingSynchronizer.this.highlighters.remove(highlighter);
                if (list == null) break block1;
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RangeHighlighter it = (RangeHighlighter)element$iv;
                    boolean bl = false;
                    it.dispose();
                }
            }
        }

        public void attributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            DiffEditorHighlightingSynchronizer.this.updateHighlighterFor(highlighter);
        }
    }
}

