/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pyramid.annotator;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.python.pyramid.annotator.PyramidSetupQuickFix;
import com.intellij.python.pyramid.project.PyramidUtils;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;

public final class PyramidSetupInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyramidSetupInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyramidSetupInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext((LocalInspectionToolSession)session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/pyramid/annotator/PyramidSetupInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (holder == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            super(holder, context);
        }

        public void visitPyFile(@NotNull PyFile node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            this.doCheck((PsiFile)node);
        }

        public void visitPlainTextFile(@NotNull PsiPlainTextFile file) {
            if (file == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            this.doCheck((PsiFile)file);
        }

        private void doCheck(@NotNull PsiFile node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(4);
            }
            if (!PyramidUtils.isPyramidProject((PsiElement)node)) {
                return;
            }
            Project project = node.getProject();
            String name = project.getName();
            VirtualFile baseDir = project.getBaseDir();
            VirtualFile eggInfo = baseDir.findFileByRelativePath(name + ".egg-info");
            ProblemsHolder holder = this.getHolder();
            if (!(holder == null || eggInfo != null && eggInfo.exists())) {
                holder.registerProblem((PsiElement)node, PythonProBundle.message((String)"pyramid.project.not.installed.for.development"), new LocalQuickFix[]{new PyramidSetupQuickFix()});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/python/pyramid/annotator/PyramidSetupInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPlainTextFile";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doCheck";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

