/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.watcher;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.problems.TaskProblemDescription;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.NotNull;

public class TaskProblemsHolder {
    private final ConcurrentLinkedQueue<ProblemInfo> myProblemInfos = new ConcurrentLinkedQueue();

    public void clearByInitializer(@NotNull VirtualFile file, String taskName) {
        if (file == null) {
            TaskProblemsHolder.$$$reportNull$$$0(0);
        }
        Iterator<ProblemInfo> iterator = this.myProblemInfos.iterator();
        while (iterator.hasNext()) {
            ProblemInfo info = iterator.next();
            if (!file.equals(info.getInitializerVirtualFile()) || !StringUtil.equals((CharSequence)taskName, (CharSequence)info.getTaskName())) continue;
            iterator.remove();
        }
    }

    public void addProblems(VirtualFile file, long stamp, VirtualFile initializer, String taskName, List<TaskProblemDescription> value) {
        for (TaskProblemDescription description : value) {
            this.addProblem(file, stamp, initializer, taskName, description);
        }
    }

    public void addProblem(VirtualFile file, long stamp, VirtualFile initializer, String taskName, TaskProblemDescription problemDescription) {
        ProblemInfo info = new ProblemInfo(file, stamp, initializer, taskName, problemDescription);
        this.myProblemInfos.add(info);
    }

    public List<TaskProblemDescription> findProblems(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            TaskProblemsHolder.$$$reportNull$$$0(1);
        }
        ArrayList<TaskProblemDescription> result = new ArrayList<TaskProblemDescription>();
        long stamp = psiFile.getModificationStamp();
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null) {
            return Collections.emptyList();
        }
        Iterator<ProblemInfo> iterator = this.myProblemInfos.iterator();
        while (iterator.hasNext()) {
            ProblemInfo info = iterator.next();
            if (!file.equals(info.getVirtualFile())) continue;
            ProjectTasksOptions projectTasksOptions = ProjectTasksOptions.getInstance(psiFile.getProject());
            if (!(stamp <= info.getModificationStamp() && projectTasksOptions.hasEnabledWatcherWithName(info.getTaskName()) || ApplicationManager.getApplication().isUnitTestMode())) {
                iterator.remove();
                continue;
            }
            result.add(info.getTaskProblemDescription());
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/plugins/watcher/TaskProblemsHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "clearByInitializer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findProblems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ProblemInfo {
        private final VirtualFile myVirtualFile;
        private final long myModificationStamp;
        private final VirtualFile myInitializerVirtualFile;
        private final TaskProblemDescription myTaskProblemDescription;
        private final String myTaskName;

        private ProblemInfo(VirtualFile file, long stamp, VirtualFile initializer, String taskName, TaskProblemDescription description) {
            this.myVirtualFile = file;
            this.myModificationStamp = stamp;
            this.myTaskName = taskName;
            this.myInitializerVirtualFile = initializer;
            this.myTaskProblemDescription = description;
        }

        public VirtualFile getVirtualFile() {
            return this.myVirtualFile;
        }

        public long getModificationStamp() {
            return this.myModificationStamp;
        }

        public String getTaskName() {
            return this.myTaskName;
        }

        public VirtualFile getInitializerVirtualFile() {
            return this.myInitializerVirtualFile;
        }

        public TaskProblemDescription getTaskProblemDescription() {
            return this.myTaskProblemDescription;
        }
    }
}

