/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.connection.VmConnection;

public final class JavaScriptDebugSessionsUtil {
    private JavaScriptDebugSessionsUtil() {
    }

    public static boolean stopDebugSessions(String message, Class<? extends JavaScriptDebugProcess<? extends VmConnection>> processClass) {
        SmartList sessions = new SmartList();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (JavaScriptDebugProcess process2 : XDebuggerManager.getInstance((Project)project).getDebugProcesses(processClass)) {
                XDebugSession session2 = process2.getSession();
                if (session2.isStopped()) continue;
                sessions.add(session2);
            }
        }
        if (!sessions.isEmpty()) {
            int count = sessions.size();
            String sessionName = count == 1 ? "'" + ((XDebugSession)sessions.get(0)).getSessionName() + "'" : String.valueOf(count);
            int answer = MessageDialogBuilder.yesNo((String)JSDebuggerBundle.message("dialog.title.stop.debugger.session", new Object[0]), (String)JSDebuggerBundle.message("message.text.do.you.want.to.stop.0.sessions", message, sessionName, count)).show();
            if (answer == 0) {
                for (XDebugSession session3 : sessions) {
                    session3.stop();
                }
            } else {
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static RunnerAndConfigurationSettings findExistingConfiguration(@NotNull String url, @Nullable WebBrowser browser, @NotNull Project project) {
        if (url == null) {
            JavaScriptDebugSessionsUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JavaScriptDebugSessionsUtil.$$$reportNull$$$0(1);
        }
        List configurations = RunManager.getInstance((Project)project).getConfigurationSettingsList((ConfigurationType)JavascriptDebugConfigurationType.getTypeInstance());
        String browserId = browser == null ? null : browser.getId().toString();
        for (RunnerAndConfigurationSettings settings : configurations) {
            JavaScriptDebugConfiguration c;
            RunConfiguration configuration = settings.getConfiguration();
            if (!(configuration instanceof JavaScriptDebugConfiguration) || !Objects.equals((c = (JavaScriptDebugConfiguration)configuration).getUri(), url) || !Objects.equals(c.getEngineId(), browserId)) continue;
            return settings;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "url";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/javascript/debugger/execution/JavaScriptDebugSessionsUtil";
        objectArray[2] = "findExistingConfiguration";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

