/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.webcore.formatter.comments.CommentLineData;
import com.intellij.webcore.formatter.comments.CommentLineDataBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DocCommentLineDataBuilder
extends CommentLineDataBuilder {
    private final boolean myAlignDocComments;
    private final PsiElement myDocComment;
    private final CommonCodeStyleSettings.IndentOptions myIndentOptions;

    public DocCommentLineDataBuilder(@NotNull PsiElement docComment, boolean alignDocComments, @NotNull CommonCodeStyleSettings settings) {
        if (docComment == null) {
            DocCommentLineDataBuilder.q(0);
        }
        if (settings == null) {
            DocCommentLineDataBuilder.q(1);
        }
        super(settings.getRootSettings());
        this.myDocComment = docComment;
        this.myAlignDocComments = alignDocComments;
        this.myIndentOptions = settings.getIndentOptions() != null ? settings.getIndentOptions() : new CommonCodeStyleSettings.IndentOptions();
    }

    @Override
    public List<CommentLineData> getLines() {
        CharSequence charSequence = this.myDocComment.getNode().getChars();
        ArrayList<CommentLineData> arrayList = new ArrayList<CommentLineData>();
        int n2 = 0;
        boolean bl = false;
        block3: for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            switch (c2) {
                case '\n': {
                    if (n2 < i2) {
                        CommentLineData commentLineData = this.q(charSequence, n2, i2, bl);
                        bl = commentLineData.isTagLine();
                        arrayList.add(commentLineData);
                    }
                    n2 = i2 + 1;
                    continue block3;
                }
            }
        }
        if (n2 < charSequence.length()) {
            arrayList.add(this.q(charSequence, n2, charSequence.length(), bl));
        }
        return arrayList;
    }

    private CommentLineData q(CharSequence charSequence, int n2, int n3, boolean bl) {
        String string = new String(CharArrayUtil.fromSequence((CharSequence)charSequence, (int)n2, (int)n3));
        CommentLineData commentLineData = this.parseLine(string);
        commentLineData.setTagLine(bl);
        return commentLineData;
    }

    @Override
    @NotNull
    public CommentLineData parseLine(@NotNull String line) {
        if (line == null) {
            DocCommentLineDataBuilder.q(2);
        }
        DocCommentLineData docCommentLineData = new DocCommentLineData(line);
        docCommentLineData.commentOffset = DocCommentLineDataBuilder.nextNonWhitespace(line, 0);
        if (docCommentLineData.commentOffset >= 0) {
            int n2;
            if (line.charAt(docCommentLineData.commentOffset) == '*') {
                ++docCommentLineData.commentOffset;
            }
            if ((n2 = DocCommentLineDataBuilder.nextNonWhitespace(line, docCommentLineData.commentOffset)) >= 0) {
                char c2 = line.charAt(n2);
                if (c2 == '@') {
                    docCommentLineData.tagStartOffset = n2;
                    int n3 = docCommentLineData.tagEndOffset = (n2 = DocCommentLineDataBuilder.nextWhitespace(line, n2 + 1)) >= 0 ? n2 : line.length();
                    if (docCommentLineData.tagEndOffset > docCommentLineData.tagStartOffset) {
                        docCommentLineData.tagName = line.substring(docCommentLineData.tagStartOffset, docCommentLineData.tagEndOffset);
                    }
                    if (n2 >= 0) {
                        if ("@param".equals(docCommentLineData.tagName)) {
                            if ((n2 = DocCommentLineDataBuilder.nextNonWhitespace(line, n2 + 1)) >= 0) {
                                boolean bl = line.charAt(n2) == '$';
                                n2 = DocCommentLineDataBuilder.nextWhitespace(line, n2);
                                if (!bl && n2 >= 0) {
                                    n2 = DocCommentLineDataBuilder.skipNextWord(line, n2);
                                }
                            }
                        } else if ("@return".equals(docCommentLineData.tagName) || "@throws".equals(docCommentLineData.tagName)) {
                            n2 = DocCommentLineDataBuilder.skipNextWord(line, n2);
                        }
                    }
                } else if (Character.isLetter(c2)) {
                    docCommentLineData.startsWithLetter = true;
                }
                if (n2 >= 0) {
                    docCommentLineData.textStartOffset = (n2 = DocCommentLineDataBuilder.nextNonWhitespace(line, n2)) >= 0 ? n2 : -1;
                    DocCommentLineDataBuilder.q(docCommentLineData, line);
                }
            }
        }
        DocCommentLineData docCommentLineData2 = docCommentLineData;
        if (docCommentLineData2 == null) {
            DocCommentLineDataBuilder.q(3);
        }
        return docCommentLineData2;
    }

    private static void q(@NotNull CommentLineData commentLineData, @NotNull String string) {
        if (commentLineData == null) {
            DocCommentLineDataBuilder.q(4);
        }
        if (string == null) {
            DocCommentLineDataBuilder.q(5);
        }
        if (commentLineData.textStartOffset < 0) {
            return;
        }
        int n2 = -1;
        block4: for (int i2 = commentLineData.textStartOffset; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '{': {
                    int n3 = i2 + 1;
                    if (n3 >= string.length() || string.charAt(n3) != '@') continue block4;
                    n2 = i2;
                    continue block4;
                }
                case '}': {
                    if (n2 >= 0) {
                        TextRange textRange = new TextRange(DocCommentLineDataBuilder.q(string, n2, commentLineData.textStartOffset), i2);
                        commentLineData.addUnbreakableRange(textRange);
                    }
                    n2 = -1;
                }
            }
        }
    }

    private static int q(String string, int n2, int n3) {
        if (n2 <= n3 || string.charAt(n2 - 1) != ']') {
            return n2;
        }
        for (int i2 = n2; i2 >= n3; --i2) {
            char c2 = string.charAt(i2);
            if (c2 != '[') continue;
            return i2;
        }
        return n2;
    }

    private static /* synthetic */ void q(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInlineTagsRanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private class DocCommentLineData
    extends CommentLineData {
        int tagStartOffset;
        int tagEndOffset;
        String tagName;
        private boolean isTagLine;

        DocCommentLineData(String line) {
            if (line == null) {
                DocCommentLineData.Q(0);
            }
            super(line);
            this.tagStartOffset = -1;
            this.tagEndOffset = -1;
            this.tagName = "";
            this.isTagLine = false;
        }

        @Override
        public boolean isTagLine() {
            return this.tagStartOffset >= 0 || this.isTagLine;
        }

        @Override
        public void setTagLine(boolean tagLine) {
            this.isTagLine = tagLine;
        }

        @Override
        @NotNull
        public String getLinePrefix() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.commentOffset >= 0) {
                stringBuilder.append(this.line, 0, this.commentOffset);
                if (this.textStartOffset > this.commentOffset) {
                    if (DocCommentLineDataBuilder.this.myAlignDocComments) {
                        StringUtil.repeatSymbol((Appendable)stringBuilder, (char)' ', (int)(this.textStartOffset - this.commentOffset - 1));
                    } else if (this.isTagLine()) {
                        StringUtil.repeatSymbol((Appendable)stringBuilder, (char)' ', (int)DocCommentLineDataBuilder.this.myIndentOptions.CONTINUATION_INDENT_SIZE);
                    }
                }
            }
            String string = stringBuilder.toString();
            if (string == null) {
                DocCommentLineData.Q(1);
            }
            return string;
        }

        @Override
        protected int getTabSize() {
            return DocCommentLineDataBuilder.this.myIndentOptions.TAB_SIZE;
        }

        private static /* synthetic */ void Q(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n2) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder$DocCommentLineData";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder$DocCommentLineData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinePrefix";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n2) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

