/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.renderers;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManager;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.impl.EditorCssFontResolver;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.MathUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.CSSFontResolver;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StyleSheetUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlNoteContainer
extends JPanel {
    @Nullable
    private static StyleSheet OUR_CACHED_STYLESHEET;
    @NotNull
    private static String OUR_CACHED_STYLESHEET_LINK_COLOR;
    @NotNull
    private final DiagramBuilder myBuilder;
    @NotNull
    private final DiagramNoteNode myNote;
    @NotNull
    private final Point myBasePoint;
    private boolean myIsSelected;

    public UmlNoteContainer(@NotNull DiagramNoteNode note, @NotNull DiagramBuilder builder, @NotNull Point point) {
        if (note == null) {
            UmlNoteContainer.$$$reportNull$$$0(0);
        }
        if (builder == null) {
            UmlNoteContainer.$$$reportNull$$$0(1);
        }
        if (point == null) {
            UmlNoteContainer.$$$reportNull$$$0(2);
        }
        super(new BorderLayout(0, 0));
        this.myBuilder = builder;
        this.myNote = note;
        this.myBasePoint = point;
        DiagramColorManager colorManager = builder.getProvider().getColorManager();
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.setOpaque(false);
        panel.setFocusable(false);
        JEditorPane editorPane = UmlNoteContainer.createEditorPane(note.getNoteText());
        UmlNoteContainer.setEditorPanePreferredSize(editorPane);
        panel.setPreferredSize(editorPane.getSize());
        panel.add((Component)editorPane, "Center");
        this.add((Component)panel, "Center");
        this.setFocusable(false);
        this.setOpaque(true);
        this.setBackground(colorManager.getNodeBackground(builder, note, null, false));
        this.setBorder(this.getMyBorder(false));
    }

    @NotNull
    public DiagramNoteNode getNoteNode() {
        DiagramNoteNode diagramNoteNode = this.myNote;
        if (diagramNoteNode == null) {
            UmlNoteContainer.$$$reportNull$$$0(3);
        }
        return diagramNoteNode;
    }

    @Override
    public Point getPopupLocation(MouseEvent event) {
        Point p = this.myBuilder.getView().getCanvasComponent().getLocationOnScreen();
        return new Point(this.myBasePoint.x - p.x + event.getX(), this.myBasePoint.y - p.y + event.getY());
    }

    @Override
    public void paint(Graphics g) {
        boolean isSelected = this.myBuilder.getGraph().isSelected(this.myBuilder.getNode(this.myNote));
        if (isSelected != this.myIsSelected) {
            this.myIsSelected = isSelected;
            this.setBorder(this.getMyBorder(isSelected));
        }
        super.paint(g);
    }

    @NotNull
    private Border getMyBorder(boolean isSelected) {
        Color borderColor = this.myBuilder.getProvider().getColorManager().getNodeBorderColor(this.myBuilder, this.myNote, isSelected);
        Border border = JBUI.Borders.merge((Border)new LineBorder(borderColor, 1), (Border)JBUI.Borders.empty((int)5, (int)10), (boolean)false);
        if (border == null) {
            UmlNoteContainer.$$$reportNull$$$0(4);
        }
        return border;
    }

    @NotNull
    private static JEditorPane createEditorPane(@NotNull @Nls String text) {
        if (text == null) {
            UmlNoteContainer.$$$reportNull$$$0(5);
        }
        JEditorPane pane = new JEditorPane();
        pane.setEditable(false);
        pane.setFocusable(false);
        pane.setOpaque(false);
        pane.putClientProperty("caretWidth", 0);
        pane.setEditorKit(UmlNoteContainer.createEditorKit());
        pane.setBorder((Border)JBUI.Borders.empty());
        HashMap<TextAttribute, Number> fontAttributes = new HashMap<TextAttribute, Number>();
        fontAttributes.put(TextAttribute.SIZE, Float.valueOf(JBUIScale.scale((float)12.0f)));
        fontAttributes.put(TextAttribute.KERNING, 0);
        pane.setFont(pane.getFont().deriveFont(fontAttributes));
        pane.setForeground(UmlNoteContainer.getTextColor(EditorColorsManager.getInstance().getGlobalScheme()));
        UIUtil.enableEagerSoftWrapping((JTextComponent)pane);
        pane.setText(text);
        JEditorPane jEditorPane = pane;
        if (jEditorPane == null) {
            UmlNoteContainer.$$$reportNull$$$0(6);
        }
        return jEditorPane;
    }

    @NotNull
    private static EditorKit createEditorKit() {
        HTMLEditorKit editorKit = new HTMLEditorKitBuilder().withFontResolver((CSSFontResolver)EditorCssFontResolver.getGlobalInstance()).build();
        editorKit.getStyleSheet().addStyleSheet(UmlNoteContainer.getStyleSheet());
        HTMLEditorKit hTMLEditorKit = editorKit;
        if (hTMLEditorKit == null) {
            UmlNoteContainer.$$$reportNull$$$0(7);
        }
        return hTMLEditorKit;
    }

    @NotNull
    private static StyleSheet getStyleSheet() {
        EditorColorsScheme colorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Color linkColor = (Color)ObjectUtils.notNull((Object)colorsScheme.getColor(DefaultLanguageHighlighterColors.DOC_COMMENT_LINK), () -> UmlNoteContainer.getTextColor(colorsScheme));
        String linkColorHex = ColorUtil.toHex((Color)linkColor);
        if (!Objects.equals(linkColorHex, OUR_CACHED_STYLESHEET_LINK_COLOR)) {
            String editorFontNamePlaceHolder = "_EditorFontNoLigatures_";
            OUR_CACHED_STYLESHEET = StyleSheetUtil.loadStyleSheet((String)("body {overflow-wrap: anywhere}code {font-family: \"_EditorFontNoLigatures_\"}pre {font-family: \"_EditorFontNoLigatures_\";white-space: pre-wrap}h1, h2, h3, h4, h5, h6 {margin-top: 0; padding-top: 1}a {color: #" + linkColorHex + "; text-decoration: none}p {padding: 7 0 2 0}ol {padding: 0 20 0 0}ul {padding: 0 20 0 0}li {padding: 1 0 2 0}li p {padding-top: 0}table p {padding-bottom: 0}th {text-align: left}td {padding: 2 0 2 0}td p {padding-top: 0}.sections {border-spacing: 0}.section {padding-right: 5; white-space: nowrap}.content {padding: 2 0 2 0}"));
            OUR_CACHED_STYLESHEET_LINK_COLOR = linkColorHex;
        }
        StyleSheet styleSheet = Objects.requireNonNull(OUR_CACHED_STYLESHEET);
        if (styleSheet == null) {
            UmlNoteContainer.$$$reportNull$$$0(8);
        }
        return styleSheet;
    }

    @NotNull
    private static Color getTextColor(@NotNull EditorColorsScheme scheme) {
        TextAttributes attributes;
        if (scheme == null) {
            UmlNoteContainer.$$$reportNull$$$0(9);
        }
        Color color = (attributes = scheme.getAttributes(DefaultLanguageHighlighterColors.DOC_COMMENT)) == null ? null : attributes.getForegroundColor();
        Color color2 = color == null ? scheme.getDefaultForeground() : color;
        if (color2 == null) {
            UmlNoteContainer.$$$reportNull$$$0(10);
        }
        return color2;
    }

    private static void setEditorPanePreferredSize(@NotNull JEditorPane editorPane) {
        if (editorPane == null) {
            UmlNoteContainer.$$$reportNull$$$0(11);
        }
        int preferredContentWidth = UmlNoteContainer.getPreferredContentWidth(editorPane.getDocument().getLength());
        editorPane.setSize(preferredContentWidth, Short.MAX_VALUE);
        int minWidth = editorPane.getMinimumSize().width;
        Dimension preferredSize = new Dimension(MathUtil.clamp((int)preferredContentWidth, (int)minWidth, (int)Math.max(minWidth, 600)), MathUtil.clamp((int)editorPane.getPreferredSize().height, (int)100, (int)Short.MAX_VALUE));
        editorPane.setSize(preferredSize);
    }

    private static int getPreferredContentWidth(int textLength) {
        int contentLengthPreferredSize = textLength < 200 ? JBUIScale.scale((int)300) : (textLength > 200 && textLength < 1000 ? JBUIScale.scale((int)300) + JBUIScale.scale((int)1) * (textLength - 200) * 200 / 800 : JBUIScale.scale((int)500));
        return contentLengthPreferredSize;
    }

    static {
        OUR_CACHED_STYLESHEET_LINK_COLOR = "non-existing";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "note";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uml/core/renderers/UmlNoteContainer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uml/core/renderers/UmlNoteContainer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNoteNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMyBorder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorPane";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorKit";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStyleSheet";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextColor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditorPane";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextColor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setEditorPanePreferredSize";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 8, 10 -> new IllegalStateException(string);
        };
    }
}

