/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlSingleNodeBlock;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u000fJ\u0006\u0010 \u001a\u00020\u001eJ\u0006\u0010!\u001a\u00020\u001eJ\u0006\u0010\"\u001a\u00020\u001eJ\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u00020-H\u0016J\b\u0010=\u001a\u00020-H\u0016J\b\u0010>\u001a\u000202H\u0016J\b\u0010?\u001a\u00020\u000fH\u0016R$\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001@TX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u000f@TX\u0096.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0013\u0010#\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\bR\u0013\u0010%\u001a\u0004\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\bR\u0011\u0010'\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0011\u00101\u001a\u0002028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u0002068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0014\u00109\u001a\u00020:8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b;\u0010<\u00a8\u0006@"}, d2={"Lcom/intellij/sql/formatter/model/SqlLeafBlock;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlSingleNodeBlock;", "<init>", "()V", "value", "parent", "getParent", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setParent", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "getContext", "()Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "Lcom/intellij/lang/ASTNode;", "blockNode", "getBlockNode", "()Lcom/intellij/lang/ASTNode;", "setBlockNode", "(Lcom/intellij/lang/ASTNode;)V", "elementType", "Lcom/intellij/psi/tree/IElementType;", "getElementType", "()Lcom/intellij/psi/tree/IElementType;", "nestedBlocks", "", "getNestedBlocks", "()Ljava/util/List;", "setup", "", "node", "grow", "analyze", "refine", "firstNestedSqlBlock", "getFirstNestedSqlBlock", "lastNestedSqlBlock", "getLastNestedSqlBlock", "firstLeafBlock", "getFirstLeafBlock", "()Lcom/intellij/sql/formatter/model/SqlLeafBlock;", "lastLeafBlock", "getLastLeafBlock", "contains", "", "char", "", "requiresFollowingBreak", "text", "", "getText", "()Ljava/lang/String;", "range", "Lcom/intellij/openapi/util/TextRange;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "minLength", "", "getMinLength", "()I", "isLeaf", "toString", "getNode", "intellij.database.sql.core.impl"})
public class SqlLeafBlock
extends SqlBlock
implements SqlSingleNodeBlock {
    protected SqlBlock parent;
    protected ASTNode blockNode;

    public SqlLeafBlock() {
        super(null);
    }

    @Override
    @NotNull
    public SqlBlock getParent() {
        SqlBlock sqlBlock = this.parent;
        if (sqlBlock != null) {
            return sqlBlock;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"parent");
        return null;
    }

    protected void setParent(@NotNull SqlBlock sqlBlock) {
        Intrinsics.checkNotNullParameter((Object)sqlBlock, (String)"<set-?>");
        this.parent = sqlBlock;
    }

    @Override
    @NotNull
    public SqlFormattingContext getContext() {
        return this.getParent().getContext();
    }

    @Override
    @NotNull
    public ASTNode getBlockNode() {
        ASTNode aSTNode = this.blockNode;
        if (aSTNode != null) {
            return aSTNode;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"blockNode");
        return null;
    }

    protected void setBlockNode(@NotNull ASTNode aSTNode) {
        Intrinsics.checkNotNullParameter((Object)aSTNode, (String)"<set-?>");
        this.blockNode = aSTNode;
    }

    @NotNull
    public final IElementType getElementType() {
        IElementType iElementType = this.getBlockNode().getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        return iElementType;
    }

    @Override
    @NotNull
    public List<SqlBlock> getNestedBlocks() {
        return CollectionsKt.emptyList();
    }

    public final void setup(@NotNull SqlBlock parent, @NotNull ASTNode node) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        boolean bl2 = bl = !Intrinsics.areEqual((Object)parent, (Object)this);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.setParent(parent);
        this.setBlockNode(node);
    }

    @Override
    public final void grow() {
    }

    @Override
    public final void analyze() {
        this.setHasUserBreaks(this.contains('\n'));
        this.setShape(this.getHasUserBreaks() ? BlockShape.DECIDED_TO_MULTI_ROWS : BlockShape.DECIDED_TO_ONE_ROW);
    }

    @Override
    public final void refine() {
    }

    @Override
    @Nullable
    public final SqlBlock getFirstNestedSqlBlock() {
        return null;
    }

    @Override
    @Nullable
    public final SqlBlock getLastNestedSqlBlock() {
        return null;
    }

    @Override
    @NotNull
    public final SqlLeafBlock getFirstLeafBlock() {
        return this;
    }

    @Override
    @NotNull
    public final SqlLeafBlock getLastLeafBlock() {
        return this;
    }

    @Override
    public final boolean contains(char c2) {
        return this.getBlockNode().textContains(c2);
    }

    @Override
    public boolean requiresFollowingBreak() {
        return SqlFormattingFunKt.MUST_FOLLOWED_BY_NL_TYPES.contains(this.getBlockNode().getElementType());
    }

    @NotNull
    public final String getText() {
        String string = this.getBlockNode().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Override
    @NotNull
    public TextRange getRange() {
        TextRange textRange = this.getBlockNode().getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return textRange;
    }

    @Override
    public int getMinLength() {
        return this.getBlockNode().getTextLength();
    }

    public boolean isLeaf() {
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + ": " + StringUtil.trimMiddle((String)this.getText(), (int)80);
    }

    @Override
    @NotNull
    public ASTNode getNode() {
        return this.getBlockNode();
    }
}

