/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.icons.AllIcons;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDeclareStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSetOperatorExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlDefinitionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlSelectIntoNewTableClauseImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlAsExpressionImpl
extends SqlDefinitionImpl
implements SqlAsExpression,
SqlLocalDefinition {
    public SqlAsExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    @NotNull
    public DasType getDasType() {
        DasType dasType = SqlImplUtil.getCacheableDasType(this, this::computeDasType);
        if (dasType == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(1);
        }
        return dasType;
    }

    @NotNull
    protected DasType computeDasType() {
        SqlTableType tableType2;
        DasType type;
        SqlExpression expression = this.getExpression();
        if (expression == null) {
            DasBuiltinType<?> dasBuiltinType = DasTypeSystemBase.UNKNOWN;
            if (dasBuiltinType == null) {
                SqlAsExpressionImpl.$$$reportNull$$$0(2);
            }
            return dasBuiltinType;
        }
        List<SqlDefinition> aliases = this.getColumnAliasList();
        PsiElement parent = this.getParent();
        if (aliases.isEmpty() && expression instanceof SqlValuesExpression && parent instanceof SqlInsertDmlInstruction) {
            SqlTableColumnsList columnsList = ((SqlInsertDmlInstruction)parent).getColumnsList();
            if (columnsList == null) {
                DasBuiltinType<?> dasBuiltinType = DasTypeSystemBase.UNKNOWN;
                if (dasBuiltinType == null) {
                    SqlAsExpressionImpl.$$$reportNull$$$0(3);
                }
                return dasBuiltinType;
            }
            type = columnsList.getDasType();
        } else {
            type = expression.getDasType();
        }
        if (aliases.isEmpty()) {
            if (expression instanceof SqlParenthesizedExpression && ((SqlParenthesizedExpression)expression).isForcedTable()) {
                DasType dasType = type;
                if (dasType == null) {
                    SqlAsExpressionImpl.$$$reportNull$$$0(4);
                }
                return dasType;
            }
            if (type instanceof SqlTableType) {
                tableType2 = (SqlTableType)type;
                if (parent instanceof SqlSelectClause) {
                    DasType dasType = tableType2.getColumnCount() == 1 ? tableType2.getColumnDasType(0) : type;
                    if (dasType == null) {
                        SqlAsExpressionImpl.$$$reportNull$$$0(5);
                    }
                    return dasType;
                }
                SqlTableType sqlTableType = tableType2.aliasByDefs(this.getName(), this, aliases);
                if (sqlTableType == null) {
                    SqlAsExpressionImpl.$$$reportNull$$$0(6);
                }
                return sqlTableType;
            }
            DasType dasType = type;
            if (dasType == null) {
                SqlAsExpressionImpl.$$$reportNull$$$0(7);
            }
            return dasType;
        }
        tableType2 = SqlTableTypeBase.ensureTableType(type, (PsiElement)expression, this);
        if (SqlImplUtil.getSqlDialectSafe(this).getDbms().isPostgres()) {
            aliases = SqlTableTypeBase.expand(aliases, tableType2.getColumnCount());
        }
        SqlTableType sqlTableType = tableType2.aliasByDefs(this.getName(), this, aliases);
        if (sqlTableType == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(8);
        }
        return sqlTableType;
    }

    @Override
    @Nullable
    public PsiElement getDefinitionScope() {
        PsiElement context = this.getContext();
        if (context instanceof SqlDeclareStatement) {
            return this.getTopmostBlockStatement();
        }
        if (PsiUtilCore.getElementType((PsiElement)context) == SqlCompositeElementTypes.SQL_REFERENCING_CLAUSE && SqlImplUtil.getSqlDialectSafe(this).getDbms().isPostgres()) {
            return this.getTopmostBlockStatement();
        }
        if (context instanceof SqlSelectClause && SqlAsExpressionImpl.areAnyContextEnlargersUpwards(context)) {
            return this.getTopmostBlockStatement();
        }
        return PsiTreeUtil.getContextOfType((PsiElement)this, SqlStatement.class, (boolean)true);
    }

    private static boolean areAnyContextEnlargersUpwards(@NotNull PsiElement element) {
        if (element == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(9);
        }
        for (PsiElement tmp = element; tmp != null; tmp = tmp.getContext()) {
            if (tmp instanceof SqlSelectClause || tmp instanceof SqlSetOperatorExpression || tmp instanceof SqlJoinExpression) continue;
            if (tmp instanceof SqlQueryExpression && PsiTreeUtil.getNextSiblingOfType((PsiElement)((SqlQueryExpression)tmp).getSelectClause(), SqlSelectIntoNewTableClauseImpl.class) != null) {
                return true;
            }
            if (tmp instanceof SqlCreateTableStatement) {
                return true;
            }
            if (tmp instanceof SqlStatement) {
                return false;
            }
            if (tmp instanceof SqlFunctionCallExpression) {
                return false;
            }
            if (!(tmp instanceof SqlBinaryExpression)) continue;
            return false;
        }
        return false;
    }

    @NotNull
    public SearchScope getUseScope() {
        PsiElement scope = this.getDefinitionScope();
        return new LocalSearchScope((PsiElement)(scope == null ? this.getContainingFile() : scope));
    }

    protected SqlBlockStatementImpl getTopmostBlockStatement() {
        SqlBlockStatementImpl next;
        SqlBlockStatementImpl answer = (SqlBlockStatementImpl)PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{SqlBlockStatementImpl.class});
        while ((next = (SqlBlockStatementImpl)PsiTreeUtil.getContextOfType((PsiElement)answer, (Class[])new Class[]{SqlBlockStatementImpl.class})) != null) {
            answer = next;
        }
        return answer;
    }

    @Override
    @NotNull
    public List<SqlDefinition> getColumnAliasList() {
        SqlColumnAliasListImpl columnAliasList = this.findChildByClass(SqlColumnAliasListImpl.class);
        List<SqlDefinition> list = columnAliasList != null ? columnAliasList.getColumnAliasList() : Collections.emptyList();
        if (list == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlAsExpression(this);
    }

    @Override
    @Nullable
    public SqlIdentifier getNameElement() {
        return this.findChildByClass(SqlIdentifier.class);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = SqlDbElementType.LOCAL_ALIAS;
        if (objectKind == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(11);
        }
        return objectKind;
    }

    @Nullable
    public PsiReference getReference() {
        return SqlImplUtil.getReference(this, this.getNameElement());
    }

    @Override
    @Nullable
    public SqlExpression getExpression() {
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlExpression.class);
    }

    @Override
    public Icon getIcon() {
        return AllIcons.Nodes.Variable;
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        SqlReferenceExpression asExpression;
        boolean isChild;
        if (processor == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(12);
        }
        if (state == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(13);
        }
        if (place == null) {
            SqlAsExpressionImpl.$$$reportNull$$$0(14);
        }
        if (isChild = PsiTreeUtil.isContextAncestor((PsiElement)this, (PsiElement)place, (boolean)true)) {
            if (place.getParent() instanceof SqlReferenceList && this.getLastChild() == place.getParent()) {
                DasSymbol symbol = DasSymbolUtil.getSymbolByPsi(place);
                return symbol == null || processor.execute(symbol, state);
            }
            if (this.getNode().getElementType() == SqlCompositeElementTypes.SQL_NAMED_QUERY_DEFINITION && !processor.execute(this, state)) {
                return false;
            }
        }
        return !((asExpression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)this.getExpression(), SqlReferenceExpression.class)) != null && this.getColumnAliasList().isEmpty() && !PsiTreeUtil.isContextAncestor((PsiElement)asExpression, (PsiElement)place, (boolean)false) ? asExpression != lastParent && !SqlImplUtil.processQualifier(asExpression, processor, state, place) : !isChild && !SqlImplUtil.processDeclarationsInType(this, processor, state, place));
    }

    @Override
    public short getPosition() {
        return (Short)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)SqlImplUtil.calcPosition(this), (Object[])new Object[]{SqlImplUtil.sqlParent(this)}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlAsExpressionImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlAsExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDasType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAliasList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "areAnyContextEnlargersUpwards";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 11 -> new IllegalStateException(string);
        };
    }
}

