/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCompositeElementType;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.JBIterableClassTraverser;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.JBIterable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class SqlTokenRegistry {
    private static final Map<String, SqlTokenType> ourTokensMap = SqlTokenRegistry.newTokenMap();
    private static final Map<Class, Map<String, SqlKeywordTokenType>> ourClassTokensMap = new HashMap<Class, Map<String, SqlKeywordTokenType>>();
    private static final Map<Class, Set<SqlKeywordTokenType>> ourSynteticTokensMap = new HashMap<Class, Set<SqlKeywordTokenType>>();
    private static final Map<String, IElementType> ourCompositeMap = new HashMap<String, IElementType>();
    private static Consumer<String> ourTestInterceptor;

    private SqlTokenRegistry() {
    }

    @NotNull
    public static SqlTokenType getType(@NotNull String text2) {
        if (text2 == null) {
            SqlTokenRegistry.$$$reportNull$$$0(0);
        }
        return SqlTokenRegistry.getImpl(ourTokensMap, text2, o -> Character.isLetter(o.charAt(0)) ? new SqlKeywordTokenType((String)o) : new SqlTokenType((String)o));
    }

    @NotNull
    public static SqlTokenType getType(@NotNull String text2, @NotNull Function<String, ? extends SqlTokenType> factory) {
        if (text2 == null) {
            SqlTokenRegistry.$$$reportNull$$$0(1);
        }
        if (factory == null) {
            SqlTokenRegistry.$$$reportNull$$$0(2);
        }
        return SqlTokenRegistry.getImpl(ourTokensMap, text2, factory);
    }

    @NotNull
    public static SqlCompositeElementType getCompositeType(@NotNull String debugName) {
        if (debugName == null) {
            SqlTokenRegistry.$$$reportNull$$$0(3);
        }
        return (SqlCompositeElementType)SqlTokenRegistry.getImpl(ourCompositeMap, debugName, o -> new SqlCompositeElementType((String)o));
    }

    @NotNull
    public static <T extends IElementType> T getCompositeType(@NotNull String debugName, @NotNull Function<String, T> factory) {
        if (debugName == null) {
            SqlTokenRegistry.$$$reportNull$$$0(4);
        }
        if (factory == null) {
            SqlTokenRegistry.$$$reportNull$$$0(5);
        }
        return (T)SqlTokenRegistry.getImpl(ourCompositeMap, debugName, factory);
    }

    @TestOnly
    public static void setTestInterceptor(@NotNull Consumer<String> testInterceptor) {
        if (testInterceptor == null) {
            SqlTokenRegistry.$$$reportNull$$$0(6);
        }
        ourTestInterceptor = testInterceptor;
    }

    @NotNull
    private static synchronized <T extends IElementType> T getImpl(@NotNull Map<String, ? super T> map, @NotNull String debugName, @NotNull Function<String, T> factory) {
        IElementType type;
        if (map == null) {
            SqlTokenRegistry.$$$reportNull$$$0(7);
        }
        if (debugName == null) {
            SqlTokenRegistry.$$$reportNull$$$0(8);
        }
        if (factory == null) {
            SqlTokenRegistry.$$$reportNull$$$0(9);
        }
        if ((type = (IElementType)map.get(debugName)) == null) {
            type = Objects.requireNonNull((IElementType)factory.fun((Object)debugName));
            map.put(debugName, type);
            if (ourTestInterceptor != null) {
                ourTestInterceptor.consume((Object)debugName);
            }
        }
        IElementType iElementType = type;
        if (iElementType == null) {
            SqlTokenRegistry.$$$reportNull$$$0(10);
        }
        return (T)iElementType;
    }

    @Nullable
    public static synchronized SqlTokenType findTokenType(@NotNull String text2) {
        if (text2 == null) {
            SqlTokenRegistry.$$$reportNull$$$0(11);
        }
        return ourTokensMap.get(text2);
    }

    @Nullable
    public static synchronized IElementType findCompositeType(@NotNull String text2) {
        if (text2 == null) {
            SqlTokenRegistry.$$$reportNull$$$0(12);
        }
        return ourCompositeMap.get(text2);
    }

    @Nullable
    public static synchronized IElementType findType(@NotNull String text2) {
        SqlTokenType token;
        if (text2 == null) {
            SqlTokenRegistry.$$$reportNull$$$0(13);
        }
        if ((token = ourTokensMap.get(text2)) != null) {
            return token;
        }
        return ourCompositeMap.get(text2);
    }

    @NotNull
    public static synchronized Iterable<IElementType> getAllCompositeTypes() {
        Collection<IElementType> collection = ourCompositeMap.values();
        if (collection == null) {
            SqlTokenRegistry.$$$reportNull$$$0(14);
        }
        return collection;
    }

    public static void initTypeMap(@NotNull Class clazz, @Nullable Set<String> exclude) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(15);
        }
        Map<String, SqlKeywordTokenType> map = SqlTokenRegistry.buildTokenMap(clazz, SqlTokenRegistry.newTokenMap());
        if (exclude != null) {
            map.keySet().removeAll(exclude);
        }
        SqlTokenRegistry.setTypeMap(clazz, map, false);
    }

    public static synchronized void addTokensToClassMap(@NotNull Class clazz, @NotNull Set<String> keywordSet, boolean storeNewAsSynthetic) {
        Set<SqlKeywordTokenType> synthetic;
        Map<String, SqlKeywordTokenType> map;
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(16);
        }
        if (keywordSet == null) {
            SqlTokenRegistry.$$$reportNull$$$0(17);
        }
        if ((map = ourClassTokensMap.get(clazz)) == null) {
            map = SqlTokenRegistry.newTokenMap();
        }
        Set<SqlKeywordTokenType> set = synthetic = storeNewAsSynthetic ? ourSynteticTokensMap.get(clazz) : null;
        if (storeNewAsSynthetic && synthetic == null) {
            synthetic = new HashSet<SqlKeywordTokenType>();
        }
        for (String s : keywordSet) {
            if (map.containsKey(s)) continue;
            String upperCase = StringUtil.toUpperCase((String)s);
            SqlKeywordTokenType type = (SqlKeywordTokenType)SqlTokenRegistry.getType(upperCase);
            map.put(upperCase, type);
            if (synthetic == null) continue;
            synthetic.add(type);
        }
        SqlTokenRegistry.setTypeMap(clazz, map, true);
        if (storeNewAsSynthetic) {
            ourSynteticTokensMap.put(clazz, synthetic);
        }
    }

    private static synchronized void setTypeMap(@NotNull Class clazz, @NotNull Map<String, SqlKeywordTokenType> map, boolean force) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(18);
        }
        if (map == null) {
            SqlTokenRegistry.$$$reportNull$$$0(19);
        }
        if (!force && ourClassTokensMap.containsKey(clazz)) {
            return;
        }
        ourClassTokensMap.put(clazz, map);
    }

    @NotNull
    public static NullableFunction<String, IElementType> getTokenProvider(@NotNull Class clazz) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(20);
        }
        NullableFunction nullableFunction = SqlTokenRegistry.getSafeMap(clazz)::get;
        if (nullableFunction == null) {
            SqlTokenRegistry.$$$reportNull$$$0(21);
        }
        return nullableFunction;
    }

    public static Set<SqlKeywordTokenType> getSyntheticTokens(Class clazz) {
        Set<SqlKeywordTokenType> synthetic = ourSynteticTokensMap.get(clazz);
        if (synthetic == null) {
            throw new AssertionError((Object)(String.valueOf(clazz) + " synthetic token map not initialized"));
        }
        return Collections.unmodifiableSet(synthetic);
    }

    public static Set<String> getTokens(Class clazz) {
        return Collections.unmodifiableSet(SqlTokenRegistry.getSafeMap(clazz).keySet());
    }

    @NotNull
    private static synchronized Map<String, SqlKeywordTokenType> getSafeMap(@NotNull Class clazz) {
        Map<String, SqlKeywordTokenType> result2;
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(22);
        }
        if ((result2 = ourClassTokensMap.get(clazz)) == null) {
            throw new AssertionError((Object)(String.valueOf(clazz) + " token map not initialized"));
        }
        Map<String, SqlKeywordTokenType> map = result2;
        if (map == null) {
            SqlTokenRegistry.$$$reportNull$$$0(23);
        }
        return map;
    }

    private static <T extends IElementType> Map<String, T> newTokenMap() {
        return CollectionFactory.createCaseInsensitiveStringMap();
    }

    private static Map<String, SqlKeywordTokenType> buildTokenMap(@NotNull Class clazz, @NotNull Map<String, SqlKeywordTokenType> map) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(24);
        }
        if (map == null) {
            SqlTokenRegistry.$$$reportNull$$$0(25);
        }
        SqlTokenRegistry.consumeStaticFieldsInOrder(clazz, (PairConsumer<Field, Object>)((PairConsumer)(field, value) -> {
            if (value instanceof SqlKeywordTokenType) {
                SqlKeywordTokenType tokenType = (SqlKeywordTokenType)((Object)((Object)value));
                map.put(tokenType.toString(), tokenType);
            }
        }));
        return map;
    }

    public static void consumeStaticFieldsInOrder(@NotNull Class clazz, @NotNull PairConsumer<Field, Object> processor) {
        if (clazz == null) {
            SqlTokenRegistry.$$$reportNull$$$0(26);
        }
        if (processor == null) {
            SqlTokenRegistry.$$$reportNull$$$0(27);
        }
        JBIterable fields = JBIterableClassTraverser.classTraverser((Class)clazz).postOrderDfsTraversal().flatMap(o -> JBIterable.of((Object[])o.getDeclaredFields())).filter(o -> Modifier.isStatic(o.getModifiers()));
        for (Field field : fields) {
            try {
                processor.consume((Object)field, field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public static void ensureInterfacesAreInitializedInOrder(@NotNull Class<?> factoryClass) {
        if (factoryClass == null) {
            SqlTokenRegistry.$$$reportNull$$$0(28);
        }
        JBIterable interfaces = JBIterableClassTraverser.classTraverser(factoryClass).postOrderDfsTraversal().filter(o -> o.isInterface());
        for (Class aClass : interfaces) {
            Field[] fields = aClass.getDeclaredFields();
            if (fields.length == 0) continue;
            try {
                fields[0].setAccessible(true);
                fields[0].get(null);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testInterceptor";
                break;
            }
            case 7: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 10: 
            case 14: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/util/SqlTokenRegistry";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordSet";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/util/SqlTokenRegistry";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllCompositeTypes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenProvider";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSafeMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCompositeType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTestInterceptor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getImpl";
                break;
            }
            case 10: 
            case 14: 
            case 21: 
            case 23: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findTokenType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findCompositeType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initTypeMap";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addTokensToClassMap";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setTypeMap";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTokenProvider";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSafeMap";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "buildTokenMap";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "consumeStaticFieldsInOrder";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "ensureInterfacesAreInitializedInOrder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 14, 21, 23 -> new IllegalStateException(string);
        };
    }
}

