/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.jinja.template.tags.Jinja2LoadTag;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.python.django.lang.template.inspection.DjangoInspectionVisitorAdapter;
import com.intellij.python.django.lang.template.inspection.DjangoTemplateLocalInspectionTool;
import com.jetbrains.django.lang.template.ref.DjangoLoadTagsReference;
import com.jetbrains.django.lang.template.ref.DjangoLoadedNameReference;
import com.jetbrains.django.ui.DjangoBundle;
import org.jetbrains.annotations.NotNull;

public final class UnresolvedLoadReferenceInspection
extends DjangoTemplateLocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "DjangoUnresolvedLoadInspection";
    }

    @Override
    protected PsiElementVisitor createInspectionVisitor(InspectionManager manager) {
        return new DjangoTagVisitor(manager);
    }

    private static final class DjangoTagVisitor
    extends DjangoInspectionVisitorAdapter {
        private DjangoTagVisitor(InspectionManager manager) {
            super(manager);
        }

        public void visitLoadTag(Jinja2LoadTag loadTag) {
            for (PsiReference ref : loadTag.getReferences()) {
                ASTNode memberNode;
                if (ref instanceof DjangoLoadTagsReference && ref.resolve() == null) {
                    memberNode = ((DjangoLoadTagsReference)ref).getMemberNode();
                    if (memberNode == null) continue;
                    this.reportProblem(memberNode.getPsi(), DjangoBundle.message((String)"inspection.unresolved-load.error-msg", (Object[])new Object[]{memberNode.getPsi().getText()}));
                    continue;
                }
                if (!(ref instanceof DjangoLoadedNameReference) || ref.resolve() != null || (memberNode = ((DjangoLoadedNameReference)ref).getMemberNode()) == null) continue;
                this.reportProblem(memberNode.getPsi(), DjangoBundle.message((String)"inspection.unresolved-name.error-msg", (Object[])new Object[]{memberNode.getPsi().getText()}));
            }
        }

        private void reportProblem(PsiElement elem, @InspectionMessage String msg) {
            ProblemDescriptor d = this.myManager.createProblemDescriptor(elem, new TextRange(0, elem.getTextLength()), msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
            this.myProblems.add(d);
        }
    }
}

