/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.model.fieldsAsArguments;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.django.model.fieldsAsArguments.FieldsAsArgumentsUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.codeInsight.DjangoQuerySetMethod;
import com.jetbrains.django.codeInsight.DjangoQuerySetMethodsKt;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.DjangoModel;
import com.jetbrains.django.model.fieldsAsArguments.fieldReferencesObtainer.DjangoFieldReferencesObtainer;
import com.jetbrains.django.model.fieldsAsArguments.fieldReferencesObtainer.FieldReferencesDirections;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyKeywordArgumentProvider;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoFieldLookupKeywordArgumentProvider
implements PyKeywordArgumentProvider {
    private static final String @NotNull [] REGEXP_LOOKUPS = new String[]{"regex", "iregex"};
    private static final String @NotNull [] ANY_TYPE_LOOKUPS = new String[]{"exact", "in", "isnull"};
    private static final String @NotNull [] STRING_LOOKUPS = ArrayUtil.mergeArrays((String[])new String[]{"iexact", "contains", "icontains", "startswith", "istartswith", "endswith", "iendswith", "search"}, (String[])REGEXP_LOOKUPS);
    private static final String @NotNull [] RANGE_LOOKUPS = new String[]{"gt", "gte", "lt", "lte", "range"};
    private static final String @NotNull [] DATE_LOOKUPS = ArrayUtil.mergeArrays((String[])RANGE_LOOKUPS, (String[])new String[]{"year", "month", "day", "week_day"});
    private static final String @NotNull [] DATE_TIME_LOOKUPS = new String[]{"hour", "minute", "second"};
    @NotNull
    private static final Map<String, String[]> TYPE_TO_LOOKUP = new HashMap<String, String[]>();
    private static final Key<CachedValue<Pair<List<String>, List<String>>>> DJANGO_KWARGS = Key.create((String)"DJANGO_KWARGS");
    @NotNull
    private static final List<String> METHODS_WITH_LOOKUP;
    @NotNull
    private static final List<String> OBJECTS_IN_METHODS_WITH_LOOKUP;

    @NotNull
    public List<String> getKeywordArguments(@NotNull PyFunction function, @NotNull PyCallExpression callExpr) {
        if (function == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(0);
        }
        if (callExpr == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(1);
        }
        if (DjangoFacet.getInstance((PsiElement)callExpr) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        Pair<List<String>, List<String>> pair = DjangoFieldLookupKeywordArgumentProvider.getKeywordArgumentsPair(function, callExpr);
        List list = pair != null ? (List)pair.first : Collections.emptyList();
        if (list == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    static Pair<List<String>, List<String>> getKeywordArgumentsPair(@NotNull PyFunction function, @NotNull PyCallExpression callExpr) {
        if (function == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(4);
        }
        if (callExpr == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(5);
        }
        if (!DjangoFieldLookupKeywordArgumentProvider.expressionPointsToFunction(callExpr, function)) {
            return DjangoFieldLookupKeywordArgumentProvider.getKeywordsArgumentsPairInternal(function, callExpr);
        }
        CachedValuesManager cacheManager = CachedValuesManager.getManager((Project)function.getProject());
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)function.getProject());
        SmartPsiElementPointer pointer = manager.createSmartPsiElementPointer((PsiElement)function);
        return (Pair)cacheManager.getCachedValue((UserDataHolder)callExpr, DJANGO_KWARGS, () -> CachedValueProvider.Result.create(DjangoFieldLookupKeywordArgumentProvider.getKeywordsArgumentsPairInternal((SmartPsiElementPointer<PyFunction>)pointer, callExpr), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
    }

    private static boolean expressionPointsToFunction(@NotNull PyCallExpression callExpr, @NotNull PyFunction function) {
        PyExpression callee;
        if (callExpr == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(6);
        }
        if (function == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(7);
        }
        if ((callee = callExpr.getCallee()) == null) {
            return false;
        }
        PsiReference reference = callee.getReference();
        if (reference == null) {
            return false;
        }
        return reference.isReferenceTo((PsiElement)function);
    }

    @Nullable
    private static Pair<List<String>, List<String>> getKeywordsArgumentsPairInternal(@NotNull SmartPsiElementPointer<PyFunction> function, @NotNull PyCallExpression callExpr) {
        if (function == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(8);
        }
        if (callExpr == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(9);
        }
        return DjangoFieldLookupKeywordArgumentProvider.getKeywordsArgumentsPairInternal((PyFunction)function.getElement(), callExpr);
    }

    @Nullable
    private static Pair<List<String>, List<String>> getKeywordsArgumentsPairInternal(@Nullable PyFunction function, @NotNull PyCallExpression callExpr) {
        if (callExpr == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(10);
        }
        TypeEvalContext context = TypeEvalContext.codeCompletion((Project)callExpr.getProject(), (PsiFile)callExpr.getContainingFile());
        if (function == null && (function = DjangoFieldLookupKeywordArgumentProvider.geFunctionWithKwArgsFromCallExpression(callExpr, context)) == null) {
            return null;
        }
        PyClassType callerExpressionType = (PyClassType)ObjectUtils.tryCast((Object)context.getType((PyTypedElement)callExpr), PyClassType.class);
        PyReferenceExpression referenceExpression = (PyReferenceExpression)ObjectUtils.tryCast((Object)callExpr.getCallee(), PyReferenceExpression.class);
        if (callerExpressionType != null && referenceExpression != null && DjangoFieldLookupKeywordArgumentProvider.isMethodAcceptsKeywordArguments(function, callerExpressionType, context)) {
            Set<String> arguments = DjangoFieldLookupKeywordArgumentProvider.getKeywordsForObjectCreationMethod(context, referenceExpression);
            return new Pair(new ArrayList<String>(arguments), Collections.emptyList());
        }
        PyReferenceExpression methodWithLookup = DjangoFieldLookupKeywordArgumentProvider.getMethodExpression(function, callExpr, context);
        if (methodWithLookup == null) {
            return null;
        }
        Map fieldToType = DjangoFieldReferencesObtainer.getFieldReferencesForMethod((PyReferenceExpression)methodWithLookup, (TypeEvalContext)context, (FieldReferencesDirections)new FieldReferencesDirections(true, FieldReferencesDirections.ALL_RELATIONS).followDirectRelations(FieldReferencesDirections.ALL_RELATIONS).followReverseRelations(FieldReferencesDirections.ALL_RELATIONS).withRemovingSetsFromReverse());
        ArrayList<String> result = new ArrayList<String>(fieldToType.size());
        ArrayList<String> regexps = new ArrayList<String>();
        for (Map.Entry entry : fieldToType.entrySet()) {
            String fieldName = (String)entry.getKey();
            PyType fieldType = (PyType)((Pair)entry.getValue()).first;
            result.add(fieldName);
            for (String lookup : DjangoFieldLookupKeywordArgumentProvider.getLookupsByType(fieldType)) {
                String keyword = String.format("%s__%s", fieldName, lookup);
                result.add(keyword);
                if (!ArrayUtil.contains((String)lookup, (String[])REGEXP_LOOKUPS)) continue;
                regexps.add(keyword);
            }
        }
        return Pair.create(result, regexps);
    }

    @Nullable
    private static PyFunction geFunctionWithKwArgsFromCallExpression(@NotNull PyCallExpression callExpr, @NotNull TypeEvalContext context) {
        PyExpression callee;
        if (callExpr == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(11);
        }
        if (context == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(12);
        }
        if ((callee = callExpr.getCallee()) == null) {
            return null;
        }
        PyFunctionType functionType = (PyFunctionType)PyUtil.as((Object)context.getType((PyTypedElement)callee), PyFunctionType.class);
        if (functionType != null) {
            return (PyFunction)PyUtil.as((Object)functionType.getCallable(), PyFunction.class);
        }
        PyClassType classType = (PyClassType)PyUtil.as((Object)context.getType((PyTypedElement)callee), PyClassType.class);
        if (classType != null) {
            return classType.getPyClass().findInitOrNew(true, context);
        }
        return null;
    }

    private static boolean isMethodAcceptsKeywordArguments(@NotNull PyFunction function, @NotNull PyClassType callerExpressionType, @NotNull TypeEvalContext context) {
        PyClass aClass;
        DjangoQuerySetMethod method;
        if (function == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(13);
        }
        if (callerExpressionType == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(14);
        }
        if (context == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(15);
        }
        PyClass model = null;
        if (PyUtil.isInitMethod((PsiElement)function)) {
            model = callerExpressionType.getPyClass();
        }
        if ((method = DjangoQuerySetMethodsKt.findQuerySetMethod((String)function.getName())) != null && method.getAcceptsKeyword() && (aClass = function.getContainingClass()) != null && ("QuerySet".equals(aClass.getName()) || "Manager".equals(aClass.getName()))) {
            model = method.getReturns().getModelTypeByReturnType(callerExpressionType);
        }
        return model != null && DjangoModel.isDjangoModelDescendant((PyClass)model, (TypeEvalContext)context);
    }

    @Nullable
    private static PyReferenceExpression getMethodExpression(@NotNull PyFunction function, @NotNull PyCallExpression callExpr, @NotNull TypeEvalContext context) {
        PyReferenceExpression methodWithLookup;
        if (function == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(16);
        }
        if (callExpr == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(17);
        }
        if (context == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(18);
        }
        if ((methodWithLookup = FieldsAsArgumentsUtils.getCalleeIfNameMatches(METHODS_WITH_LOOKUP, function, callExpr, context)) == null) {
            PyReferenceExpression objectInMethodWithLookup = FieldsAsArgumentsUtils.getCalleeIfNameMatches(OBJECTS_IN_METHODS_WITH_LOOKUP, function, callExpr, context);
            if (objectInMethodWithLookup == null) {
                return null;
            }
            PyCallExpression parentCallExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)callExpr, PyCallExpression.class);
            if (parentCallExpression == null) {
                return null;
            }
            methodWithLookup = FieldsAsArgumentsUtils.getCalleeIfNameMatches(METHODS_WITH_LOOKUP, null, parentCallExpression, context);
        }
        if (methodWithLookup == null) {
            return null;
        }
        return methodWithLookup;
    }

    @NotNull
    private static Set<String> getKeywordsForObjectCreationMethod(@NotNull TypeEvalContext context, @NotNull PyReferenceExpression initExpression) {
        if (context == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(19);
        }
        if (initExpression == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(20);
        }
        FieldReferencesDirections directions = new FieldReferencesDirections(true, FieldReferencesDirections.ALL_EXCEPT_MANY_TO_MANY);
        Map arguments = DjangoFieldReferencesObtainer.getFieldReferencesForMethod((PyReferenceExpression)initExpression, (TypeEvalContext)context, (FieldReferencesDirections)directions);
        Set<String> set = arguments.keySet();
        if (set == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(21);
        }
        return set;
    }

    @NotNull
    private static Collection<String> getLookupsByType(@NotNull PyType type) {
        if (type == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(22);
        }
        HashSet result = ContainerUtil.newHashSet((Object[])ANY_TYPE_LOOKUPS);
        String[] typeSpecific = TYPE_TO_LOOKUP.get(type.getName());
        if (typeSpecific == null && type instanceof PyClassType) {
            typeSpecific = TYPE_TO_LOOKUP.get(((PyClassType)type).getClassQName());
        }
        if (typeSpecific != null) {
            result.addAll(Arrays.asList(typeSpecific));
        }
        HashSet hashSet = result;
        if (hashSet == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    static boolean isArgumentMayBeRegex(@NotNull String functionName, @NotNull String argumentName) {
        if (functionName == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(24);
        }
        if (argumentName == null) {
            DjangoFieldLookupKeywordArgumentProvider.$$$reportNull$$$0(25);
        }
        if (!METHODS_WITH_LOOKUP.contains(functionName)) {
            return false;
        }
        for (String lookup : REGEXP_LOOKUPS) {
            if (!argumentName.contains(lookup)) continue;
            return true;
        }
        return false;
    }

    static {
        TYPE_TO_LOOKUP.put("int", RANGE_LOOKUPS);
        for (String stringType : PyNames.TYPE_STRING_TYPES) {
            TYPE_TO_LOOKUP.put(stringType, STRING_LOOKUPS);
        }
        TYPE_TO_LOOKUP.put("datetime.datetime", ArrayUtil.mergeArrays((String[])DATE_LOOKUPS, (String[])DATE_TIME_LOOKUPS));
        TYPE_TO_LOOKUP.put("datetime.time", DATE_TIME_LOOKUPS);
        TYPE_TO_LOOKUP.put("datetime.date", DATE_LOOKUPS);
        METHODS_WITH_LOOKUP = Arrays.asList("filter", "exclude", "get");
        OBJECTS_IN_METHODS_WITH_LOOKUP = Collections.singletonList("Q");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 2: 
            case 3: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/model/fieldsAsArguments/DjangoFieldLookupKeywordArgumentProvider";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callerExpressionType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initExpression";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/model/fieldsAsArguments/DjangoFieldLookupKeywordArgumentProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordArguments";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordsForObjectCreationMethod";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupsByType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordArguments";
                break;
            }
            case 2: 
            case 3: 
            case 21: 
            case 23: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordArgumentsPair";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "expressionPointsToFunction";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordsArgumentsPairInternal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "geFunctionWithKwArgsFromCallExpression";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isMethodAcceptsKeywordArguments";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMethodExpression";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getKeywordsForObjectCreationMethod";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getLookupsByType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isArgumentMayBeRegex";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 21, 23 -> new IllegalStateException(string);
        };
    }
}

