/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.unusedLocal;

import com.intellij.codeInsight.controlflow.ControlFlowUtil;
import com.intellij.codeInsight.controlflow.Instruction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ReadWriteInstruction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddFieldQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveAssignmentStatementTargetQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveExceptionTargetQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveParameterQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveStatementQuickFix;
import com.jetbrains.python.inspections.quickfix.PyRemoveWithTargetQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyAugAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyTypeParameter;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.impl.PyAugAssignmentStatementNavigator;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyExceptPartNavigator;
import com.jetbrains.python.psi.impl.PyForStatementNavigator;
import com.jetbrains.python.psi.impl.PyImportStatementNavigator;
import com.jetbrains.python.psi.impl.PyTypeDeclarationStatementNavigator;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.psi.search.PySuperMethodsSearch;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PyUnusedLocalInspectionVisitor
extends PyInspectionVisitor {
    private final boolean myIgnoreTupleUnpacking;
    private final boolean myIgnoreLambdaParameters;
    private final boolean myIgnoreRangeIterationVariables;
    private final boolean myIgnoreVariablesStartingWithUnderscore;
    private final Map<ScopeOwner, @Unmodifiable Set<PsiElement>> myScopeWrites;
    private final Map<ScopeOwner, @Unmodifiable Set<PsiElement>> myScopeReads;

    public PyUnusedLocalInspectionVisitor(@NotNull ProblemsHolder holder, boolean ignoreTupleUnpacking, boolean ignoreLambdaParameters, boolean ignoreRangeIterationVariables, boolean ignoreVariablesStartingWithUnderscore, @NotNull TypeEvalContext context) {
        if (holder == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(1);
        }
        super(holder, context);
        this.myScopeWrites = new ConcurrentHashMap<ScopeOwner, Set<PsiElement>>();
        this.myScopeReads = new ConcurrentHashMap<ScopeOwner, Set<PsiElement>>();
        this.myIgnoreTupleUnpacking = ignoreTupleUnpacking;
        this.myIgnoreLambdaParameters = ignoreLambdaParameters;
        this.myIgnoreRangeIterationVariables = ignoreRangeIterationVariables;
        this.myIgnoreVariablesStartingWithUnderscore = ignoreVariablesStartingWithUnderscore;
    }

    @Override
    public void visitPyElement(@NotNull PyElement node) {
        if (node == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(2);
        }
        if (node instanceof ScopeOwner) {
            ScopeOwner scopeOwner = (ScopeOwner)node;
            if (!(node instanceof PyFile)) {
                this.processScope(scopeOwner);
            }
        }
    }

    private void processScope(ScopeOwner owner) {
        PyFunction pyFunction;
        if (owner.getContainingFile() instanceof PyExpressionCodeFragment) {
            return;
        }
        if (owner instanceof PyFunction && PyiUtil.isOverload(pyFunction = (PyFunction)owner, this.myTypeEvalContext)) {
            return;
        }
        if (!(owner instanceof PyClass) && !PyUnusedLocalInspectionVisitor.callsLocals(owner)) {
            this.collectAllWrites(owner);
        }
        owner.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyElement(@NotNull PyElement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node instanceof ScopeOwner) {
                    ScopeOwner scopeOwner = (ScopeOwner)node;
                    PyUnusedLocalInspectionVisitor.this.collectUsedReads(scopeOwner);
                }
                super.visitPyElement(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/inspections/unusedLocal/PyUnusedLocalInspectionVisitor$1", "visitPyElement"));
            }
        });
    }

    private void collectAllWrites(ScopeOwner owner) {
        Instruction[] instructions = ControlFlowCache.getControlFlow(owner).getInstructions();
        HashSet<PsiElement> scopeWrites = new HashSet<PsiElement>();
        for (Instruction instruction : instructions) {
            ReadWriteInstruction readWriteInstruction;
            ReadWriteInstruction.ACCESS access;
            PsiElement element = instruction.getElement();
            if (element instanceof PyFunction && owner instanceof PyFunction) {
                if (PyKnownDecoratorUtil.hasUnknownDecorator((PyFunction)element, this.myTypeEvalContext)) continue;
                scopeWrites.add(element);
                continue;
            }
            if (!(instruction instanceof ReadWriteInstruction) || !(access = (readWriteInstruction = (ReadWriteInstruction)instruction).getAccess()).isWriteAccess()) continue;
            String name2 = readWriteInstruction.getName();
            Scope scope = ControlFlowCache.getScope(owner);
            if (name2 == null || "_".equals(name2) || scope.isGlobal(name2) || scope.isNonlocal(name2) || element instanceof PyTargetExpression && ((PyTargetExpression)element).isQualified() || name2.startsWith("_") && element instanceof PyParameter || element == null || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)element, (boolean)false) || PyImportStatementNavigator.getImportStatementByElement(element) != null || PyAugAssignmentStatementNavigator.getStatementByTarget(element) != null || PyUnusedLocalInspectionVisitor.parameterInMethodWithFixedSignature(owner, element) || PyTypeDeclarationStatementNavigator.isTypeDeclarationTarget(element)) continue;
            scopeWrites.add(element);
        }
        this.myScopeWrites.put(owner, Collections.unmodifiableSet(scopeWrites));
    }

    private static boolean parameterInMethodWithFixedSignature(@NotNull ScopeOwner owner, @NotNull PsiElement element) {
        if (owner == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(4);
        }
        if (owner instanceof PyFunction) {
            PyFunction function = (PyFunction)owner;
            if (element instanceof PyParameter) {
                String functionName = function.getName();
                LanguageLevel level = LanguageLevel.forElement((PsiElement)function);
                Map builtinMethods = function.getContainingClass() != null ? PyNames.getBuiltinMethods((LanguageLevel)level) : PyNames.getModuleBuiltinMethods((LanguageLevel)level);
                return functionName != null && !"__init__".equals(functionName) && builtinMethods.containsKey(functionName);
            }
        }
        return false;
    }

    @NotNull
    private Set<PsiElement> analyzeReadsInDoctests(final @NotNull PyStringLiteralExpression docstring, final @NotNull ScopeOwner owner) {
        PsiElement instrAnchor;
        if (docstring == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(5);
        }
        if (owner == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(6);
        }
        if ((instrAnchor = PsiTreeUtil.getParentOfType((PsiElement)docstring, PyStatement.class)) == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(7);
            }
            return set;
        }
        final Instruction[] instructions = ControlFlowCache.getControlFlow(owner).getInstructions();
        final int startInstruction = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)instrAnchor);
        if (startInstruction < 0) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(8);
            }
            return set;
        }
        Project project = docstring.getProject();
        List pairs = InjectedLanguageManager.getInstance((Project)project).getInjectedPsiFiles((PsiElement)docstring);
        if (pairs != null) {
            final HashSet<PsiElement> result2 = new HashSet<PsiElement>();
            for (Pair pair : pairs) {
                ((PsiElement)pair.getFirst()).accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

                    @Override
                    public void visitPyReferenceExpression(@NotNull PyReferenceExpression expr) {
                        PyExpression qualifier;
                        if (expr == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        if ((qualifier = expr.getQualifier()) != null) {
                            qualifier.accept(this);
                            return;
                        }
                        String name2 = expr.getName();
                        if (name2 != null) {
                            result2.addAll(PyUnusedLocalInspectionVisitor.analyzeReadsInScope(name2, owner, instructions, startInstruction, (PsiElement)docstring));
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/jetbrains/python/inspections/unusedLocal/PyUnusedLocalInspectionVisitor$2", "visitPyReferenceExpression"));
                    }
                });
            }
            HashSet<PsiElement> hashSet = result2;
            if (hashSet == null) {
                PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(9);
            }
            return hashSet;
        }
        Set<PsiElement> set = Collections.emptySet();
        if (set == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(10);
        }
        return set;
    }

    private void collectUsedReads(ScopeOwner owner) {
        PyDocStringOwner docStringOwner;
        PyStringLiteralExpression docstring;
        if (this.myScopeReads.containsKey(owner)) {
            return;
        }
        HashSet<PsiElement> allPathsScopeReads = new HashSet<PsiElement>();
        if (owner instanceof PyDocStringOwner && (docstring = (docStringOwner = (PyDocStringOwner)((Object)owner)).getDocStringExpression()) != null) {
            allPathsScopeReads.addAll(this.analyzeReadsInDoctests(docstring, owner));
        }
        Instruction[] instructions = ControlFlowCache.getControlFlow(owner).getInstructions();
        for (int i = 0; i < instructions.length; ++i) {
            int startInstruction;
            PsiElement element;
            String name2;
            ReadWriteInstruction readWriteInstruction;
            ReadWriteInstruction.ACCESS access;
            Instruction instruction = instructions[i];
            if (!(instruction instanceof ReadWriteInstruction) || !(access = (readWriteInstruction = (ReadWriteInstruction)instruction).getAccess()).isReadAccess() || (name2 = readWriteInstruction.getName()) == null || (element = instruction.getElement()) == null || !PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)element, (boolean)false)) continue;
            if (access.isWriteAccess()) {
                PyAugAssignmentStatement augAssignmentStatement = PyAugAssignmentStatementNavigator.getStatementByTarget(element);
                startInstruction = ControlFlowUtil.findInstructionNumberByElement((Instruction[])instructions, (PsiElement)augAssignmentStatement);
            } else {
                startInstruction = i;
            }
            allPathsScopeReads.addAll(PyUnusedLocalInspectionVisitor.analyzeReadsInScope(name2, owner, instructions, startInstruction, (PsiElement)PyUtil.as(element, PyReferenceExpression.class)));
        }
        this.myScopeReads.put(owner, Collections.unmodifiableSet(allPathsScopeReads));
    }

    @NotNull
    private static Set<PsiElement> analyzeReadsInScope(@NotNull String name2, @NotNull ScopeOwner owner, Instruction @NotNull [] instructions, int startInstruction, @Nullable PsiElement scopeAnchor) {
        ScopeOwner declOwner;
        if (name2 == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(11);
        }
        if (owner == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(12);
        }
        if (instructions == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(13);
        }
        HashSet<PsiElement> readsFromInstruction = new HashSet<PsiElement>();
        if (scopeAnchor != null && (declOwner = ScopeUtil.getDeclarationScopeOwner(scopeAnchor, name2)) != null && declOwner != owner) {
            readsFromInstruction.addAll(ScopeUtil.getElementsOfAccessType(name2, declOwner, ReadWriteInstruction.ACCESS.WRITE));
        }
        ControlFlowUtil.iteratePrev((int)startInstruction, (Instruction[])instructions, inst -> {
            ReadWriteInstruction rwInstruction;
            PsiElement instElement = inst.getElement();
            if (instElement instanceof PyFunction) {
                if (name2.equals(((PyFunction)instElement).getName())) {
                    readsFromInstruction.add(instElement);
                    return ControlFlowUtil.Operation.CONTINUE;
                }
            } else if (inst instanceof ReadWriteInstruction && (rwInstruction = (ReadWriteInstruction)((Object)inst)).getAccess().isWriteAccess() && name2.equals(rwInstruction.getName())) {
                if (instElement != null && PyTypeDeclarationStatementNavigator.isTypeDeclarationTarget(instElement)) {
                    return ControlFlowUtil.Operation.NEXT;
                }
                if (instElement != null && PsiTreeUtil.isAncestor((PsiElement)owner, (PsiElement)instElement, (boolean)false)) {
                    readsFromInstruction.add(instElement);
                }
                return ControlFlowUtil.Operation.CONTINUE;
            }
            return ControlFlowUtil.Operation.NEXT;
        });
        HashSet<PsiElement> hashSet = readsFromInstruction;
        if (hashSet == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    private static boolean callsLocals(ScopeOwner owner) {
        try {
            owner.acceptChildren(new PyRecursiveElementVisitor(){

                @Override
                public void visitPyCallExpression(@NotNull PyCallExpression node) {
                    PyExpression callee;
                    if (node == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if ((callee = node.getCallee()) != null && "locals".equals(callee.getName())) {
                        throw new DontPerformException();
                    }
                    node.acceptChildren(this);
                }

                @Override
                public void visitPyFunction(@NotNull PyFunction node) {
                    if (node == null) {
                        3.$$$reportNull$$$0(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "node";
                    objectArray2[1] = "com/jetbrains/python/inspections/unusedLocal/PyUnusedLocalInspectionVisitor$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyCallExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitPyFunction";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        catch (DontPerformException e) {
            return true;
        }
        return false;
    }

    public void registerProblems() {
        List filters = PyInspectionExtension.EP_NAME.getExtensionList();
        HashSet<PyFunction> functionsWithInheritors = new HashSet<PyFunction>();
        HashMap<PyFunction, Boolean> emptyFunctions = new HashMap<PyFunction, Boolean>();
        Set unusedElements = StreamEx.of(this.myScopeWrites.entrySet()).flatCollection(writeEntry -> ContainerUtil.subtract((Collection)((Collection)writeEntry.getValue()), this.getReadsInsideScope((ScopeOwner)writeEntry.getKey()))).toImmutableSet();
        for (PsiElement element : unusedElements) {
            Object name2;
            boolean ignoreUnused = false;
            for (PyInspectionExtension filter : filters) {
                if (!filter.ignoreUnused(element, this.myTypeEvalContext)) continue;
                ignoreUnused = true;
            }
            if (ignoreUnused) continue;
            if (element instanceof PyFunction) {
                PsiElement nameIdentifier = ((PyFunction)element).getNameIdentifier();
                this.registerWarning(nameIdentifier == null ? element : nameIdentifier, PyPsiBundle.message("INSP.unused.locals.local.function.isnot.used", ((PyFunction)element).getName()), new LocalQuickFix[]{new PyRemoveStatementQuickFix()});
                continue;
            }
            if (element instanceof PyClass) {
                PyClass cls = (PyClass)element;
                name2 = cls.getNameIdentifier();
                this.registerWarning((PsiElement)(name2 != null ? name2 : element), PyPsiBundle.message("INSP.unused.locals.local.class.isnot.used", cls.getName()), new LocalQuickFix[]{new PyRemoveStatementQuickFix()});
                continue;
            }
            if (element instanceof PyTypeAliasStatement) {
                PyTypeAliasStatement typeAlias = (PyTypeAliasStatement)element;
                name2 = typeAlias.getNameIdentifier();
                this.registerWarning((PsiElement)(name2 != null ? name2 : element), PyPsiBundle.message("INSP.unused.locals.type.alias.isnot.used", typeAlias.getName()), new LocalQuickFix[]{new PyRemoveStatementQuickFix()});
                continue;
            }
            if (element instanceof PyTypeParameter) {
                PyTypeParameter typeParameter = (PyTypeParameter)element;
                name2 = typeParameter.getNameIdentifier();
                this.registerWarning((PsiElement)(name2 != null ? name2 : element), PyPsiBundle.message("INSP.unused.locals.type.parameter.isnot.used", typeParameter.getName()), new LocalQuickFix[]{new PyRemoveStatementQuickFix()});
                continue;
            }
            if (element instanceof PsiNamedElement) {
                PsiNamedElement namedElement = (PsiNamedElement)element;
                v0 = StringUtil.notNullize((String)namedElement.getName());
            } else {
                v0 = name2 = element.getText();
            }
            if (element instanceof PyNamedParameter || element.getParent() instanceof PyNamedParameter) {
                PsiElement psiElement;
                PyNamedParameter namedParameter = element instanceof PyNamedParameter ? (PyNamedParameter)element : (PyNamedParameter)element.getParent();
                name2 = namedParameter.getName();
                if (namedParameter.isSelf() || this.myIgnoreLambdaParameters && PsiTreeUtil.getParentOfType((PsiElement)element, PyCallable.class) instanceof PyLambdaExpression) continue;
                boolean mayBeField = false;
                PyClass containingClass = null;
                PyParameterList paramList = (PyParameterList)PsiTreeUtil.getParentOfType((PsiElement)element, PyParameterList.class);
                if (paramList != null && (psiElement = paramList.getParent()) instanceof PyFunction) {
                    PyFunction func = (PyFunction)psiElement;
                    containingClass = func.getContainingClass();
                    if (containingClass != null && PyUtil.isInitMethod(func) && !namedParameter.isKeywordContainer() && !namedParameter.isPositionalContainer()) {
                        mayBeField = true;
                    } else if (this.ignoreUnusedParameters(func, functionsWithInheritors)) continue;
                    if (func.asMethod() != null) {
                        Boolean isEmpty = (Boolean)emptyFunctions.get(func);
                        if (isEmpty == null) {
                            isEmpty = PyUtil.isEmptyFunction(func);
                            emptyFunctions.put(func, isEmpty);
                        }
                        if (isEmpty.booleanValue() && !mayBeField) continue;
                    }
                }
                boolean canRemove = !(PsiTreeUtil.getPrevSiblingOfType((PsiElement)element, PyParameter.class) instanceof PySingleStarParameter) || PsiTreeUtil.getNextSiblingOfType((PsiElement)element, PyParameter.class) != null;
                ArrayList<Object> fixes = new ArrayList<Object>();
                if (mayBeField) {
                    fixes.add(new AddFieldQuickFix((String)name2, (String)name2, containingClass.getName(), false));
                }
                if (canRemove) {
                    fixes.add(new PyRemoveParameterQuickFix());
                }
                this.registerWarning(element, PyPsiBundle.message("INSP.unused.locals.parameter.isnot.used", name2), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                continue;
            }
            if (this.myIgnoreVariablesStartingWithUnderscore && element.getText().startsWith("_") || this.myIgnoreTupleUnpacking && PyUnusedLocalInspectionVisitor.isTupleUnpacking(element, unusedElements)) continue;
            String warningMsg = PyPsiBundle.message("INSP.unused.locals.local.variable.isnot.used", name2);
            PyForStatement forStatement = PyForStatementNavigator.getPyForStatementByIterable(element);
            if (forStatement != null) {
                if (this.myIgnoreRangeIterationVariables && this.isRangeIteration(forStatement)) continue;
                this.registerWarning(element, warningMsg, new LocalQuickFix[]{new ReplaceWithWildCard()});
                continue;
            }
            if (PyUnusedLocalInspectionVisitor.isComprehensionTarget(element)) {
                this.registerWarning(element, warningMsg, new LocalQuickFix[]{new ReplaceWithWildCard()});
                continue;
            }
            PyExceptPart exceptPart = PyExceptPartNavigator.getPyExceptPartByTarget(element);
            if (exceptPart != null) {
                this.registerWarning(element, warningMsg, new LocalQuickFix[]{new PyRemoveExceptionTargetQuickFix()});
                continue;
            }
            PyWithItem withItem = (PyWithItem)PsiTreeUtil.getParentOfType((PsiElement)element, PyWithItem.class);
            if (withItem != null && PsiTreeUtil.isAncestor((PsiElement)withItem.getTarget(), (PsiElement)element, (boolean)false)) {
                if (withItem.getTarget() == element) {
                    this.registerWarning(element, warningMsg, new LocalQuickFix[]{new PyRemoveWithTargetQuickFix()});
                    continue;
                }
                this.registerWarning(element, warningMsg, new LocalQuickFix[]{new ReplaceWithWildCard()});
                continue;
            }
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyAssignmentStatement.class);
            if (assignmentStatement != null && !PsiTreeUtil.isAncestor((PsiElement)assignmentStatement.getAssignedValue(), (PsiElement)element, (boolean)false)) {
                if (assignmentStatement.getLeftHandSideExpression() == element) {
                    this.registerWarning(element, warningMsg, new LocalQuickFix[]{new PyRemoveAssignmentStatementTargetQuickFix(), new PyRemoveStatementQuickFix()});
                    continue;
                }
                if (ArrayUtil.contains((Object)element, (Object[])assignmentStatement.getRawTargets())) {
                    this.registerWarning(element, warningMsg, new LocalQuickFix[]{new PyRemoveAssignmentStatementTargetQuickFix()});
                    continue;
                }
                this.registerWarning(element, warningMsg, new LocalQuickFix[]{new ReplaceWithWildCard()});
                continue;
            }
            this.registerWarning(element, warningMsg, new LocalQuickFix[0]);
        }
    }

    @NotNull
    private Set<PsiElement> getReadsInsideScope(@NotNull ScopeOwner scopeOwner) {
        if (scopeOwner == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(15);
        }
        Set set = ((StreamEx)StreamEx.of(this.myScopeReads.entrySet()).filter(readEntry -> PsiTreeUtil.isAncestor((PsiElement)scopeOwner, (PsiElement)((PsiElement)readEntry.getKey()), (boolean)false))).flatCollection(readEntry -> (Collection)readEntry.getValue()).toImmutableSet();
        if (set == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(16);
        }
        return set;
    }

    private static boolean isComprehensionTarget(@NotNull PsiElement element) {
        PyComprehensionElement comprehensionExpr;
        if (element == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(17);
        }
        if ((comprehensionExpr = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)element, PyComprehensionElement.class)) == null) {
            return false;
        }
        return ContainerUtil.exists((Iterable)comprehensionExpr.getForComponents(), it -> PsiTreeUtil.isAncestor((PsiElement)it.getIteratorVariable(), (PsiElement)element, (boolean)false));
    }

    private boolean isRangeIteration(@NotNull PyForStatement forStatement) {
        PyExpression source;
        if (forStatement == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(18);
        }
        if (!((source = forStatement.getForPart().getSource()) instanceof PyCallExpression)) {
            return false;
        }
        PyCallExpression expr = (PyCallExpression)source;
        if (expr.isCalleeText(new String[]{"range", "xrange"})) {
            PyResolveContext resolveContext = PyResolveContext.defaultContext(this.myTypeEvalContext);
            PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(forStatement);
            return ContainerUtil.exists(expr.multiResolveCalleeFunction(resolveContext), builtinCache::isBuiltin);
        }
        return false;
    }

    private boolean ignoreUnusedParameters(PyFunction func, Set<PyFunction> functionsWithInheritors) {
        if (functionsWithInheritors.contains(func)) {
            return true;
        }
        if (!PyUtil.isInitMethod(func) && PySuperMethodsSearch.search(func, this.myTypeEvalContext).findFirst() != null || PyOverridingMethodsSearch.search(func, true).findFirst() != null) {
            functionsWithInheritors.add(func);
            return true;
        }
        return false;
    }

    private static boolean isTupleUnpacking(PsiElement element, Set<PsiElement> unusedElements) {
        if (!(element instanceof PyTargetExpression)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PyStarExpression) {
            element = parent;
            parent = element.getParent();
        }
        if (parent instanceof PyTupleExpression) {
            PyTupleExpression tuple = (PyTupleExpression)parent;
            for (PyExpression expression : tuple.getElements()) {
                if (!(expression instanceof PyStarExpression ? !unusedElements.contains(((PyStarExpression)expression).getExpression()) : !unusedElements.contains(expression))) continue;
                return true;
            }
        }
        return false;
    }

    private void registerWarning(@NotNull PsiElement element, @InspectionMessage String msg, LocalQuickFix ... quickfixes) {
        if (element == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(19);
        }
        if (quickfixes == null) {
            PyUnusedLocalInspectionVisitor.$$$reportNull$$$0(20);
        }
        this.registerProblem(element, msg, ProblemHighlightType.LIKE_UNUSED_SYMBOL, null, quickfixes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docstring";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/unusedLocal/PyUnusedLocalInspectionVisitor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeOwner";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickfixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/unusedLocal/PyUnusedLocalInspectionVisitor";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeReadsInDoctests";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeReadsInScope";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadsInsideScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitPyElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parameterInMethodWithFixedSignature";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "analyzeReadsInDoctests";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "analyzeReadsInScope";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getReadsInsideScope";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isComprehensionTarget";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isRangeIteration";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "registerWarning";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10, 14, 16 -> new IllegalStateException(string);
        };
    }

    static class DontPerformException
    extends RuntimeException {
        DontPerformException() {
        }
    }

    private static class ReplaceWithWildCard
    extends PsiUpdateModCommandQuickFix {
        private ReplaceWithWildCard() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PyPsiBundle.message("INSP.unused.locals.replace.with.wildcard", new Object[0]);
            if (string == null) {
                ReplaceWithWildCard.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PyFile pyFile;
            PyExpression target;
            if (project == null) {
                ReplaceWithWildCard.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplaceWithWildCard.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplaceWithWildCard.$$$reportNull$$$0(3);
            }
            if ((target = ((PyForStatement)(pyFile = (PyFile)PyElementGenerator.getInstance(element.getProject()).createDummyFile(LanguageLevel.getDefault(), "for _ in tuples:\n  pass")).getStatements().get(0)).getForPart().getTarget()) != null) {
                element.replace((PsiElement)target);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/unusedLocal/PyUnusedLocalInspectionVisitor$ReplaceWithWildCard";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/unusedLocal/PyUnusedLocalInspectionVisitor$ReplaceWithWildCard";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

