/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console.evaluation;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.evaluation.DatabaseExpressionEvaluator;
import com.intellij.database.console.evaluation.EvaluationResultFetcher;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.DbObjectFormatter;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.Out;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import icons.DatabaseIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.images.editor.impl.ImageEditorManagerImpl;
import org.intellij.images.editor.impl.ImageEditorUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTableResult
implements DatabaseExpressionEvaluator.Result {
    private static final int MAX = 120;
    final ObjectFormatter myFormatter;
    final EvaluationResultFetcher myFetcher;
    final Dbms myDbms;
    private MyRootNodeUpdater myUpdater;
    private int myLastShown;
    EvaluationColumnsPresentation myPresentation;

    private AbstractTableResult(@NotNull Dbms dbms, @NotNull EvaluationResultFetcher fetcher) {
        if (dbms == null) {
            AbstractTableResult.$$$reportNull$$$0(0);
        }
        if (fetcher == null) {
            AbstractTableResult.$$$reportNull$$$0(1);
        }
        this.myDbms = dbms;
        this.myFetcher = fetcher;
        this.myFormatter = new DbObjectFormatter(dbms);
    }

    void init() {
        this.myPresentation = this.createColumnsPresentation();
        this.myUpdater = this.createRootNodeUpdater();
    }

    @Override
    @NotNull
    public String representation() {
        this.myFetcher.fetchCached();
        StringBuilder sb = new StringBuilder();
        List<? extends GridColumn> columns = this.myFetcher.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            GridColumn column2 = columns.get(i);
            sb.append(column2.getName()).append(i < columns.size() - 1 ? "\t" : "");
        }
        sb.append("\n");
        List<? extends GridRow> rows = this.myFetcher.getRows();
        for (GridRow gridRow : rows) {
            for (int i = 0; i < columns.size(); ++i) {
                GridColumn column3 = columns.get(i);
                sb.append(AbstractTableResult.notNullValue(this.myFormatter, column3, this.myDbms, column3.getValue(gridRow), false)).append(i < columns.size() - 1 ? "\t" : "");
            }
            sb.append("\n");
        }
        String string = sb.toString();
        if (string == null) {
            AbstractTableResult.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            AbstractTableResult.$$$reportNull$$$0(3);
        }
        if (place == null) {
            AbstractTableResult.$$$reportNull$$$0(4);
        }
        this.myUpdater.update((Obsolescent)node, place, this.getResultName(), this.getResultSeparator());
    }

    @Override
    public void computeChildren(@NotNull XCompositeNode node) {
        XValueChildrenList columns;
        if (node == null) {
            AbstractTableResult.$$$reportNull$$$0(5);
        }
        if ((columns = this.columns()).size() != 0) {
            node.addChildren(columns, false);
        }
        String name2 = this.getResultName();
        String separator = this.getResultSeparator();
        if (this.myFetcher.isBusy()) {
            this.myUpdater.update((Obsolescent)node, XValuePlace.TREE, name2, separator);
            return;
        }
        this.myFetcher.fetch(() -> {
            node.addChildren(this.rows(), true);
            this.myUpdater.update((Obsolescent)node, XValuePlace.TREE, name2, separator);
        });
    }

    @NotNull
    protected abstract String getResultSeparator();

    @NotNull
    protected abstract String getResultName();

    @NotNull
    EvaluationColumnsPresentation createColumnsPresentation() {
        return new EvaluationColumnsPresentation(this.myDbms);
    }

    @NotNull
    MyRootNodeUpdater createRootNodeUpdater() {
        return new MyRootNodeUpdater(this.myFetcher, this.myPresentation, this.myFormatter, this.myDbms);
    }

    @NotNull
    private XValueChildrenList rows() {
        XValueChildrenList list = new XValueChildrenList();
        List<? extends GridRow> rows = this.myFetcher.getRows();
        for (int i = this.myLastShown; i < rows.size(); ++i) {
            final GridRow row = rows.get(i);
            list.add(new XNamedValue(String.valueOf(i + 1)){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (place == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    Function converter = c2 -> AbstractTableResult.cut(AbstractTableResult.notNullValue(AbstractTableResult.this.myFormatter, c2, AbstractTableResult.this.myDbms, c2.getValue(row), true));
                    String type = StringUtil.join(AbstractTableResult.this.myFetcher.getColumns(), (Function)converter, (String)", ");
                    node.setPresentation(null, (XValuePresentation)new XRegularValuePresentation("", AbstractTableResult.cut(type), " "), AbstractTableResult.this.hasChildren());
                }

                public void computeChildren(@NotNull XCompositeNode node) {
                    if (node == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    node.addChildren(AbstractTableResult.this.rowValuesList(row), true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "place";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "computePresentation";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "computeChildren";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        this.myLastShown = rows.size();
        XValueChildrenList xValueChildrenList = list;
        if (xValueChildrenList == null) {
            AbstractTableResult.$$$reportNull$$$0(6);
        }
        return xValueChildrenList;
    }

    private boolean hasChildren() {
        return !this.myFetcher.getColumns().isEmpty();
    }

    @NotNull
    private XValueChildrenList rowValuesList(@NotNull GridRow row) {
        if (row == null) {
            AbstractTableResult.$$$reportNull$$$0(7);
        }
        XValueChildrenList rowChildren = new XValueChildrenList();
        for (final GridColumn gridColumn : this.myFetcher.getColumns()) {
            final Object value = gridColumn.getValue(row);
            final String originalValue = AbstractTableResult.notNullValue(this.myFormatter, gridColumn, this.myDbms, value, true);
            final String stringValue = AbstractTableResult.cut(originalValue);
            rowChildren.add(new XNamedValue(gridColumn.getName()){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (place == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    node.setPresentation(null, (XValuePresentation)new XRegularValuePresentation(stringValue, AbstractTableResult.this.myPresentation.compute((GridColumn)gridColumn).typeName), false);
                    if (!AbstractTableResult.this.setImageEvaluator(node, value) && stringValue.length() < originalValue.length()) {
                        node.setFullValueEvaluator(new XFullValueEvaluator(){

                            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                                if (callback == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                callback.evaluated(AbstractTableResult.notNullValue(AbstractTableResult.this.myFormatter, gridColumn, AbstractTableResult.this.myDbms, value, true, (ObjectFormatterConfig)new DatabaseObjectFormatterConfig(ObjectFormatterMode.SQL_SCRIPT)));
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$2$1", "startEvaluation"));
                            }
                        });
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "node";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "place";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/console/evaluation/AbstractTableResult$2";
                    objectArray[2] = "computePresentation";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        XValueChildrenList xValueChildrenList = rowChildren;
        if (xValueChildrenList == null) {
            AbstractTableResult.$$$reportNull$$$0(8);
        }
        return xValueChildrenList;
    }

    @NotNull
    private XValueChildrenList columns() {
        XValueChildrenList list = new XValueChildrenList();
        if (this.myFetcher.getRows().isEmpty()) {
            list.add(new XNamedValue("columns"){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (place == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    String columns = StringUtil.join(AbstractTableResult.this.myFetcher.getColumns(), ColumnDescriptor::getName, (String)", ");
                    node.setPresentation(null, (XValuePresentation)new XRegularValuePresentation("", columns, " "), AbstractTableResult.this.hasChildren());
                }

                public void computeChildren(@NotNull XCompositeNode node) {
                    if (node == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    node.addChildren(AbstractTableResult.this.columnsList(), true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "node";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "place";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "computePresentation";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "computeChildren";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        XValueChildrenList xValueChildrenList = list;
        if (xValueChildrenList == null) {
            AbstractTableResult.$$$reportNull$$$0(9);
        }
        return xValueChildrenList;
    }

    @NotNull
    private XValueChildrenList columnsList() {
        XValueChildrenList list = new XValueChildrenList();
        for (final GridColumn gridColumn : this.myFetcher.getColumns()) {
            list.add(new XNamedValue(gridColumn.getName()){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    if (node == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (place == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    XRegularValuePresentation presentation = new XRegularValuePresentation("", AbstractTableResult.this.myPresentation.compute((GridColumn)gridColumn).typeName, " ");
                    node.setPresentation(AbstractTableResult.this.myPresentation.compute((GridColumn)gridColumn).icon, (XValuePresentation)presentation, false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "node";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "place";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/console/evaluation/AbstractTableResult$4";
                    objectArray[2] = "computePresentation";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        XValueChildrenList xValueChildrenList = list;
        if (xValueChildrenList == null) {
            AbstractTableResult.$$$reportNull$$$0(10);
        }
        return xValueChildrenList;
    }

    private boolean setImageEvaluator(@NotNull XValueNode node, @Nullable Object value) {
        if (node == null) {
            AbstractTableResult.$$$reportNull$$$0(11);
        }
        if (!(value instanceof ImageInfo)) {
            return false;
        }
        ImageInfo info2 = (ImageInfo)value;
        final BufferedImage image = info2.createImage();
        if (image == null) {
            return false;
        }
        XFullValueEvaluator evaluator = new XFullValueEvaluator(){

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    5.$$$reportNull$$$0(0);
                }
                DbUIUtil.invokeLaterIfNeeded(() -> {
                    if (callback.isObsolete()) {
                        return;
                    }
                    ImageEditorUI ui = ImageEditorManagerImpl.createImageEditorUI((BufferedImage)image);
                    JBPopup popup2 = DebuggerUIUtil.createValuePopup((Project)AbstractTableResult.this.myFetcher.getProject(), (JComponent)ui, null);
                    JFrame frame = Objects.requireNonNull(WindowManager.getInstance().getFrame(AbstractTableResult.this.myFetcher.getProject()));
                    Dimension frameSize = frame.getSize();
                    Dimension size = new Dimension(frameSize.width / 2, frameSize.height / 2);
                    popup2.setSize(size);
                    callback.evaluated("");
                    popup2.show(new RelativePoint((Component)frame, new Point(size.width / 2, size.height / 2)));
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$5", "startEvaluation"));
            }
        };
        evaluator.setShowValuePopup(false);
        node.setFullValueEvaluator(evaluator);
        return true;
    }

    @NotNull
    public static String notNullValue(@NotNull ObjectFormatter formatter, @NotNull GridColumn column2, @NotNull Dbms dbms, @Nullable Object value, boolean quoteIfEmpty) {
        if (formatter == null) {
            AbstractTableResult.$$$reportNull$$$0(12);
        }
        if (column2 == null) {
            AbstractTableResult.$$$reportNull$$$0(13);
        }
        if (dbms == null) {
            AbstractTableResult.$$$reportNull$$$0(14);
        }
        return AbstractTableResult.notNullValue(formatter, column2, dbms, value, quoteIfEmpty, (ObjectFormatterConfig)new DatabaseObjectFormatterConfig.DatabaseDisplayObjectFormatterConfig());
    }

    @NotNull
    public static String notNullValue(@NotNull ObjectFormatter formatter, @NotNull GridColumn column2, @NotNull Dbms dbms, @Nullable Object value, boolean quoteIfEmpty, ObjectFormatterConfig config) {
        if (formatter == null) {
            AbstractTableResult.$$$reportNull$$$0(15);
        }
        if (column2 == null) {
            AbstractTableResult.$$$reportNull$$$0(16);
        }
        if (dbms == null) {
            AbstractTableResult.$$$reportNull$$$0(17);
        }
        String result = StringUtil.notNullize((String)formatter.objectToString(value, column2, config), (String)"null");
        String string = quoteIfEmpty && StringUtil.isEmptyOrSpaces((String)result) ? StringUtil.wrapWithDoubleQuote((String)result) : result;
        if (string == null) {
            AbstractTableResult.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String cut(@NotNull String s) {
        if (s == null) {
            AbstractTableResult.$$$reportNull$$$0(19);
        }
        String string = StringUtil.shortenTextWithEllipsis((String)s, (int)120, (int)0);
        if (string == null) {
            AbstractTableResult.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 8, 9, 10, 18, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fetcher";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult";
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "representation";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "rows";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "rowValuesList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "columns";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "columnsList";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullValue";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "cut";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 20: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "rowValuesList";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setImageEvaluator";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "notNullValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "cut";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 8, 9, 10, 18, 20 -> new IllegalStateException(string);
        };
    }

    private static class EvaluationColumnsPresentation {
        private final Map<GridColumn, Presentation> myMap;
        private final Dbms myDbms;

        EvaluationColumnsPresentation(@NotNull Dbms dbms) {
            if (dbms == null) {
                EvaluationColumnsPresentation.$$$reportNull$$$0(0);
            }
            this.myDbms = dbms;
            this.myMap = new HashMap<GridColumn, Presentation>();
        }

        @NotNull
        final Presentation compute(@NotNull GridColumn column2) {
            if (column2 == null) {
                EvaluationColumnsPresentation.$$$reportNull$$$0(1);
            }
            Presentation presentation = this.myMap.computeIfAbsent(column2, c2 -> this.computeInner((GridColumn)c2));
            if (presentation == null) {
                EvaluationColumnsPresentation.$$$reportNull$$$0(2);
            }
            return presentation;
        }

        @NotNull
        Presentation computeInner(@NotNull GridColumn column2) {
            Domain domain;
            if (column2 == null) {
                EvaluationColumnsPresentation.$$$reportNull$$$0(3);
            }
            String typeName = (domain = BaseDomainRegistry.getDomain((Dbms)this.myDbms, null, (ColumnDescriptor)column2, (boolean)false)) == null ? column2.getTypeName() : domain.name();
            return new Presentation(DatabaseIcons.Col, StringUtil.notNullize((String)typeName));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "compute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "computeInner";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }

        private static class Presentation {
            public final Icon icon;
            public final String typeName;

            Presentation(@NotNull Icon icon, @NotNull String typeName) {
                if (icon == null) {
                    Presentation.$$$reportNull$$$0(0);
                }
                if (typeName == null) {
                    Presentation.$$$reportNull$$$0(1);
                }
                this.icon = icon;
                this.typeName = typeName;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "icon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "typeName";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation$Presentation";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class DasPresentation
        extends EvaluationColumnsPresentation {
            private final DasTable myTable;

            DasPresentation(@NotNull Dbms dbms, @NotNull DasTable table) {
                if (dbms == null) {
                    DasPresentation.$$$reportNull$$$0(0);
                }
                if (table == null) {
                    DasPresentation.$$$reportNull$$$0(1);
                }
                super(dbms);
                this.myTable = table;
            }

            @Override
            @NotNull
            Presentation computeInner(@NotNull GridColumn column2) {
                if (column2 == null) {
                    DasPresentation.$$$reportNull$$$0(2);
                }
                JBIterable children2 = this.myTable.getDasChildren(ObjectKind.COLUMN).filter(DasColumn.class);
                for (DasColumn child : children2) {
                    if (!StringUtil.equals((CharSequence)child.getName(), (CharSequence)column2.getName())) continue;
                    return new Presentation((Icon)ObjectUtils.notNull((Object)DbPresentationCore.getIcon((DasObject)child), (Object)DatabaseIcons.Col), child.getDasType().getSpecification());
                }
                Presentation presentation = super.computeInner(column2);
                if (presentation == null) {
                    DasPresentation.$$$reportNull$$$0(3);
                }
                return presentation;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dbms";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "table";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "column";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation$DasPresentation";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$EvaluationColumnsPresentation$DasPresentation";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "computeInner";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "computeInner";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        }
    }

    private static class MyRootNodeUpdater {
        private final EvaluationResultFetcher myFetcher;
        private final EvaluationColumnsPresentation myPresentation;
        private final ObjectFormatter myFormatter;
        private final Dbms myDbms;

        private MyRootNodeUpdater(@NotNull EvaluationResultFetcher fetcher, @NotNull EvaluationColumnsPresentation presentation, @NotNull ObjectFormatter formatter, @NotNull Dbms dbms) {
            if (fetcher == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(0);
            }
            if (presentation == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(1);
            }
            if (formatter == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(2);
            }
            if (dbms == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(3);
            }
            this.myFetcher = fetcher;
            this.myPresentation = presentation;
            this.myFormatter = formatter;
            this.myDbms = dbms;
        }

        @NotNull
        public XRegularValuePresentation createRegularPresentation(@NotNull String name2, @NotNull String separator) {
            if (name2 == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(4);
            }
            if (separator == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(5);
            }
            return this.myFetcher.isRowCountPrecise() ? new MyPresentation(name2, separator, this.myFetcher.getRowCount()) : new XRegularValuePresentation(name2, null, separator);
        }

        void update(@NotNull Obsolescent node, @NotNull XValuePlace place, @NotNull String name2, @NotNull String separator) {
            XValueNode n;
            if (node == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(6);
            }
            if (place == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(7);
            }
            if (name2 == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(8);
            }
            if (separator == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(9);
            }
            if (this.isSingleValue()) {
                this.updateSingleValue((XValueNode)node);
                return;
            }
            if (node instanceof XValueNode) {
                n = (XValueNode)node;
                this.updateEvaluator(n, place, name2, separator);
                this.updatePresentation(n, place, name2, separator);
            }
            if (!this.isTree(place) || !this.myFetcher.canFetch()) {
                return;
            }
            if (node instanceof XCompositeNode) {
                n = (XCompositeNode)node;
                n.tooManyChildren(this.myFetcher.isRowCountPrecise() && this.myFetcher.getRowCount() <= Integer.MAX_VALUE ? (int)this.myFetcher.getRowCount() - this.myFetcher.getRows().size() : -1);
            }
        }

        boolean isSingleValue() {
            return this.myFetcher.getColumns().size() == 1 && this.myFetcher.getRowCount() == 1L;
        }

        private void updateEvaluator(@NotNull XValueNode n, @NotNull XValuePlace place, @NotNull String name2, @NotNull String separator) {
            if (n == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(10);
            }
            if (place == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(11);
            }
            if (name2 == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(12);
            }
            if (separator == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(13);
            }
            if (!this.isTree(place) || this.myFetcher.isRowCountPrecise()) {
                return;
            }
            n.setFullValueEvaluator((XFullValueEvaluator)new MyCountEvaluator(n, name2, separator, this.myFetcher.getRowCount()));
        }

        private void updateSingleValue(@NotNull XValueNode node) {
            if (node == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(14);
            }
            this.myFetcher.fetchCached();
            final GridColumn column2 = Objects.requireNonNull((GridColumn)ContainerUtil.getFirstItem(this.myFetcher.getColumns()));
            GridRow row = Objects.requireNonNull((GridRow)ContainerUtil.getFirstItem(this.myFetcher.getRows()));
            final Object value = column2.getValue(row);
            String representation = AbstractTableResult.notNullValue(this.myFormatter, column2, this.myDbms, value, true);
            String stringValue = AbstractTableResult.cut(representation);
            if (representation.length() > stringValue.length()) {
                node.setFullValueEvaluator(new XFullValueEvaluator(){

                    public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                        if (callback == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        callback.evaluated(AbstractTableResult.notNullValue(myFormatter, column2, myDbms, value, true, (ObjectFormatterConfig)new DatabaseObjectFormatterConfig(ObjectFormatterMode.SQL_SCRIPT)));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater$1", "startEvaluation"));
                    }
                });
            }
            node.setPresentation(null, this.myPresentation.compute((GridColumn)column2).typeName, stringValue, false);
        }

        private boolean isTree(@NotNull XValuePlace place) {
            if (place == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(15);
            }
            return this.myFetcher.getRowCount() == 0L || this.myFetcher.getColumns().isEmpty() || place == XValuePlace.TREE;
        }

        private void updatePresentation(@NotNull XValueNode node, @NotNull XValuePlace place, @NotNull String name2, @NotNull String separator) {
            boolean tree;
            if (node == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(16);
            }
            if (place == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(17);
            }
            if (name2 == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(18);
            }
            if (separator == null) {
                MyRootNodeUpdater.$$$reportNull$$$0(19);
            }
            TablePresentation presentation = (tree = this.isTree(place)) ? this.createRegularPresentation(name2, separator) : new TablePresentation(this.myDbms, this.myFetcher, this.myPresentation);
            node.setPresentation(DatabaseIcons.Table, (XValuePresentation)presentation, tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fetcher";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatter";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 4: 
                case 8: 
                case 12: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 5: 
                case 9: 
                case 13: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separator";
                    break;
                }
                case 6: 
                case 14: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 7: 
                case 11: 
                case 15: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "n";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRegularPresentation";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateEvaluator";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateSingleValue";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isTree";
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private final class MyCountEvaluator
        extends XFullValueEvaluator {
            private final XValueNode myNode;
            private final String myName;
            private final String mySeparator;

            private MyCountEvaluator(@NotNull XValueNode node, @NotNull String name2, String separator, long rows) {
                if (node == null) {
                    MyCountEvaluator.$$$reportNull$$$0(0);
                }
                if (name2 == null) {
                    MyCountEvaluator.$$$reportNull$$$0(1);
                }
                if (separator == null) {
                    MyCountEvaluator.$$$reportNull$$$0(2);
                }
                super(DatabaseBundle.message((String)"table.count.rows.plus.text", (Object[])new Object[]{rows}));
                this.myNode = node;
                this.myName = name2;
                this.mySeparator = separator;
                this.setShowValuePopup(false);
            }

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                if (callback == null) {
                    MyCountEvaluator.$$$reportNull$$$0(3);
                }
                MyRootNodeUpdater.this.myFetcher.count(() -> {
                    if (callback.isObsolete()) {
                        return;
                    }
                    MyRootNodeUpdater.this.update((Obsolescent)this.myNode, XValuePlace.TREE, this.myName, this.mySeparator);
                    this.myNode.setFullValueEvaluator(new XFullValueEvaluator(""){

                        public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                            if (callback == null) {
                                1.$$$reportNull$$$0(0);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater$MyCountEvaluator$1", "startEvaluation"));
                        }
                    });
                    callback.evaluated("");
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "separator";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callback";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$MyRootNodeUpdater$MyCountEvaluator";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startEvaluation";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class MyPresentation
    extends XRegularValuePresentation {
        private final long myRowCount;

        MyPresentation(@NotNull String name2, @NotNull String separator, long count) {
            if (name2 == null) {
                MyPresentation.$$$reportNull$$$0(0);
            }
            if (separator == null) {
                MyPresentation.$$$reportNull$$$0(1);
            }
            super(name2, null, separator);
            this.myRowCount = count;
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer2) {
            if (renderer2 == null) {
                MyPresentation.$$$reportNull$$$0(2);
            }
            super.renderValue(renderer2);
            renderer2.renderComment(DatabaseBundle.message((String)"table.count.rows.text", (Object[])new Object[]{this.myRowCount}));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "separator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$MyPresentation";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DasTableResult
    extends AbstractTableResult {
        private final DasTable myTable;

        public DasTableResult(@NotNull Dbms dbms, @NotNull EvaluationResultFetcher support, @NotNull DasTable table) {
            if (dbms == null) {
                DasTableResult.$$$reportNull$$$0(0);
            }
            if (support == null) {
                DasTableResult.$$$reportNull$$$0(1);
            }
            if (table == null) {
                DasTableResult.$$$reportNull$$$0(2);
            }
            super(dbms, support);
            this.myTable = table;
            this.init();
        }

        @Override
        @NotNull
        protected String getResultName() {
            String string = this.myTable.getName();
            if (string == null) {
                DasTableResult.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getResultSeparator() {
            return " = ";
        }

        @Override
        @NotNull
        EvaluationColumnsPresentation createColumnsPresentation() {
            return new EvaluationColumnsPresentation.DasPresentation(this.myDbms, this.myTable);
        }

        @Override
        @NotNull
        MyRootNodeUpdater createRootNodeUpdater() {
            return new MyRootNodeUpdater(this.myFetcher, this.myPresentation, this.myFormatter, this.myDbms){

                @Override
                boolean isSingleValue() {
                    return false;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult$DasTableResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$DasTableResult";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResultName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class TableResult
    extends AbstractTableResult {
        public TableResult(@NotNull Dbms dbms, @NotNull EvaluationResultFetcher support) {
            if (dbms == null) {
                TableResult.$$$reportNull$$$0(0);
            }
            if (support == null) {
                TableResult.$$$reportNull$$$0(1);
            }
            super(dbms, support);
            this.init();
        }

        @Override
        @NotNull
        public String representation() {
            if (this.myFetcher.getRowCount() != 1L || this.myFetcher.getColumns().size() != 1) {
                String string = super.representation();
                if (string == null) {
                    TableResult.$$$reportNull$$$0(2);
                }
                return string;
            }
            this.myFetcher.fetchCached();
            GridColumn column2 = Objects.requireNonNull((GridColumn)ContainerUtil.getFirstItem(this.myFetcher.getColumns()));
            GridRow row = Objects.requireNonNull((GridRow)ContainerUtil.getFirstItem(this.myFetcher.getRows()));
            String string = TableResult.notNullValue(this.myFormatter, column2, this.myDbms, column2.getValue(row), true);
            if (string == null) {
                TableResult.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getResultSeparator() {
            return "";
        }

        @Override
        @NotNull
        protected String getResultName() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult$TableResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$TableResult";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "representation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    public static class TablePresentation
    extends XValuePresentation {
        private final Dbms myDbms;
        private final EvaluationResultFetcher myFetcher;
        private final ObjectFormatter myFormatter;
        private final EvaluationColumnsPresentation myPresentation;

        TablePresentation(@NotNull Dbms dbms, @NotNull EvaluationResultFetcher support, @NotNull EvaluationColumnsPresentation presentation) {
            if (dbms == null) {
                TablePresentation.$$$reportNull$$$0(0);
            }
            if (support == null) {
                TablePresentation.$$$reportNull$$$0(1);
            }
            if (presentation == null) {
                TablePresentation.$$$reportNull$$$0(2);
            }
            this.myPresentation = presentation;
            this.myFormatter = new DbObjectFormatter(dbms){

                public String objectToString(@Nullable Object o, GridColumn column2, @NotNull ObjectFormatterConfig config) {
                    if (config == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    String unescaped = AbstractTableResult.cut(StringUtil.notNullize((String)super.objectToString(o, column2, DatabaseObjectFormatterConfig.toDisplayConfig((ObjectFormatterConfig)config)), (String)"null"));
                    return HtmlValuesExtractor.escapeChars((String)unescaped);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$1", "objectToString"));
                }
            };
            this.myDbms = dbms;
            this.myFetcher = support;
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer2) {
            if (renderer2 == null) {
                TablePresentation.$$$reportNull$$$0(3);
            }
            renderer2.renderValue(this.getText());
        }

        @NotNull
        public JComponent presentationComponent(@NotNull Editor editor2) {
            if (editor2 == null) {
                TablePresentation.$$$reportNull$$$0(4);
            }
            Ref consumerRef = Ref.create();
            Ref scrollPaneRef = Ref.create();
            this.myFetcher.fetchCached();
            MyHyperlinkListener listener2 = new MyHyperlinkListener((Ref<? extends JScrollPane>)scrollPaneRef, (Ref<? extends Consumer<? super String>>)consumerRef);
            JComponent label = HintUtil.createInformationLabel((String)this.getText(), (HyperlinkListener)listener2, null, (Ref)consumerRef);
            Dimension preferredSize = label.getPreferredSize();
            JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)label, (boolean)true);
            Dimension cropped = TablePresentation.cropToFitScreen(editor2, pane, preferredSize);
            if (!cropped.equals(preferredSize)) {
                pane.setPreferredSize(cropped);
            }
            scrollPaneRef.set((Object)pane);
            JComponent jComponent = (JComponent)scrollPaneRef.get();
            if (jComponent == null) {
                TablePresentation.$$$reportNull$$$0(5);
            }
            return jComponent;
        }

        @NotNull
        private static Dimension cropToFitScreen(@NotNull Editor editor2, @NotNull JScrollPane pane, @NotNull Dimension preferredSize) {
            if (editor2 == null) {
                TablePresentation.$$$reportNull$$$0(6);
            }
            if (pane == null) {
                TablePresentation.$$$reportNull$$$0(7);
            }
            if (preferredSize == null) {
                TablePresentation.$$$reportNull$$$0(8);
            }
            Rectangle screenRect = ScreenUtil.getScreenRectangle((Component)editor2.getComponent());
            int width = Math.min(preferredSize.width, (int)((double)screenRect.width * 0.9));
            int height = Math.min(preferredSize.height, (int)((double)screenRect.height * 0.9));
            boolean widthChanged = width < preferredSize.width;
            JScrollBar bar = pane.getHorizontalScrollBar();
            int hsbHeight = bar == null || !widthChanged || SystemInfo.isMac ? 0 : bar.getPreferredSize().height;
            return new Dimension(width, height + hsbHeight);
        }

        @NlsContexts.HintText
        @NotNull
        private String getText() {
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(HintUtil.getInformationColor(), this.myFormatter, 99){

                @Override
                @NotNull
                protected String getName(@NotNull GridColumn column2) {
                    if (column2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    String string = super.getName(column2) + ": " + myPresentation.compute((GridColumn)column2).typeName;
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "column";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getName";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getName";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            };
            HtmlBuilder builder = new HtmlBuilder();
            builder.append(this.getHeader());
            builder.appendRaw(this.extractColumns(extractor));
            if (this.myFetcher.canFetch()) {
                builder.append((HtmlChunk)HtmlChunk.div((String)"margin-top: 3px;margin-bottom: 2px;").child((HtmlChunk)HtmlChunk.link((String)"more", (String)DatabaseBundle.message((String)"more.rows", (Object[])new Object[0]))));
            }
            String string = builder.wrapWithHtmlBody().toString();
            if (string == null) {
                TablePresentation.$$$reportNull$$$0(9);
            }
            return string;
        }

        @NotNull
        @NlsSafe
        private String extractColumns(DisplayHtmlValuesExtractor extractor) {
            List<? extends GridRow> rows = this.myFetcher.getRows();
            List<? extends GridColumn> columns = this.myFetcher.getColumns();
            Out.Readable out = new Out.Readable();
            int[] columnsToExtract = columns.stream().mapToInt(c2 -> c2.getColumnNumber()).toArray();
            GridExtractorsUtilCore.extract((Out)out, columns, (DataExtractor)extractor, rows, (int[])columnsToExtract);
            String string = out.getString();
            if (string == null) {
                TablePresentation.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        private HtmlChunk getHeader() {
            if (!this.myFetcher.canFetch() && this.myFetcher.getRows().size() <= this.myFetcher.getFetchSize()) {
                HtmlChunk htmlChunk = HtmlChunk.empty();
                if (htmlChunk == null) {
                    TablePresentation.$$$reportNull$$$0(11);
                }
                return htmlChunk;
            }
            long rowsCount = this.myFetcher.getRowCount();
            Object count = this.myFetcher.isRowCountPrecise() ? HtmlChunk.text((String)String.valueOf(rowsCount)) : HtmlChunk.link((String)"count", (String)(rowsCount + "+"));
            HtmlChunk.Element element = HtmlChunk.div((String)"margin-bottom: 3px; margin-top: 2px").children(new HtmlChunk[]{HtmlChunk.text((String)DatabaseBundle.message((String)"row.counter.rows", (Object[])new Object[0])), count.bold()});
            if (element == null) {
                TablePresentation.$$$reportNull$$$0(12);
            }
            return element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 9, 10, 11, 12 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "support";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pane";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preferredSize";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "presentationComponent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extractColumns";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHeader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "renderValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "presentationComponent";
                    break;
                }
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "cropToFitScreen";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 9, 10, 11, 12 -> new IllegalStateException(string);
            };
        }

        private class MyHyperlinkListener
        implements HyperlinkListener {
            @NotNull
            private final Ref<? extends JScrollPane> myScrollPaneRef;
            private final Ref<? extends Consumer<? super String>> myConsumerRef;

            MyHyperlinkListener(@NotNull Ref<? extends JScrollPane> scrollPaneRef, Ref<? extends Consumer<? super String>> consumerRef) {
                if (scrollPaneRef == null) {
                    MyHyperlinkListener.$$$reportNull$$$0(0);
                }
                if (consumerRef == null) {
                    MyHyperlinkListener.$$$reportNull$$$0(1);
                }
                this.myScrollPaneRef = scrollPaneRef;
                this.myConsumerRef = consumerRef;
            }

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED || TablePresentation.this.myFetcher.isBusy()) {
                    return;
                }
                String link = e.getDescription();
                LinkRunner runner = LinkRunner.get(link);
                if (runner == null) {
                    return;
                }
                runner.run(TablePresentation.this.myFetcher, () -> {
                    JViewport viewport = ((JScrollPane)this.myScrollPaneRef.get()).getViewport();
                    Point position = viewport.getViewPosition();
                    ((Consumer)this.myConsumerRef.get()).consume((Object)TablePresentation.this.getText());
                    if (runner == LinkRunner.COUNT) {
                        DbUIUtil.invokeLater(() -> {
                            if (viewport.isShowing()) {
                                viewport.setViewPosition(position);
                            }
                        });
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scrollPaneRef";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "consumerRef";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$MyHyperlinkListener";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        private static enum LinkRunner {
            COUNT{

                @Override
                void run(@NotNull EvaluationResultFetcher fetcher, @NotNull Runnable callback) {
                    if (fetcher == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (callback == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    fetcher.count(callback);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "fetcher";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "callback";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$LinkRunner$1";
                    objectArray[2] = "run";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            ,
            MORE{

                @Override
                void run(@NotNull EvaluationResultFetcher fetcher, @NotNull Runnable callback) {
                    if (fetcher == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (callback == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    fetcher.fetch(callback);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "fetcher";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "callback";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$LinkRunner$2";
                    objectArray[2] = "run";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };


            abstract void run(@NotNull EvaluationResultFetcher var1, @NotNull Runnable var2);

            @Nullable
            static LinkRunner get(@NotNull String link) {
                if (link == null) {
                    LinkRunner.$$$reportNull$$$0(0);
                }
                for (LinkRunner runner : LinkRunner.values()) {
                    if (!StringUtil.equalsIgnoreCase((CharSequence)runner.name(), (CharSequence)link)) continue;
                    return runner;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "link", "com/intellij/database/console/evaluation/AbstractTableResult$TablePresentation$LinkRunner", "get"));
            }
        }
    }
}

