/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.cassandra.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.cassandra.model.CassDefType;
import com.intellij.database.dialects.cassandra.model.CassDefTypeAttribute;
import com.intellij.database.dialects.cassandra.model.CassFunction;
import com.intellij.database.dialects.cassandra.model.CassRole;
import com.intellij.database.dialects.cassandra.model.CassSchema;
import com.intellij.database.dialects.cassandra.model.defaults.CassSchemaPropertyKind;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModArgument;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.util.containers.JBIterable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J4\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00192\u0006\u0010\u001a\u001a\u00020\nH\u0016\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/cassandra/model/CassModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "<init>", "()V", "getCustomName", "", "Lorg/jetbrains/annotations/Nls;", "kind", "Lcom/intellij/database/model/ObjectKind;", "plural", "", "getVariant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "c", "Lcom/intellij/database/model/DasObject;", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "vars", "", "modifyParent", "intellij.database.dialects.cassandra"})
@SourceDebugExtension(value={"SMAP\nCassModelHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CassModelHelper.kt\ncom/intellij/database/dialects/cassandra/model/CassModelHelper\n+ 2 BooleanFun.kt\ncom/intellij/database/util/common/BooleanFun\n*L\n1#1,62:1\n18#2:63\n*S KotlinDebug\n*F\n+ 1 CassModelHelper.kt\ncom/intellij/database/dialects/cassandra/model/CassModelHelper\n*L\n23#1:63\n*E\n"})
public final class CassModelHelper
extends ModelHelper {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public String getCustomName(@NotNull ObjectKind kind, boolean plural) {
        String string;
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (Intrinsics.areEqual((Object)kind, (Object)ObjectKind.SCHEMA)) {
            int _true_$iv;
            void $this$choose$iv;
            Object[] objectArray = new Object[1];
            boolean bl = plural;
            int n = 2;
            int _false_$iv = 1;
            boolean $i$f$choose = false;
            objectArray[0] = $this$choose$iv != false ? _true_$iv : _false_$iv;
            string = DatabaseBundle.message((String)"CustomObjectKind.keyspace", (Object[])objectArray);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public ModelHelper.ObjectKindVariant getVariant(@NotNull DasObject c2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        if (c2 instanceof CassRole && ((CassRole)c2).isCanLogin()) {
            ModelHelper.ObjectKindVariant objectKindVariant = ModelHelper.USER;
            Intrinsics.checkNotNullExpressionValue((Object)objectKindVariant, (String)"USER");
            return objectKindVariant;
        }
        ModelHelper.ObjectKindVariant objectKindVariant = super.getVariant(c2);
        Intrinsics.checkNotNullExpressionValue((Object)objectKindVariant, (String)"getVariant(...)");
        return objectKindVariant;
    }

    @NotNull
    public JBIterable<ModelHelper.ObjectKindVariant> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable jBIterable;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        ObjectKind objectKind = meta.kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE)) {
            JBIterable jBIterable2 = JBIterable.of((Object)ModelHelper.FUNCTION);
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROLE)) {
            Object[] objectArray = new ModelHelper.ObjectKindVariant[]{ModelHelper.DEFAULT, ModelHelper.USER};
            JBIterable jBIterable3 = JBIterable.of((Object[])objectArray);
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"of(...)");
        } else {
            JBIterable jBIterable4 = super.generationVariants(meta);
            jBIterable = jBIterable4;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"generationVariants(...)");
        }
        return jBIterable;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e, variant, vars, modifyParent);
        if (e instanceof CassRole) {
            ((CassRole)e).setCanLogin(Intrinsics.areEqual((Object)variant, (Object)ModelHelper.USER));
        }
        if (e instanceof CassSchema) {
            Map properties = MapsKt.mapOf((Pair)TuplesKt.to((Object)((Object)CassSchemaPropertyKind.REPLICATION), (Object)"{'class': 'SimpleStrategy', 'replication_factor': 1}"));
            ((CassSchema)e).setProperties(properties);
            vars.put("properties", "replication = {'class': 'SimpleStrategy', 'replication_factor': 1}");
        }
        if (e instanceof CassFunction) {
            ((CassFunction)e).setLanguage("java");
            vars.put("language", "java");
            BasicModArgument basicModArgument = ((CassFunction)e).createOrGetReturnArgument();
            DataType dataType = DataTypeFactory.of((String)"int");
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            basicModArgument.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            vars.put("returns", "int");
        }
        if (e instanceof CassDefType) {
            BasicModElement basicModElement = ((CassDefType)e).getAttributes().createNewOne();
            Intrinsics.checkNotNullExpressionValue((Object)basicModElement, (String)"createNewOne(...)");
            CassDefTypeAttribute attr = (CassDefTypeAttribute)basicModElement;
            this.setTemplateName((BasicModNamedElement)attr, "attr");
            DataType dataType = DataTypeFactory.of((String)"int");
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            attr.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            vars.put("attrs", "attr int");
        }
    }
}

