/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.redshift;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.postgres.PgParser;
import com.intellij.sql.dialects.postgres.PgParserBase;
import com.intellij.sql.dialects.redshift.RsDdlParsing;
import com.intellij.sql.dialects.redshift.RsDialect;
import com.intellij.sql.dialects.redshift.RsDmlParsing;
import com.intellij.sql.dialects.redshift.RsElementTypes;
import com.intellij.sql.dialects.redshift.RsExpressionParsing;
import com.intellij.sql.dialects.redshift.RsGeneratedParser;
import com.intellij.sql.dialects.redshift.RsGeneratedParserUtil;
import com.intellij.sql.dialects.redshift.RsPlParsing;
import com.intellij.sql.injection.SqlSuggestedInjection;
import com.intellij.sql.psi.SqlReferenceElementType;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class RsParser
extends PgParserBase {
    public static final SqlSuggestedInjection REDSHIFT_INJECTION = new SqlSuggestedInjection("Redshift");

    public RsParser(boolean pl) {
        super((SqlLanguageDialectEx)RsDialect.INSTANCE, pl);
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (RsGeneratedParserUtil.isJoinOperator(builder)) {
            return false;
        }
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        if (RsGeneratedParser.within_group_clause(builder, level) | RsGeneratedParser.analytic_clause(builder, level)) {
            IElementType type;
            LighterASTNode ref2 = SqlGeneratedParserUtil.getExposedFunctionRef((PsiBuilder)builder);
            IElementType iElementType = type = ref2 == null ? null : ref2.getTokenType();
            if (type == SQL_REFERENCE || type == SQL_ANY_CALLABLE_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)ref2).remapTokenType((IElementType)SQL_FUNCTION_REFERENCE);
            }
        }
        return true;
    }

    @Nullable
    public SqlSuggestedInjection getCurrentSqlInjection() {
        return REDSHIFT_INJECTION;
    }

    public boolean parseIdentifierInner(PsiBuilder builder, boolean optional, boolean allowKeywords, boolean allowCharSetSpec, SqlReferenceElementType refType) {
        PsiBuilder.Marker mark = builder.mark();
        if (!allowCharSetSpec && this.getLanguage().supportsSql92CharSetSpecFor((IElementType)SQL_IDENTIFIER)) {
            this.consumeUnderscoreAndCharSpec(builder);
        }
        if (this.consumeIdentifier(builder, allowKeywords, this.allowStringsAsIdentifiers(refType), refType != null, refType)) {
            mark.done((IElementType)SQL_IDENTIFIER);
            return true;
        }
        if (!optional) {
            mark.error(SqlBundle.message((String)"identifier.expected", (Object[])new Object[0]));
        } else {
            mark.drop();
        }
        return false;
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return RsGeneratedParser.parse_root_(root, builder, level);
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = RsExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, RsExpressionParsing::evaluable_expression);
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        if (super.parseSqlStatement(builder, level)) {
            return true;
        }
        return RsGeneratedParser.statement(builder, level);
    }

    protected TokenSet[] getExtendsTokenSets() {
        return RsGeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return RsDmlParsing.top_query_expression(builder, level);
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? RsPlParsing.type_element_ext(builder, level) : RsDdlParsing.type_element(builder, level);
    }

    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, RsExpressionParsing::parenthesized_values_expr, RsDmlParsing::top_query_expression, PgParser::parseTopQueryExpressionTail, RsExpressionParsing::row_element_list, (b, l) -> RsExpressionParsing.root_expr_0(b, l, -1) && RsExpressionParsing.row_element_list_separator(b, l) && RsExpressionParsing.row_element_list(b, l));
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, RsDmlParsing::parenthesized_aliased_join_expression, RsDmlParsing::top_query_expression, PgParser::parseTopQueryExpressionTail, (b, l) -> RsDmlParsing.join_expression(b, l, -1), (b, l) -> RsDmlParsing.join_expression_0(b, l, -1));
    }

    public boolean parseFunctionParametersEnd(PsiBuilder builder, int level, BuiltinFunction definition) {
        RsDmlParsing.order_by_clause(builder, level);
        return true;
    }

    protected boolean parseTypedReference(PsiBuilder builder, SqlReferenceElementType refType) {
        boolean result = super.parseTypedReference(builder, refType);
        if (!result && SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_STRING_TOKEN)) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.done((IElementType)SQL_STRING_LITERAL);
            result = true;
        }
        if (result && SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)PG_OP_TYPE_CAST)) {
            PsiBuilder.Marker marker = Objects.requireNonNull((PsiBuilder.Marker)builder.getLatestDoneMarker());
            RsPlParsing.type_element_ext_inner(builder, 0);
            marker.precede().done((IElementType)SQL_BINARY_EXPRESSION);
        }
        return result;
    }

    @Nullable
    public IElementType getLazyCodeBlockType() {
        return RsElementTypes.Misc.RS_LAZY_CODE_BLOCK;
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        RsDmlParsing.query_expression_0(builder, level, -1);
        return RsDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

