/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.layout;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphToggleAction;
import com.intellij.openapi.graph.layout.GraphLayout;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.services.GraphUndoService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLayoutAction
extends AbstractGraphToggleAction {
    @Override
    protected boolean isSelected(@NotNull Graph2D graph, @NotNull Project project, @NotNull AnActionEvent event) {
        GraphBuilder<?, ?> builder2;
        if (graph == null) {
            AbstractLayoutAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AbstractLayoutAction.$$$reportNull$$$0(1);
        }
        if (event == null) {
            AbstractLayoutAction.$$$reportNull$$$0(2);
        }
        if ((builder2 = this.getBuilder(event)) == null) {
            return false;
        }
        return builder2.getGraphPresentationModel().getSettings().getCurrentLayouter() == this.getLayouter(project, builder2);
    }

    @Override
    protected void setSelected(@NotNull Graph2D graph, boolean state, @NotNull Project project, @NotNull AnActionEvent e) {
        GraphBuilder<?, ?> builder2;
        if (graph == null) {
            AbstractLayoutAction.$$$reportNull$$$0(3);
        }
        if (project == null) {
            AbstractLayoutAction.$$$reportNull$$$0(4);
        }
        if (e == null) {
            AbstractLayoutAction.$$$reportNull$$$0(5);
        }
        if ((builder2 = this.getBuilder(e)) == null) {
            return;
        }
        Layouter oldLayouter = builder2.getGraphPresentationModel().getSettings().getCurrentLayouter();
        Layouter layouter = this.getLayouter(builder2.getProject(), builder2);
        GraphLayoutService.getInstance().calcLayoutAsync(builder2, layouter).thenAcceptAsync(layout -> GraphUndoService.getInstance().performPositionsOnlyChangingAction(builder2, this.getLayoutName(), () -> {
            builder2.getGraphPresentationModel().getSettings().setCurrentLayouter(layouter);
            this.beforeLayoutPerformed(layouter, builder2);
            GraphLayoutService.getInstance().queryLayout(builder2).animated().withCustomLayout((GraphLayout)layout).run();
            this.afterLayoutPerformed(layouter, builder2);
        }, restoreRealizers -> {
            builder2.getGraphPresentationModel().getSettings().setCurrentLayouter(oldLayouter);
            restoreRealizers.run();
        }, restoreRealizers -> {
            builder2.getGraphPresentationModel().getSettings().setCurrentLayouter(this.getLayouter(builder2.getProject(), builder2));
            restoreRealizers.run();
        }), Futures.inEdt());
    }

    @Override
    @Nullable
    @NlsActions.ActionText
    protected String getText(@NotNull Graph2D graph) {
        if (graph == null) {
            AbstractLayoutAction.$$$reportNull$$$0(6);
        }
        return this.getLayoutName();
    }

    @Override
    protected boolean isEnabled(@NotNull Graph2D graph, @NotNull Project project, @NotNull AnActionEvent event) {
        GraphBuilder<?, ?> builder2;
        if (graph == null) {
            AbstractLayoutAction.$$$reportNull$$$0(7);
        }
        if (project == null) {
            AbstractLayoutAction.$$$reportNull$$$0(8);
        }
        if (event == null) {
            AbstractLayoutAction.$$$reportNull$$$0(9);
        }
        return (builder2 = this.getBuilder(event)) != null && graph.nodeCount() > 0 && GraphLayoutService.getInstance().canLayout(builder2, this.getLayouter(builder2.getProject(), builder2));
    }

    protected abstract Layouter getLayouter(Project var1, @NotNull GraphBuilder<?, ?> var2);

    @NlsActions.ActionText
    protected abstract String getLayoutName();

    protected boolean areBridgesPreferred() {
        return true;
    }

    protected void beforeLayoutPerformed(@NotNull Layouter layouter, @NotNull GraphBuilder<?, ?> builder2) {
        if (layouter == null) {
            AbstractLayoutAction.$$$reportNull$$$0(10);
        }
        if (builder2 == null) {
            AbstractLayoutAction.$$$reportNull$$$0(11);
        }
        builder2.getGraphPresentationModel().getSettings().setShowBridges(this.areBridgesPreferred());
    }

    protected void afterLayoutPerformed(@NotNull Layouter layouter, @NotNull GraphBuilder<?, ?> builder2) {
        if (layouter == null) {
            AbstractLayoutAction.$$$reportNull$$$0(12);
        }
        if (builder2 == null) {
            AbstractLayoutAction.$$$reportNull$$$0(13);
        }
        builder2.getEditMode().setOrthogonalEdgeRouting(GraphLayoutService.getInstance().doesImplyOrthogonalEdgeRouting(layouter));
    }

    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AbstractLayoutAction.$$$reportNull$$$0(14);
        }
        return actionUpdateThread;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layouter";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/actions/layout/AbstractLayoutAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/actions/layout/AbstractLayoutAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "beforeLayoutPerformed";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "afterLayoutPerformed";
                break;
            }
            case 14: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14 -> new IllegalStateException(string);
        };
    }
}

