/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.printing;

import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.option.OptionHandler;
import com.intellij.openapi.graph.view.Graph2DPrinter;

public final class PrintUtil {
    private PrintUtil() {
    }

    public static void initGraph2DPrinter(Graph2DPrinter gp, OptionHandler options) {
        if (options.getInt(PrintUtil.getPosterRows()) < 0) {
            options.set(PrintUtil.getPosterRows(), Math.abs(options.getInt(PrintUtil.getPosterRows())));
        }
        if (options.getInt(PrintUtil.getPosterColumns()) < 0) {
            options.set(PrintUtil.getPosterColumns(), Math.abs(options.getInt(PrintUtil.getPosterColumns())));
        }
        gp.setPosterRows(options.getInt(PrintUtil.getPosterRows()));
        gp.setPosterColumns(options.getInt(PrintUtil.getPosterColumns()));
        gp.setPrintPosterCoords(options.getBool(PrintUtil.getPosterCoords()));
        if (options.get(PrintUtil.getClipArea()).equals(PrintUtil.getGraph())) {
            gp.setClipType(Graph2DPrinter.CLIP_GRAPH);
        } else {
            gp.setClipType(Graph2DPrinter.CLIP_VIEW);
        }
    }

    public static OptionHandler createPrintOptions() {
        OptionHandler handler = GraphManager.getGraphManager().createOptionHandler(GraphBundle.message("graph.framework.printing.options", new Object[0]));
        handler.useSection(PrintUtil.getGeneralSection());
        handler.addInt(PrintUtil.getPosterRows(), 1);
        handler.addInt(PrintUtil.getPosterColumns(), 1);
        handler.addBool(PrintUtil.getPosterCoords(), false);
        Object[] area = new String[]{PrintUtil.getView(), PrintUtil.getGraph()};
        handler.addEnum(PrintUtil.getClipArea(), area, 1);
        return handler;
    }

    public static String getPosterRows() {
        return GraphBundle.message("graph.framework.printing.poster.rows", new Object[0]);
    }

    public static String getPosterColumns() {
        return GraphBundle.message("graph.framework.printing.poster.cols", new Object[0]);
    }

    public static String getPosterCoords() {
        return GraphBundle.message("graph.framework.printing.poster.coords", new Object[0]);
    }

    public static String getView() {
        return GraphBundle.message("graph.framework.printing.view", new Object[0]);
    }

    public static String getGraph() {
        return GraphBundle.message("graph.framework.printing.graph", new Object[0]);
    }

    public static String getClipArea() {
        return GraphBundle.message("graph.framework.printing.clip.area", new Object[0]);
    }

    public static String getGeneralSection() {
        return GraphBundle.message("graph.framework.printing.general", new Object[0]);
    }
}

