/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.event;

import com.intellij.openapi.graph.builder.GraphBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum GraphBuilderEvent {
    NODES_MOVED,
    EDGE_MOVED,
    ZOOM_CHANGED,
    GRAPH_MOVED,
    NODES_MOVED_BY_KEYBOARD;


    public String toString() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NODES_MOVED, NODES_MOVED_BY_KEYBOARD -> "Move nodes";
            case EDGE_MOVED -> "Move edge";
            case ZOOM_CHANGED -> "Change zoom";
            case GRAPH_MOVED -> "Move graph";
        };
    }

    @Nullable
    public static GraphBuilderEvent fromString(@NotNull @NonNls String str) {
        if (str == null) {
            GraphBuilderEvent.$$$reportNull$$$0(0);
        }
        return switch (str) {
            case "Move nodes" -> NODES_MOVED;
            case "Move edge" -> EDGE_MOVED;
            case "Change zoom" -> ZOOM_CHANGED;
            case "Move graph" -> GRAPH_MOVED;
            default -> null;
        };
    }

    @Nls
    public String getTitle() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NODES_MOVED, NODES_MOVED_BY_KEYBOARD -> GraphBundle.message("graph.builder.event.move.nodes", new Object[0]);
            case EDGE_MOVED -> GraphBundle.message("graph.builder.event.move.edge", new Object[0]);
            case ZOOM_CHANGED -> GraphBundle.message("graph.builder.event.zoom", new Object[0]);
            case GRAPH_MOVED -> GraphBundle.message("graph.builder.event.move.graph", new Object[0]);
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/openapi/graph/builder/event/GraphBuilderEvent", "fromString"));
    }
}

