/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.treeHash.DuplicatesProfileBase;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.NodeSpecificHasherBase;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.indexing.FileContent;
import org.jetbrains.annotations.NotNull;

public final class JSDuplicatesProfile
extends DuplicatesProfileBase {
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            JSDuplicatesProfile.$$$reportNull$$$0(0);
        }
        return language.isKindOf((Language)JavascriptLanguage.INSTANCE);
    }

    public PsiElementRole getRole(@NotNull PsiElement element2) {
        PsiElement parent;
        if (element2 == null) {
            JSDuplicatesProfile.$$$reportNull$$$0(1);
        }
        if ((parent = element2.getParent()) instanceof JSVariable && ((JSVariable)parent).getNameIdentifier() == element2) {
            return PsiElementRole.VARIABLE_NAME;
        }
        if (parent instanceof JSFunction && ((JSFunction)parent).getNameIdentifier() == element2) {
            return PsiElementRole.FUNCTION_NAME;
        }
        return null;
    }

    @NotNull
    public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector, boolean forIndexing) {
        if (collector == null) {
            JSDuplicatesProfile.$$$reportNull$$$0(2);
        }
        return new NodeSpecificHasherBase(DuplocatorSettings.getInstance(), collector, this, forIndexing){

            public int getNodeHash(PsiElement node) {
                if (this.myForIndexing) {
                    if (node instanceof LeafPsiElement) {
                        return 0;
                    }
                    if (node instanceof JSReferenceExpression) {
                        String name;
                        PsiElement parent = node.getParent();
                        if (parent instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == node) {
                            String name2 = ((JSReferenceExpression)node).getReferencedName();
                            if (name2 != null) {
                                return name2.hashCode();
                            }
                        } else if (((JSReferenceExpression)node).getQualifier() instanceof JSReferenceExpression && (name = ((JSReferenceExpression)node).getReferencedName()) != null) {
                            return name.hashCode();
                        }
                        return 0;
                    }
                    if (node instanceof JSVariable) {
                        return 0;
                    }
                }
                return super.getNodeHash(node);
            }
        };
    }

    @NotNull
    public Language getLanguage(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSDuplicatesProfile.$$$reportNull$$$0(3);
        }
        Language language = JSDuplicatesProfile.getLanguageForElement(element2);
        if (language == null) {
            JSDuplicatesProfile.$$$reportNull$$$0(4);
        }
        return language;
    }

    public int getNodeCost(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSDuplicatesProfile.$$$reportNull$$$0(5);
        }
        if (element2 instanceof JSStatement || element2 instanceof JSFunction || element2 instanceof JSClass) {
            return 2;
        }
        if (element2 instanceof JSExpression) {
            return 1;
        }
        return 0;
    }

    public boolean shouldPutInIndex(PsiFragment fragment, int cost, DuplocatorState state) {
        PsiElement[] elements = fragment.getElements();
        if (elements.length == 0) {
            return false;
        }
        return JSDuplicatesProfile.isAcceptableElement(elements[0]);
    }

    private static boolean isAcceptableElement(PsiElement element2) {
        if (element2 instanceof JSStatement) {
            if (element2 instanceof JSBlockStatement) {
                ASTNode node = element2.getNode();
                ASTNode firstStatement = node.findChildByType(JSExtendedLanguagesTokenSetProvider.STATEMENTS);
                if (firstStatement == null) {
                    return false;
                }
                for (ASTNode last = node.getLastChildNode(); last != null; last = last.getTreePrev()) {
                    if (!JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(last.getElementType())) continue;
                    if (last != firstStatement) break;
                    return JSDuplicatesProfile.isAcceptableElement(last.getPsi());
                }
                if (element2.getParent() instanceof JSFunction) {
                    return false;
                }
            }
            if (!(element2 instanceof JSExpressionStatement || element2 instanceof JSLabeledStatement || element2 instanceof JSContinueStatement || element2 instanceof JSBreakStatement || element2 instanceof JSVarStatement || element2 instanceof JSReturnStatement)) {
                return true;
            }
        }
        if (element2 instanceof JSExpression && element2.getParent() instanceof JSExpressionStatement && !(element2 instanceof JSAssignmentExpression)) {
            return true;
        }
        return element2 instanceof JSFunction;
    }

    public TokenSet getLiterals() {
        return JSTokenTypes.LITERALS;
    }

    public static Language getLanguageForElement(PsiElement element2) {
        return DialectDetector.isActionScript(element2) ? FlexSupportLoader.ECMA_SCRIPT_L4 : JavascriptLanguage.INSTANCE;
    }

    public boolean supportDuplicatesIndex() {
        return true;
    }

    public boolean acceptsContentForIndexing(FileContent fileContent) {
        return !JSMinifiedFileUtil.isFileContentMinified(fileContent.getFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/JSDuplicatesProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/JSDuplicatesProfile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRole";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNodeCost";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

