/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core.codeInsight;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryManager;
import com.intellij.javascript.nodejs.library.core.codeInsight.EnableNodeCoreCodingAssistanceFix;
import com.intellij.javascript.nodejs.reference.NodeCoreModulePsiReference;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.resolve.JSReferenceUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NodeCoreCodingAssistanceInspection
extends JSInspection {
    @NonNls
    public static final String INSPECTION_SHORT_NAME = "NodeCoreCodingAssistance";

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            NodeCoreCodingAssistanceInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            NodeCoreCodingAssistanceInspection.$$$reportNull$$$0(1);
        }
        if (!holder.isOnTheFly()) {
            JSElementVisitor jSElementVisitor = JSElementVisitor.NOP_ELEMENT_VISITOR;
            if (jSElementVisitor == null) {
                NodeCoreCodingAssistanceInspection.$$$reportNull$$$0(2);
            }
            return jSElementVisitor;
        }
        FileType fileType = holder.getFile().getFileType();
        if (TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(fileType)) {
            JSElementVisitor jSElementVisitor = JSElementVisitor.NOP_ELEMENT_VISITOR;
            if (jSElementVisitor == null) {
                NodeCoreCodingAssistanceInspection.$$$reportNull$$$0(3);
            }
            return jSElementVisitor;
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                NodeCoreCodingAssistanceInspection.handleFileReferenceHolder((PsiElement)node, holder);
            }

            @Override
            public void visitES6FromClause(@NotNull ES6FromClause fromClause) {
                if (fromClause == null) {
                    1.$$$reportNull$$$0(1);
                }
                NodeCoreCodingAssistanceInspection.handleFileReferenceHolder((PsiElement)fromClause, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fromClause";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/codeInsight/NodeCoreCodingAssistanceInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSLiteralExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitES6FromClause";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void handleFileReferenceHolder(@NotNull PsiElement psiElement, @NotNull ProblemsHolder holder) {
        PsiReference[] allRefs;
        if (psiElement == null) {
            NodeCoreCodingAssistanceInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            NodeCoreCodingAssistanceInspection.$$$reportNull$$$0(5);
        }
        for (PsiReference ref2 : allRefs = psiElement.getReferences()) {
            if (!(ref2 instanceof NodeCoreModulePsiReference)) continue;
            NodeCoreCodingAssistanceInspection.handleRef(ref2, allRefs, holder);
        }
    }

    private static void handleRef(@NotNull PsiReference ref2, PsiReference @NotNull [] allRefs, @NotNull ProblemsHolder holder) {
        if (ref2 == null) {
            NodeCoreCodingAssistanceInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            NodeCoreCodingAssistanceInspection.$$$reportNull$$$0(7);
        }
        if (allRefs == null) {
            NodeCoreCodingAssistanceInspection.$$$reportNull$$$0(8);
        }
        Project project = holder.getProject();
        boolean coreModule = NodeCoreLibraryManager.isCoreModuleName(ref2.getCanonicalText());
        if (coreModule) {
            NodeCoreLibraryManager coreLibraryManager;
            boolean hasValidResolve = false;
            for (PsiReference fileRef : allRefs) {
                if (!(fileRef instanceof JSModuleBaseReference) || !JSReferenceUtil.hasValidResolveResult(fileRef)) continue;
                hasValidResolve = true;
                break;
            }
            if (!hasValidResolve && !(coreLibraryManager = NodeCoreLibraryManager.getInstance(project)).hasAssociatedRoots()) {
                holder.registerProblemForReference(ref2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, JavaScriptBundle.message("inspection.NodeCoreCodingAssistanceInspection.no.coding.assistance.message", new Object[0]), new LocalQuickFix[]{new EnableNodeCoreCodingAssistanceFix()});
            }
        }
    }

    @Override
    @NotNull
    public String getShortName() {
        return INSPECTION_SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/codeInsight/NodeCoreCodingAssistanceInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/codeInsight/NodeCoreCodingAssistanceInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleFileReferenceHolder";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleRef";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

