/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.IntentionActionWithTimeout;
import com.intellij.lang.javascript.linter.JSLinterRelatedIntention;
import com.intellij.lang.javascript.linter.NavigateToPropertyInConfig;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class JSLinterEditConfigFileAction
extends IntentionActionWithTimeout
implements Iconable,
JSLinterRelatedIntention {
    protected final VirtualFile myVirtualFile;
    private final Icon myIcon;
    private String myProperty;

    public JSLinterEditConfigFileAction(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            JSLinterEditConfigFileAction.$$$reportNull$$$0(0);
        }
        super(50);
        this.myVirtualFile = virtualFile;
        this.myIcon = virtualFile.getFileType().getIcon();
    }

    public void setProperty(String property) {
        this.myProperty = property;
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return this.myIcon;
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myProperty != null) {
            String string = JavaScriptBundle.message("javascript.linter.action.edit.property", this.myProperty, this.myVirtualFile.getName());
            if (string == null) {
                JSLinterEditConfigFileAction.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = JavaScriptBundle.message("javascript.linter.action.edit.config", this.myVirtualFile.getName());
        if (string == null) {
            JSLinterEditConfigFileAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            JSLinterEditConfigFileAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            JSLinterEditConfigFileAction.$$$reportNull$$$0(4);
        }
        return this.myVirtualFile.isValid();
    }

    @Override
    public void invokeReally(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            JSLinterEditConfigFileAction.$$$reportNull$$$0(5);
        }
        if (this.myProperty != null) {
            NavigateToPropertyInConfig.navigate(project, this.myVirtualFile, this.myProperty);
        } else {
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            manager.openFile(this.myVirtualFile, true);
        }
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/JSLinterEditConfigFileAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterEditConfigFileAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invokeReally";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

