/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.javascript.typeEngine.JSServicePoweredTypeEngineUsageContext;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.typescript.resolve.TypeScriptCompilerEvaluationFacade;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J#\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ#\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011J0\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u000b\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/lang/javascript/psi/resolve/JSPropertyNameResolver;", "Lcom/intellij/psi/impl/source/resolve/ResolveCache$PolyVariantResolver;", "Lcom/intellij/lang/javascript/psi/impl/JSPropertyNameReference;", "<init>", "()V", "resolve", "", "Lcom/intellij/psi/ResolveResult;", "reference", "incompleteCode", "", "(Lcom/intellij/lang/javascript/psi/impl/JSPropertyNameReference;Z)[Lcom/intellij/psi/ResolveResult;", "resolveFromRecordType", "name", "", "type", "Lcom/intellij/lang/javascript/psi/JSType;", "(Ljava/lang/String;Lcom/intellij/lang/javascript/psi/JSType;)[Lcom/intellij/psi/ResolveResult;", "resolveWithQualifiedItemProcessor", "parent", "Lcom/intellij/lang/javascript/psi/JSObjectLiteralExpression;", "property", "Lcom/intellij/lang/javascript/psi/JSProperty;", "Lcom/intellij/openapi/util/NlsSafe;", "(Lcom/intellij/lang/javascript/psi/JSObjectLiteralExpression;Lcom/intellij/lang/javascript/psi/JSProperty;Ljava/lang/String;)[Lcom/intellij/psi/ResolveResult;", "getExplicitElement", "Lcom/intellij/psi/PsiElement;", "rr", "element", "intellij.javascript.psi.impl"})
@SourceDebugExtension(value={"SMAP\nJSPropertyNameResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSPropertyNameResolver.kt\ncom/intellij/lang/javascript/psi/resolve/JSPropertyNameResolver\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,97:1\n30#2,2:98\n1563#3:100\n1634#3,3:101\n774#3:104\n865#3,2:105\n1374#3:107\n1460#3,5:108\n774#3:113\n865#3,2:114\n1669#3,8:116\n37#4:124\n36#4,3:125\n*S KotlinDebug\n*F\n+ 1 JSPropertyNameResolver.kt\ncom/intellij/lang/javascript/psi/resolve/JSPropertyNameResolver\n*L\n27#1:98,2\n43#1:100\n43#1:101,3\n49#1:104\n49#1:105,2\n50#1:107\n50#1:108,5\n79#1:113\n79#1:114,2\n80#1:116,8\n81#1:124\n81#1:125,3\n*E\n"})
public final class JSPropertyNameResolver
implements ResolveCache.PolyVariantResolver<JSPropertyNameReference> {
    @NotNull
    public static final JSPropertyNameResolver INSTANCE = new JSPropertyNameResolver();

    private JSPropertyNameResolver() {
    }

    @NotNull
    public ResolveResult[] resolve(@NotNull JSPropertyNameReference reference, boolean incompleteCode) {
        ResolveResult[] resolveResultArray;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        JSProperty jSProperty = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)jSProperty, (String)"getElement(...)");
        JSProperty property = jSProperty;
        String string = property.getName();
        if (string == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ResolveResult.EMPTY_ARRAY;
        }
        String name = string;
        PsiElement psiElement = property.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSObjectLiteralExpression");
        JSObjectLiteralExpression parent = (JSObjectLiteralExpression)psiElement;
        Project project = parent.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<TypeScriptCompilerEvaluationFacade> serviceClass$iv = TypeScriptCompilerEvaluationFacade.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        JSType typeFromService2 = ((TypeScriptCompilerEvaluationFacade)object).getContextualTypeFromService(parent, false, JSServicePoweredTypeEngineUsageContext.CONTEXTUAL_TYPES_FOR_PROPERTY_RESOLVE);
        ResolveResult[] results = typeFromService2 != null ? this.resolveFromRecordType(name, typeFromService2) : this.resolveWithQualifiedItemProcessor(parent, property, name);
        if (!(results.length == 0)) {
            resolveResultArray = results;
        } else {
            ResolveResult[] resolveResultArray2 = new ResolveResult[]{new JSResolveResult((PsiElement)property)};
            resolveResultArray = resolveResultArray2;
        }
        return resolveResultArray;
    }

    /*
     * WARNING - void declaration
     */
    private final ResolveResult[] resolveFromRecordType(String name, JSType type2) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        JSRecordType.IndexSignature it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        JSRecordType jSRecordType = type2.asRecordType();
        Intrinsics.checkNotNullExpressionValue((Object)jSRecordType, (String)"asRecordType(...)");
        JSRecordType recordType = jSRecordType;
        JSRecordType.PropertySignature propertySignature = recordType.findPropertySignature(name);
        if (propertySignature != null) {
            void $this$mapTo$iv$iv;
            List<PsiElement> list = propertySignature.getMemberSource().getAllSourceElements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAllSourceElements(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                PsiElement psiElement = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it2);
                collection.add(INSTANCE.getExplicitElement((PsiElement)it2));
            }
            List allSources = (List)destination$iv$iv;
            ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(allSources);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"toResolveResults(...)");
            return resolveResultArray;
        }
        List<JSRecordType.IndexSignature> list = recordType.getIndexSignatures();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getIndexSignatures(...)");
        Iterable $this$map$iv = CollectionsKt.filterNotNull((Iterable)list);
        boolean $i$f$filter = false;
        void $this$mapTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JSRecordType.IndexSignature)element$iv$iv;
            boolean bl = false;
            if (!JSRecordTypeImpl.isPropNameApplicableToIndexSignature(name, it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (JSRecordType.IndexSignature)element$iv$iv;
            boolean bl = false;
            List<PsiElement> list2 = it.getMemberSource().getAllSourceElements();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getAllSourceElements(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List indexSignatureSources = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        if (!indexSignatureSources.isEmpty()) {
            ResolveResult[] resolveResultArray = JSResolveResult.toResolveResults(indexSignatureSources);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"toResolveResults(...)");
            return resolveResultArray;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return ResolveResult.EMPTY_ARRAY;
    }

    /*
     * WARNING - void declaration
     */
    private final ResolveResult[] resolveWithQualifiedItemProcessor(JSObjectLiteralExpression parent, JSProperty property, String name) {
        void $this$toTypedArray$iv;
        Collection $this$distinctBy$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        JSType type2 = JSDialectSpecificHandlersFactory.findExpectedType(parent, JSExpectedTypeKind.CONTEXTUAL);
        if (type2 == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ResolveResult.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ResolveResult.EMPTY_ARRAY;
        }
        QualifiedItemProcessor<ResultSink> processor = JSDialectSpecificHandlersFactory.forElement((PsiElement)property).createQualifiedItemProcessor((ResultSink)new ResolveResultSink((PsiElement)property, name), (PsiElement)property);
        PsiFile containingFile = property.getContainingFile();
        if (type2 instanceof JSIntersectionType) {
            for (JSType typeComponent : ((JSIntersectionType)type2).getTypes()) {
                processor.process(typeComponent, new JSEvaluateContext(containingFile));
            }
        } else {
            processor.process(type2, new JSEvaluateContext(containingFile));
        }
        Object[] results = processor.getResultsAsResolveResults();
        Intrinsics.checkNotNull((Object)results);
        Iterable iterable = ArraysKt.filterNotNull((Object[])results);
        boolean $i$f$filter = false;
        void var11_11 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResolveResult it = (ResolveResult)element$iv$iv;
            boolean bl = false;
            if (!(!(it.getElement() instanceof TypeScriptIndexSignature))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<PsiElement> set$iv = new HashSet<PsiElement>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            ResolveResult it = (ResolveResult)e$iv;
            boolean bl = false;
            PsiElement key$iv = INSTANCE.getExplicitElement(it);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ResolveResult[] filteredResults = thisCollection$iv.toArray(new ResolveResult[0]);
        if (!(filteredResults.length == 0)) {
            return filteredResults;
        }
        return results;
    }

    private final PsiElement getExplicitElement(ResolveResult rr) {
        PsiElement element2;
        PsiElement psiElement = element2 = rr.getElement();
        return psiElement != null ? this.getExplicitElement(psiElement) : null;
    }

    private final PsiElement getExplicitElement(PsiElement element2) {
        PsiElement psiElement;
        if (element2 instanceof TypeScriptProxyImplicitElement) {
            PsiElement psiElement2 = ((TypeScriptProxyImplicitElement)element2).getExplicitElement();
            psiElement = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getExplicitElement(...)");
        } else {
            psiElement = element2;
        }
        return psiElement;
    }
}

