/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ArrayListSet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VariableAccessUtil {
    private VariableAccessUtil() {
    }

    public static boolean variableIsAssignedFrom(JSVariable variable, JSElement context2) {
        VariableAssignedFromVisitor visitor = new VariableAssignedFromVisitor(variable);
        context2.accept(visitor);
        return visitor.isAssignedFrom();
    }

    public static boolean variableIsAssigned(JSVariable variable, JSElement context2) {
        return VariableAccessUtil.variableIsAssigned(variable, context2, Collections.emptySet(), Collections.emptySet());
    }

    private static boolean variableIsAssigned(JSVariable variable, JSElement context2, Set<JSVariable> notUpdatedSymbols, Set<JSVariable> candidateSymbols) {
        VariableAssignedVisitor visitor = new VariableAssignedVisitor(variable, context2, notUpdatedSymbols, candidateSymbols);
        context2.accept(visitor);
        return visitor.isAssigned();
    }

    public static boolean mayEvaluateToVariable(@Nullable JSExpression expression, @NotNull JSVariable variable) {
        if (variable == null) {
            VariableAccessUtil.$$$reportNull$$$0(0);
        }
        String variableName = variable.getName();
        JSExpression expr = expression;
        if (variableName == null) {
            return false;
        }
        while (true) {
            if (expr == null) {
                return false;
            }
            if (expr instanceof JSBinaryExpression) {
                JSBinaryExpression binaryExpression = (JSBinaryExpression)expr;
                JSExpression lOperand = binaryExpression.getLOperand();
                if (VariableAccessUtil.mayEvaluateToVariable(lOperand, variable)) {
                    return true;
                }
                expr = binaryExpression.getROperand();
                continue;
            }
            if (expr instanceof JSParenthesizedExpression) {
                expr = ((JSParenthesizedExpression)expr).getInnerExpression();
                continue;
            }
            if (expr instanceof JSConditionalExpression) {
                JSConditionalExpression conditional = (JSConditionalExpression)expr;
                return VariableAccessUtil.mayEvaluateToVariable((JSExpression)conditional.getThenBranch(), variable) || VariableAccessUtil.mayEvaluateToVariable((JSExpression)conditional.getElseBranch(), variable);
            }
            if (expr instanceof JSDefinitionExpression) {
                expr = ((JSDefinitionExpression)expr).getExpression();
                continue;
            }
            if (!(expr instanceof JSSpreadExpression)) break;
            expr = ((JSSpreadExpression)expr).getExpression();
        }
        if (expr instanceof JSReferenceExpression) {
            PsiElement referent = ((JSReferenceExpression)expr).resolve();
            return referent != null && referent.equals(variable);
        }
        return false;
    }

    public static Set<JSVariable> getUsedVariables(PsiElement context2) {
        return SyntaxTraverser.psiTraverser((PsiElement)context2).filter(JSReferenceExpression.class).filter(r -> r.getQualifier() == null).map(r -> r.resolve()).filter(JSVariable.class).toSet();
    }

    public static boolean isLocalVariableUsed(@NotNull JSVariable variable, @Nullable PsiElement context2) {
        if (variable == null) {
            VariableAccessUtil.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            return false;
        }
        return SyntaxTraverser.psiTraverser((PsiElement)context2).filter(JSReferenceExpression.class).filter(r -> r.getQualifier() == null && Objects.equals(r.getReferenceName(), variable.getName()) && r.isReferenceTo((PsiElement)variable)).isNotEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "variable";
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/VariableAccessUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mayEvaluateToVariable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isLocalVariableUsed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class VariableAssignedFromVisitor
    extends JSRecursiveElementVisitor {
        private final JSVariable variable;
        private boolean assignedFrom;

        VariableAssignedFromVisitor(@NotNull JSVariable variable) {
            if (variable == null) {
                VariableAssignedFromVisitor.$$$reportNull$$$0(0);
            }
            this.variable = variable;
        }

        @Override
        public void visitJSElement(@NotNull JSElement element2) {
            if (element2 == null) {
                VariableAssignedFromVisitor.$$$reportNull$$$0(1);
            }
            if (!this.assignedFrom) {
                super.visitJSElement(element2);
            }
        }

        @Override
        public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression assignment) {
            if (assignment == null) {
                VariableAssignedFromVisitor.$$$reportNull$$$0(2);
            }
            if (!this.assignedFrom) {
                super.visitJSAssignmentExpression(assignment);
                this.assignedFrom = VariableAccessUtil.mayEvaluateToVariable(assignment.getROperand(), this.variable);
            }
        }

        @Override
        public void visitJSDestructuringElement(@NotNull JSDestructuringElement destructuringElement) {
            JSExpression initializer;
            if (destructuringElement == null) {
                VariableAssignedFromVisitor.$$$reportNull$$$0(3);
            }
            super.visitJSDestructuringElement(destructuringElement);
            if (!this.assignedFrom && (initializer = destructuringElement.getInitializer()) != null) {
                this.assignedFrom = VariableAccessUtil.mayEvaluateToVariable(initializer, this.variable);
            }
        }

        @Override
        public void visitJSDestructuringProperty(@NotNull JSDestructuringProperty destructuringProperty) {
            if (destructuringProperty == null) {
                VariableAssignedFromVisitor.$$$reportNull$$$0(4);
            }
            if (!this.assignedFrom) {
                PsiElement referent;
                super.visitJSDestructuringProperty(destructuringProperty);
                PsiReference reference = destructuringProperty.getReference();
                if (reference != null && (referent = reference.resolve()) != null && referent.equals(this.variable)) {
                    this.assignedFrom = true;
                }
            }
        }

        @Override
        public void visitJSVarStatement(@NotNull JSVarStatement statement) {
            if (statement == null) {
                VariableAssignedFromVisitor.$$$reportNull$$$0(5);
            }
            if (!this.assignedFrom) {
                super.visitJSVarStatement(statement);
                for (JSVariable declaredVariable : statement.getVariables()) {
                    JSExpression initializer = declaredVariable.getInitializer();
                    if (initializer == null) continue;
                    this.assignedFrom = VariableAccessUtil.mayEvaluateToVariable(initializer, this.variable);
                }
            }
        }

        @Override
        public void visitJSVariable(@NotNull JSVariable var) {
            if (var == null) {
                VariableAssignedFromVisitor.$$$reportNull$$$0(6);
            }
            if (!this.assignedFrom) {
                super.visitJSVariable(var);
                this.assignedFrom = VariableAccessUtil.mayEvaluateToVariable(var.getInitializer(), this.variable);
            }
        }

        public boolean isAssignedFrom() {
            return this.assignedFrom;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destructuringElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "destructuringProperty";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "var";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/util/VariableAccessUtil$VariableAssignedFromVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSElement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSAssignmentExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSDestructuringElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSDestructuringProperty";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSVarStatement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSVariable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class VariableAssignedVisitor
    extends JSRecursiveElementVisitor {
        private final JSVariable variable;
        private final JSElement context;
        private Set<JSVariable> notUpdatedSymbols;
        private final Set<JSVariable> candidateSymbols;
        private boolean assigned;

        private VariableAssignedVisitor(@NotNull JSVariable variable, @NotNull JSElement context2, @NotNull Set<JSVariable> notUpdatedSymbols, @NotNull Set<JSVariable> candidateSymbols) {
            if (variable == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(1);
            }
            if (notUpdatedSymbols == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(2);
            }
            if (candidateSymbols == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(3);
            }
            this.variable = variable;
            this.context = context2;
            this.notUpdatedSymbols = notUpdatedSymbols;
            this.candidateSymbols = candidateSymbols;
        }

        @Override
        public void visitJSElement(@NotNull JSElement element2) {
            if (element2 == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(4);
            }
            if (!this.assigned) {
                super.visitJSElement(element2);
            }
        }

        @Override
        public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression assignment) {
            if (assignment == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(5);
            }
            if (!this.assigned) {
                super.visitJSAssignmentExpression(assignment);
                JSExpression arg = assignment.getLOperand();
                if (VariableAccessUtil.mayEvaluateToVariable(arg, this.variable)) {
                    JSExpression rOperand = assignment.getROperand();
                    Set<Object> usedVariables = rOperand != null ? VariableAccessUtil.getUsedVariables((PsiElement)rOperand) : Collections.emptySet();
                    ArrayListSet newCandidateSet = new ArrayListSet();
                    newCandidateSet.addAll(this.candidateSymbols);
                    newCandidateSet.add(this.variable);
                    for (JSVariable jSVariable : usedVariables) {
                        if (newCandidateSet.contains(jSVariable) || VariableAccessUtil.variableIsAssigned(jSVariable, this.context, this.notUpdatedSymbols, (Set<JSVariable>)newCandidateSet)) continue;
                        if (this.notUpdatedSymbols.isEmpty()) {
                            this.notUpdatedSymbols = new ArrayListSet();
                        }
                        this.notUpdatedSymbols.add(jSVariable);
                    }
                    this.assigned = true;
                } else {
                    this.assigned = false;
                }
            }
        }

        @Override
        public void visitJSPrefixExpression(@NotNull JSPrefixExpression prefixExpression) {
            if (prefixExpression == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(6);
            }
            if (!this.assigned) {
                super.visitJSPrefixExpression(prefixExpression);
                IElementType tokenType = prefixExpression.getOperationSign();
                if (!tokenType.equals(JSTokenTypes.PLUSPLUS) && !tokenType.equals(JSTokenTypes.MINUSMINUS)) {
                    return;
                }
                JSExpression operand = prefixExpression.getExpression();
                this.assigned = VariableAccessUtil.mayEvaluateToVariable(operand, this.variable);
            }
        }

        @Override
        public void visitJSPostfixExpression(@NotNull JSPostfixExpression postfixExpression) {
            if (postfixExpression == null) {
                VariableAssignedVisitor.$$$reportNull$$$0(7);
            }
            if (!this.assigned) {
                super.visitJSPostfixExpression(postfixExpression);
                IElementType tokenType = postfixExpression.getOperationSign();
                if (!tokenType.equals(JSTokenTypes.PLUSPLUS) && !tokenType.equals(JSTokenTypes.MINUSMINUS)) {
                    return;
                }
                JSExpression operand = postfixExpression.getExpression();
                this.assigned = VariableAccessUtil.mayEvaluateToVariable(operand, this.variable);
            }
        }

        public boolean isAssigned() {
            return this.assigned;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notUpdatedSymbols";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "candidateSymbols";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "assignment";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefixExpression";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "postfixExpression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/psi/util/VariableAccessUtil$VariableAssignedVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSAssignmentExpression";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPrefixExpression";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSPostfixExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

