/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.search;

import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.include.FileIncludeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/search/JavaScriptUseScopeEnlarger;", "Lcom/intellij/psi/search/UseScopeEnlarger;", "<init>", "()V", "getAdditionalUseScope", "Lcom/intellij/psi/search/SearchScope;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.javascript.impl"})
final class JavaScriptUseScopeEnlarger
extends UseScopeEnlarger {
    @Nullable
    public SearchScope getAdditionalUseScope(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Project project = element2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (ModuleManager.Companion.getInstance(project).getModules().length < 2) {
            return null;
        }
        DialectOptionHolder dialectOptionHolder = DialectDetector.dialectOfElement(element2);
        if (dialectOptionHolder == null) {
            return null;
        }
        DialectOptionHolder dialect = dialectOptionHolder;
        if (!dialect.isJavaScript() && !dialect.isTypeScript) {
            return null;
        }
        String string = element2.getContainingFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String fileName = string;
        String fileNameWithoutExt = JSFileReferencesUtil.getFileNameWithoutExtension(fileName, TypeScriptUtil.TYPESCRIPT_AND_JS_EXTENSIONS);
        Object fileNameWithExt = TypeScriptUtil.isJavaScriptFile(fileName) ? fileName : fileNameWithoutExt + ".js";
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)element2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        GlobalSearchScope scope2 = globalSearchScope;
        HashSet includingFiles = new HashSet();
        FileIncludeIndex.collectIncludingFileCandidateFiles((String)fileNameWithoutExt, (GlobalSearchScope)scope2, (Set)includingFiles);
        FileIncludeIndex.collectIncludingFileCandidateFiles((String)fileNameWithExt, (GlobalSearchScope)scope2, (Set)includingFiles);
        return (SearchScope)GlobalSearchScope.filesScope((Project)element2.getProject(), (Collection)includingFiles);
    }
}

