/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.stubs.factories;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSElementType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSDestructuringObjectImpl;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyBase;
import com.intellij.lang.javascript.psi.stubs.JSVarStatementStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSVarStatementStubImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringVisitor;
import com.intellij.lang.javascript.stubs.factories.JSStubFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubElementFactory;
import com.intellij.psi.stubs.StubElementRegistryService;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00112\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0011B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00032\u0010\u0010\n\u001a\f\u0012\u0006\b\u0001\u0012\u00020\f\u0018\u00010\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/stubs/factories/JSVarStatementStubFactory;", "Lcom/intellij/lang/javascript/stubs/factories/JSStubFactory;", "Lcom/intellij/lang/javascript/psi/stubs/JSVarStatementStub;", "Lcom/intellij/lang/javascript/psi/JSVarStatement;", "elementType", "Lcom/intellij/lang/javascript/psi/JSElementType;", "<init>", "(Lcom/intellij/lang/javascript/psi/JSElementType;)V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "shouldCreateStub", "", "node", "Lcom/intellij/lang/ASTNode;", "Companion", "intellij.javascript.psi.impl"})
public class JSVarStatementStubFactory
extends JSStubFactory<JSVarStatementStub, JSVarStatement> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public JSVarStatementStubFactory(@NotNull JSElementType<JSVarStatement> elementType) {
        Intrinsics.checkNotNullParameter(elementType, (String)"elementType");
        super(elementType);
    }

    @NotNull
    public JSVarStatementStub createStub(@NotNull JSVarStatement psi, @Nullable StubElement<? extends PsiElement> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        return new JSVarStatementStubImpl(psi, parentStub, (IElementType)this.getElementType());
    }

    public boolean shouldCreateStub(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return Companion.shouldCreateStubForVarContainer(node);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/lang/javascript/stubs/factories/JSVarStatementStubFactory$Companion;", "", "<init>", "()V", "shouldCreateStubForVarContainer", "", "node", "Lcom/intellij/lang/ASTNode;", "intellij.javascript.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nJSVarStatementStubFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSVarStatementStubFactory.kt\ncom/intellij/lang/javascript/stubs/factories/JSVarStatementStubFactory$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean shouldCreateStubForVarContainer(@NotNull ASTNode node) {
            StubElementFactory stubElementFactory;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            IElementType iElementType = node.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
            IElementType type2 = iElementType;
            if (type2 == JSStubElementTypes.DESTRUCTURING_OBJECT) {
                ASTNode[] aSTNodeArray = JSDestructuringObjectImpl.getProperties(node);
                Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getProperties(...)");
                for (ASTNode property : aSTNodeArray) {
                    ASTNode element2 = JSDestructuringPropertyBase.getDestructuringElement(property);
                    if (element2 == null || !this.shouldCreateStubForVarContainer(element2)) continue;
                    return true;
                }
            } else if (JSElementTypes.VAR_STATEMENTS.contains(type2) || JSElementTypes.DESTRUCTURING_CONTAINERS.contains(type2) || JSExtendedLanguagesTokenSetProvider.DESTRUCTURING_ELEMENTS.contains(type2) || JSStubElementTypes.DESTRUCTURING_ARRAY_REST == type2) {
                ASTNode[] aSTNodeArray = node.getChildren(JSDestructuringVisitor.VAR_AND_CONTAINERS);
                Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
                for (ASTNode child : aSTNodeArray) {
                    Intrinsics.checkNotNull((Object)child);
                    if (!this.shouldCreateStubForVarContainer(child)) continue;
                    return true;
                }
            } else if (JSExtendedLanguagesTokenSetProvider.VARIABLES.contains(type2) && (stubElementFactory = StubElementRegistryService.Companion.getInstance().getStubFactory(type2)) != null) {
                StubElementFactory it = stubElementFactory;
                boolean bl = false;
                return it.shouldCreateStub(node);
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

