/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.patch.BlobIndexUtil;
import com.intellij.openapi.vcs.history.ShortVcsRevisionNumber;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import java.util.Date;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitRevisionNumber
implements ShortVcsRevisionNumber {
    public static final String NOT_COMMITTED_HASH = BlobIndexUtil.NOT_COMMITTED_HASH;
    public static final GitRevisionNumber HEAD = new GitRevisionNumber("HEAD");
    @NotNull
    private final String myRevisionHash;
    @NotNull
    private final Date myTimestamp;
    private static final Logger LOG = Logger.getInstance(GitRevisionNumber.class);

    public GitRevisionNumber(@NonNls @NotNull String version) {
        if (version == null) {
            GitRevisionNumber.$$$reportNull$$$0(0);
        }
        this.myRevisionHash = version;
        this.myTimestamp = new Date();
    }

    public GitRevisionNumber(@NotNull String version, @NotNull Date timeStamp) {
        if (version == null) {
            GitRevisionNumber.$$$reportNull$$$0(1);
        }
        if (timeStamp == null) {
            GitRevisionNumber.$$$reportNull$$$0(2);
        }
        this.myTimestamp = timeStamp;
        this.myRevisionHash = version;
    }

    @NotNull
    public String asString() {
        String string = this.myRevisionHash;
        if (string == null) {
            GitRevisionNumber.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String toShortString() {
        return DvcsUtil.getShortHash((String)this.myRevisionHash);
    }

    @NotNull
    public Date getTimestamp() {
        Date date = this.myTimestamp;
        if (date == null) {
            GitRevisionNumber.$$$reportNull$$$0(4);
        }
        return date;
    }

    @NotNull
    public String getRev() {
        String string = this.myRevisionHash;
        if (string == null) {
            GitRevisionNumber.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getShortRev() {
        String string = this.toShortString();
        if (string == null) {
            GitRevisionNumber.$$$reportNull$$$0(6);
        }
        return string;
    }

    public int compareTo(VcsRevisionNumber crev) {
        if (this == crev) {
            return 0;
        }
        if (crev instanceof GitRevisionNumber) {
            int tildeIndex;
            GitRevisionNumber other = (GitRevisionNumber)crev;
            if (this.myRevisionHash.equals(other.myRevisionHash)) {
                return 0;
            }
            if (other.myRevisionHash.indexOf("[") > 0) {
                return this.myTimestamp.compareTo(other.myTimestamp);
            }
            String otherName = null;
            String thisName = null;
            int otherParents = -1;
            int thisParent = -1;
            if (other.myRevisionHash.contains("~")) {
                tildeIndex = other.myRevisionHash.indexOf(126);
                otherName = other.myRevisionHash.substring(0, tildeIndex);
                otherParents = Integer.parseInt(other.myRevisionHash.substring(tildeIndex));
            }
            if (this.myRevisionHash.contains("~")) {
                tildeIndex = this.myRevisionHash.indexOf(126);
                thisName = this.myRevisionHash.substring(0, tildeIndex);
                thisParent = Integer.parseInt(this.myRevisionHash.substring(tildeIndex));
            }
            if (otherName == null && thisName == null) {
                int result2 = this.myTimestamp.compareTo(other.myTimestamp);
                if (result2 == 0) {
                    return this.myRevisionHash.compareTo(other.myRevisionHash);
                }
                return result2;
            }
            if (otherName == null) {
                return 1;
            }
            if (thisName == null) {
                return -1;
            }
            return thisParent - otherParents;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitRevisionNumber test = (GitRevisionNumber)obj;
        return this.myRevisionHash.equals(test.myRevisionHash);
    }

    public int hashCode() {
        return this.myRevisionHash.hashCode();
    }

    @NotNull
    public static GitRevisionNumber resolve(Project project, VirtualFile vcsRoot, @NonNls String rev) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, vcsRoot, GitCommand.REV_LIST);
        h.setSilent(true);
        h.addParameters("--timestamp", "--max-count=1", rev);
        h.endOptions();
        String output2 = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        return GitRevisionNumber.parseRevlistOutputAsRevisionNumber(h, output2);
    }

    @NotNull
    public static GitRevisionNumber parseRevlistOutputAsRevisionNumber(@NotNull GitHandler h, @NotNull String output2) throws VcsException {
        if (h == null) {
            GitRevisionNumber.$$$reportNull$$$0(7);
        }
        if (output2 == null) {
            GitRevisionNumber.$$$reportNull$$$0(8);
        }
        try {
            StringTokenizer tokenizer = new StringTokenizer(output2, "\n\r \t", false);
            LOG.assertTrue(tokenizer.hasMoreTokens(), (Object)("No required tokens in the output: \n" + output2));
            Date timestamp = GitUtil.parseTimestampWithNFEReport(tokenizer.nextToken(), h, output2);
            return new GitRevisionNumber(tokenizer.nextToken(), timestamp);
        }
        catch (Exception e) {
            throw new VcsException(GitBundle.message((String)"revision.number.cannot.parse.output", (Object[])new Object[]{output2}), (Throwable)e);
        }
    }

    public String toString() {
        return this.myRevisionHash;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeStamp";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitRevisionNumber";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "h";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitRevisionNumber";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimestamp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRev";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortRev";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseRevlistOutputAsRevisionNumber";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

