import React from 'react';
import { Message } from './Message';
import { useConfig, useSpec } from '../../contexts';
import { CommonHelpers } from '../../helpers';
import { MESSAGES_TEXT } from '../../constants';
export var Messages = function () {
    var asyncapi = useSpec();
    var config = useConfig();
    var messages = !asyncapi.components().isEmpty() && asyncapi.components().messages().all();
    if (!messages || messages.length === 0) {
        return null;
    }
    return (React.createElement("section", { id: "".concat(CommonHelpers.getIdentifier('messages', config)), className: "mt-16" },
        React.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, MESSAGES_TEXT),
        React.createElement("ul", null, messages.map(function (message, idx) {
            var _a, _b;
            return (React.createElement("li", { className: "mb-4", key: message.id(), id: CommonHelpers.getIdentifier("message-".concat(message.id()), config) },
                React.createElement(Message, { messageName: message.id(), message: message, index: idx + 1, key: message.id(), showExamples: (_b = (_a = config === null || config === void 0 ? void 0 : config.show) === null || _a === void 0 ? void 0 : _a.messageExamples) !== null && _b !== void 0 ? _b : false })));
        }))));
};
//# sourceMappingURL=Messages.js.map