//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uikey?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UIKey;
);

extern_conformance!(
    unsafe impl NSCoding for UIKey {}
);

extern_conformance!(
    unsafe impl NSCopying for UIKey {}
);

unsafe impl CopyingHelper for UIKey {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UIKey {}
);

impl UIKey {
    extern_methods!(
        /// Returns: a string representing what would be inserted into a text field when this key is pressed.
        ///
        /// if a modifier key is held, this property will contain the modified characters according
        /// the rules for that particular modifier key (i.e., if shift is held on a Latin keyboard, this will
        /// contain capital letters).
        #[unsafe(method(characters))]
        #[unsafe(method_family = none)]
        pub fn characters(&self) -> Retained<NSString>;

        /// Returns: a string representing which characters would be inserted into a text field when this key is
        /// pressed, not taking any held modifiers into account.
        ///
        /// for Latin based languages, expect this to be always in lowercase (unmodified meaning not
        /// taking shift key into account). If only a modifier key was pressed, this property will contain an empty string.
        #[unsafe(method(charactersIgnoringModifiers))]
        #[unsafe(method_family = none)]
        pub fn charactersIgnoringModifiers(&self) -> Retained<NSString>;

        #[cfg(feature = "UICommand")]
        /// Returns: a bitfield representing which modifier keys are currently being held in addition to this key.
        #[unsafe(method(modifierFlags))]
        #[unsafe(method_family = none)]
        pub fn modifierFlags(&self) -> UIKeyModifierFlags;

        #[cfg(all(feature = "UIKeyConstants", feature = "objc2-core-foundation"))]
        /// Returns: the raw HID usage code for the pressed key. See UIKeyConstants.h.
        #[unsafe(method(keyCode))]
        #[unsafe(method_family = none)]
        pub fn keyCode(&self) -> UIKeyboardHIDUsage;
    );
}

/// Methods declared on superclass `NSObject`.
impl UIKey {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}
