/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.collaboration.file.codereview.CodeReviewDiffVirtualFile;
import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.editor.ComplexPathVirtualFileSystem;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHNewPRDiffVirtualFileKt;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRConnectedProjectViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRProjectViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.diff.GHPRDiffService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\f\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\u0012\u0010\u0011\u001a\f0\u0004\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\t\u0010\u001a\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c2\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c2\u0003J'\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\u0004H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHNewPRDiffVirtualFile;", "Lcom/intellij/collaboration/file/codereview/CodeReviewDiffVirtualFile;", "Lorg/jetbrains/plugins/github/pullrequest/GHPRVirtualFile;", "fileManagerId", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "getFileManagerId", "()Ljava/lang/String;", "getFileSystem", "Lcom/intellij/vcs/editor/ComplexPathVirtualFileSystem;", "getPath", "getPresentablePath", "getPresentableName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "isValid", "", "createViewer", "Lcom/intellij/diff/impl/DiffEditorViewer;", "findProjectVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHPRConnectedProjectViewModel;", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHNewPRDiffVirtualFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHNewPRDiffVirtualFile.kt\norg/jetbrains/plugins/github/pullrequest/GHNewPRDiffVirtualFile\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,56:1\n30#2,2:57\n30#2,2:59\n1#3:61\n14#4:62\n14#4:63\n*S KotlinDebug\n*F\n+ 1 GHNewPRDiffVirtualFile.kt\norg/jetbrains/plugins/github/pullrequest/GHNewPRDiffVirtualFile\n*L\n33#1:57,2\n39#1:59,2\n42#1:62\n46#1:63\n*E\n"})
public final class GHNewPRDiffVirtualFile
extends CodeReviewDiffVirtualFile
implements GHPRVirtualFile {
    @NotNull
    private final String fileManagerId;
    @NotNull
    private final Project project;
    @NotNull
    private final GHRepositoryCoordinates repository;

    public GHNewPRDiffVirtualFile(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        super(GHNewPRDiffVirtualFileKt.access$getFileName());
        this.fileManagerId = fileManagerId;
        this.project = project;
        this.repository = repository;
    }

    @Override
    @NotNull
    public String getFileManagerId() {
        return this.fileManagerId;
    }

    @NotNull
    public ComplexPathVirtualFileSystem<?> getFileSystem() {
        return GHPRVirtualFileSystem.Companion.getInstance();
    }

    @NotNull
    public String getPath() {
        ComplexPathVirtualFileSystem<?> complexPathVirtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull(complexPathVirtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem");
        return ((GHPRVirtualFileSystem)complexPathVirtualFileSystem).getPath(this.getFileManagerId(), this.project, this.repository, null, true);
    }

    @NotNull
    public String getPresentablePath() {
        return GHNewPRDiffVirtualFileKt.access$getPresentablePath(this.repository);
    }

    @NotNull
    public String getPresentableName() {
        String string = GithubBundle.message("pull.request.new.diff.editor.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isValid() {
        return this.findProjectVm() != null;
    }

    @NotNull
    public DiffEditorViewer createViewer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GHPRDiffService> serviceClass$iv = GHPRDiffService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((GHPRDiffService)object).createGHNewPRDiffProcessor(this.repository);
    }

    private final GHPRConnectedProjectViewModel findProjectVm() {
        try {
            Object object;
            if (this.project.isDisposed()) {
                return null;
            }
            Object $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<GHPRProjectViewModel> serviceClass$iv = GHPRProjectViewModel.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            GHPRConnectedProjectViewModel gHPRConnectedProjectViewModel = (GHPRConnectedProjectViewModel)((GHPRProjectViewModel)object2).getConnectedProjectVm().getValue();
            if (gHPRConnectedProjectViewModel != null) {
                Object it = $this$service$iv = gHPRConnectedProjectViewModel;
                boolean bl = false;
                object = Intrinsics.areEqual((Object)it.getRepository(), (Object)this.repository) ? $this$service$iv : null;
            } else {
                object = null;
            }
            return object;
        }
        catch (CancellationException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GHNewPRDiffVirtualFile.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)new RuntimeException(e));
            return null;
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GHNewPRDiffVirtualFile.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public final String component1() {
        return this.fileManagerId;
    }

    private final Project component2() {
        return this.project;
    }

    private final GHRepositoryCoordinates component3() {
        return this.repository;
    }

    @NotNull
    public final GHNewPRDiffVirtualFile copy(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        return new GHNewPRDiffVirtualFile(fileManagerId, project, repository);
    }

    public static /* synthetic */ GHNewPRDiffVirtualFile copy$default(GHNewPRDiffVirtualFile gHNewPRDiffVirtualFile, String string, Project project, GHRepositoryCoordinates gHRepositoryCoordinates, int n, Object object) {
        if ((n & 1) != 0) {
            string = gHNewPRDiffVirtualFile.fileManagerId;
        }
        if ((n & 2) != 0) {
            project = gHNewPRDiffVirtualFile.project;
        }
        if ((n & 4) != 0) {
            gHRepositoryCoordinates = gHNewPRDiffVirtualFile.repository;
        }
        return gHNewPRDiffVirtualFile.copy(string, project, gHRepositoryCoordinates);
    }

    @NotNull
    public String toString() {
        return "GHNewPRDiffVirtualFile(fileManagerId=" + this.fileManagerId + ", project=" + this.project + ", repository=" + this.repository + ")";
    }

    public int hashCode() {
        int result = this.fileManagerId.hashCode();
        result = result * 31 + this.project.hashCode();
        result = result * 31 + this.repository.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHNewPRDiffVirtualFile)) {
            return false;
        }
        GHNewPRDiffVirtualFile gHNewPRDiffVirtualFile = (GHNewPRDiffVirtualFile)other;
        if (!Intrinsics.areEqual((Object)this.fileManagerId, (Object)gHNewPRDiffVirtualFile.fileManagerId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.project, (Object)gHNewPRDiffVirtualFile.project)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.repository, (Object)gHNewPRDiffVirtualFile.repository);
    }
}

