/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.teststubs.osgi.support;

import java.util.Dictionary;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.virgo.teststubs.osgi.internal.Assert;
import org.eclipse.virgo.teststubs.osgi.support.AbstractFilter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class PropertiesFilter
extends AbstractFilter {
    private static final String FILTER_STRING_FORMAT = "(%s=%s)";
    private static final Pattern PROPERTIES_PATTERN = Pattern.compile("\\(([^=&\\(\\)]*)=([^=&\\(\\)]*)\\)");
    private final Map<String, Object> properties;

    public PropertiesFilter(Map<String, Object> properties) {
        Assert.assertNotNull(properties, "properties");
        this.properties = properties;
    }

    public PropertiesFilter(String filterString) throws InvalidSyntaxException {
        Assert.assertNotNull(filterString, filterString);
        this.properties = this.parseFilterString(filterString);
    }

    public boolean match(ServiceReference<?> reference) {
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Object value = reference.getProperty(entry.getKey());
            if (value != null && value.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean match(Dictionary<String, ?> dictionary) {
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Object value = dictionary.get(entry.getKey());
            if (value != null && value.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean matchCase(Dictionary<String, ?> dictionary) {
        return this.match(dictionary);
    }

    @Override
    public String getFilterString() {
        if (this.properties.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            sb.append(String.format(FILTER_STRING_FORMAT, entry.getKey(), entry.getValue()));
        }
        if (this.properties.size() > 1) {
            sb.insert(0, "(&");
            sb.append(")");
        }
        return sb.toString();
    }

    private Map<String, Object> parseFilterString(String filterString) throws InvalidSyntaxException {
        TreeMap<String, Object> properties = new TreeMap<String, Object>();
        Matcher matcher = PROPERTIES_PATTERN.matcher(filterString);
        while (matcher.find()) {
            properties.put(matcher.group(1), matcher.group(2));
        }
        return properties;
    }

    public boolean matches(Map<String, ?> map) {
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Object value = map.get(entry.getKey());
            if (value != null && value.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

