//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;
#[cfg(feature = "objc2-quartz-core")]
#[cfg(not(target_os = "watchos"))]
use objc2_quartz_core::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicontentinsetsreference?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIContentInsetsReference(pub NSInteger);
impl UIContentInsetsReference {
    #[doc(alias = "UIContentInsetsReferenceAutomatic")]
    pub const Automatic: Self = Self(0);
    #[doc(alias = "UIContentInsetsReferenceNone")]
    pub const None: Self = Self(1);
    #[doc(alias = "UIContentInsetsReferenceSafeArea")]
    pub const SafeArea: Self = Self(2);
    #[doc(alias = "UIContentInsetsReferenceLayoutMargins")]
    pub const LayoutMargins: Self = Self(3);
    #[doc(alias = "UIContentInsetsReferenceReadableContent")]
    pub const ReadableContent: Self = Self(4);
}

unsafe impl Encode for UIContentInsetsReference {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIContentInsetsReference {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicollectionviewcompositionallayoutconfiguration?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICollectionViewCompositionalLayoutConfiguration;
);

extern_conformance!(
    unsafe impl NSCopying for UICollectionViewCompositionalLayoutConfiguration {}
);

unsafe impl CopyingHelper for UICollectionViewCompositionalLayoutConfiguration {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICollectionViewCompositionalLayoutConfiguration {}
);

impl UICollectionViewCompositionalLayoutConfiguration {
    extern_methods!(
        #[cfg(feature = "UICollectionViewLayout")]
        #[unsafe(method(scrollDirection))]
        #[unsafe(method_family = none)]
        pub unsafe fn scrollDirection(&self) -> UICollectionViewScrollDirection;

        #[cfg(feature = "UICollectionViewLayout")]
        /// Setter for [`scrollDirection`][Self::scrollDirection].
        #[unsafe(method(setScrollDirection:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setScrollDirection(&self, scroll_direction: UICollectionViewScrollDirection);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(interSectionSpacing))]
        #[unsafe(method_family = none)]
        pub unsafe fn interSectionSpacing(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`interSectionSpacing`][Self::interSectionSpacing].
        #[unsafe(method(setInterSectionSpacing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInterSectionSpacing(&self, inter_section_spacing: CGFloat);

        #[unsafe(method(boundarySupplementaryItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn boundarySupplementaryItems(
            &self,
        ) -> Retained<NSArray<NSCollectionLayoutBoundarySupplementaryItem>>;

        /// Setter for [`boundarySupplementaryItems`][Self::boundarySupplementaryItems].
        #[unsafe(method(setBoundarySupplementaryItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBoundarySupplementaryItems(
            &self,
            boundary_supplementary_items: &NSArray<NSCollectionLayoutBoundarySupplementaryItem>,
        );

        #[unsafe(method(contentInsetsReference))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentInsetsReference(&self) -> UIContentInsetsReference;

        /// Setter for [`contentInsetsReference`][Self::contentInsetsReference].
        #[unsafe(method(setContentInsetsReference:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContentInsetsReference(
            &self,
            content_insets_reference: UIContentInsetsReference,
        );
    );
}

/// Methods declared on superclass `NSObject`.
impl UICollectionViewCompositionalLayoutConfiguration {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicollectionviewcompositionallayoutsectionprovider?language=objc)
#[cfg(feature = "block2")]
pub type UICollectionViewCompositionalLayoutSectionProvider = *mut block2::DynBlock<
    dyn Fn(
        NSInteger,
        NonNull<ProtocolObject<dyn NSCollectionLayoutEnvironment>>,
    ) -> *mut NSCollectionLayoutSection,
>;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicollectionviewcompositionallayout?language=objc)
    #[unsafe(super(UICollectionViewLayout, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UICollectionViewLayout")]
    pub struct UICollectionViewCompositionalLayout;
);

#[cfg(feature = "UICollectionViewLayout")]
extern_conformance!(
    unsafe impl NSCoding for UICollectionViewCompositionalLayout {}
);

#[cfg(feature = "UICollectionViewLayout")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UICollectionViewCompositionalLayout {}
);

#[cfg(feature = "UICollectionViewLayout")]
impl UICollectionViewCompositionalLayout {
    extern_methods!(
        #[unsafe(method(initWithSection:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithSection(
            this: Allocated<Self>,
            section: &NSCollectionLayoutSection,
        ) -> Retained<Self>;

        #[unsafe(method(initWithSection:configuration:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithSection_configuration(
            this: Allocated<Self>,
            section: &NSCollectionLayoutSection,
            configuration: &UICollectionViewCompositionalLayoutConfiguration,
        ) -> Retained<Self>;

        #[cfg(feature = "block2")]
        #[unsafe(method(initWithSectionProvider:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithSectionProvider(
            this: Allocated<Self>,
            section_provider: UICollectionViewCompositionalLayoutSectionProvider,
        ) -> Retained<Self>;

        #[cfg(feature = "block2")]
        #[unsafe(method(initWithSectionProvider:configuration:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithSectionProvider_configuration(
            this: Allocated<Self>,
            section_provider: UICollectionViewCompositionalLayoutSectionProvider,
            configuration: &UICollectionViewCompositionalLayoutConfiguration,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(configuration))]
        #[unsafe(method_family = none)]
        pub unsafe fn configuration(
            &self,
        ) -> Retained<UICollectionViewCompositionalLayoutConfiguration>;

        /// Setter for [`configuration`][Self::configuration].
        #[unsafe(method(setConfiguration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setConfiguration(
            &self,
            configuration: &UICollectionViewCompositionalLayoutConfiguration,
        );
    );
}

/// Methods declared on superclass `UICollectionViewLayout`.
#[cfg(feature = "UICollectionViewLayout")]
impl UICollectionViewCompositionalLayout {
    extern_methods!(
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicollectionlayoutsectionorthogonalscrollingbehavior?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UICollectionLayoutSectionOrthogonalScrollingBehavior(pub NSInteger);
impl UICollectionLayoutSectionOrthogonalScrollingBehavior {
    #[doc(alias = "UICollectionLayoutSectionOrthogonalScrollingBehaviorNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "UICollectionLayoutSectionOrthogonalScrollingBehaviorContinuous")]
    pub const Continuous: Self = Self(1);
    #[doc(
        alias = "UICollectionLayoutSectionOrthogonalScrollingBehaviorContinuousGroupLeadingBoundary"
    )]
    pub const ContinuousGroupLeadingBoundary: Self = Self(2);
    #[doc(alias = "UICollectionLayoutSectionOrthogonalScrollingBehaviorPaging")]
    pub const Paging: Self = Self(3);
    #[doc(alias = "UICollectionLayoutSectionOrthogonalScrollingBehaviorGroupPaging")]
    pub const GroupPaging: Self = Self(4);
    #[doc(alias = "UICollectionLayoutSectionOrthogonalScrollingBehaviorGroupPagingCentered")]
    pub const GroupPagingCentered: Self = Self(5);
}

unsafe impl Encode for UICollectionLayoutSectionOrthogonalScrollingBehavior {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UICollectionLayoutSectionOrthogonalScrollingBehavior {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutsectionvisibleitemsinvalidationhandler?language=objc)
#[cfg(all(
    feature = "UIDynamicBehavior",
    feature = "block2",
    feature = "objc2-core-foundation"
))]
pub type NSCollectionLayoutSectionVisibleItemsInvalidationHandler = *mut block2::DynBlock<
    dyn Fn(
        NonNull<NSArray<ProtocolObject<dyn NSCollectionLayoutVisibleItem>>>,
        CGPoint,
        NonNull<ProtocolObject<dyn NSCollectionLayoutEnvironment>>,
    ),
>;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicollectionlayoutsectionorthogonalscrollingdecelerationrate?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "objc2-core-foundation")]
pub type UICollectionLayoutSectionOrthogonalScrollingDecelerationRate = CGFloat;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicollectionlayoutsectionorthogonalscrollingdecelerationrateautomatic?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UICollectionLayoutSectionOrthogonalScrollingDecelerationRateAutomatic:
        UICollectionLayoutSectionOrthogonalScrollingDecelerationRate;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicollectionlayoutsectionorthogonalscrollingdecelerationratenormal?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UICollectionLayoutSectionOrthogonalScrollingDecelerationRateNormal:
        UICollectionLayoutSectionOrthogonalScrollingDecelerationRate;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicollectionlayoutsectionorthogonalscrollingdecelerationratefast?language=objc)
    #[cfg(feature = "objc2-core-foundation")]
    pub static UICollectionLayoutSectionOrthogonalScrollingDecelerationRateFast:
        UICollectionLayoutSectionOrthogonalScrollingDecelerationRate;
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicollectionlayoutsectionorthogonalscrollingbounce?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UICollectionLayoutSectionOrthogonalScrollingBounce(pub NSInteger);
impl UICollectionLayoutSectionOrthogonalScrollingBounce {
    #[doc(alias = "UICollectionLayoutSectionOrthogonalScrollingBounceAutomatic")]
    pub const Automatic: Self = Self(0);
    #[doc(alias = "UICollectionLayoutSectionOrthogonalScrollingBounceAlways")]
    pub const Always: Self = Self(1);
    #[doc(alias = "UICollectionLayoutSectionOrthogonalScrollingBounceNever")]
    pub const Never: Self = Self(2);
}

unsafe impl Encode for UICollectionLayoutSectionOrthogonalScrollingBounce {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UICollectionLayoutSectionOrthogonalScrollingBounce {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uicollectionlayoutsectionorthogonalscrollingproperties?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct UICollectionLayoutSectionOrthogonalScrollingProperties;
);

extern_conformance!(
    unsafe impl NSCopying for UICollectionLayoutSectionOrthogonalScrollingProperties {}
);

unsafe impl CopyingHelper for UICollectionLayoutSectionOrthogonalScrollingProperties {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for UICollectionLayoutSectionOrthogonalScrollingProperties {}
);

impl UICollectionLayoutSectionOrthogonalScrollingProperties {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        /// The orthogonal scroll view's rate of deceleration after the user lifts their finger.
        #[unsafe(method(decelerationRate))]
        #[unsafe(method_family = none)]
        pub unsafe fn decelerationRate(
            &self,
        ) -> UICollectionLayoutSectionOrthogonalScrollingDecelerationRate;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`decelerationRate`][Self::decelerationRate].
        #[unsafe(method(setDecelerationRate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDecelerationRate(
            &self,
            deceleration_rate: UICollectionLayoutSectionOrthogonalScrollingDecelerationRate,
        );

        /// The orthogonal scroll view's bounce behavior.
        #[unsafe(method(bounce))]
        #[unsafe(method_family = none)]
        pub unsafe fn bounce(&self) -> UICollectionLayoutSectionOrthogonalScrollingBounce;

        /// Setter for [`bounce`][Self::bounce].
        #[unsafe(method(setBounce:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBounce(&self, bounce: UICollectionLayoutSectionOrthogonalScrollingBounce);
    );
}

/// Methods declared on superclass `NSObject`.
impl UICollectionLayoutSectionOrthogonalScrollingProperties {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutsection?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCollectionLayoutSection;
);

extern_conformance!(
    unsafe impl NSCopying for NSCollectionLayoutSection {}
);

unsafe impl CopyingHelper for NSCollectionLayoutSection {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionLayoutSection {}
);

impl NSCollectionLayoutSection {
    extern_methods!(
        #[unsafe(method(sectionWithGroup:))]
        #[unsafe(method_family = none)]
        pub unsafe fn sectionWithGroup(group: &NSCollectionLayoutGroup) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(contentInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentInsets(&self) -> NSDirectionalEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`contentInsets`][Self::contentInsets].
        #[unsafe(method(setContentInsets:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContentInsets(&self, content_insets: NSDirectionalEdgeInsets);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(interGroupSpacing))]
        #[unsafe(method_family = none)]
        pub unsafe fn interGroupSpacing(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`interGroupSpacing`][Self::interGroupSpacing].
        #[unsafe(method(setInterGroupSpacing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInterGroupSpacing(&self, inter_group_spacing: CGFloat);

        #[unsafe(method(contentInsetsReference))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentInsetsReference(&self) -> UIContentInsetsReference;

        /// Setter for [`contentInsetsReference`][Self::contentInsetsReference].
        #[unsafe(method(setContentInsetsReference:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContentInsetsReference(
            &self,
            content_insets_reference: UIContentInsetsReference,
        );

        /// Specifies the content insets reference for boundary supplementaries in this section.
        /// The default value of this property is UIContentInsetsReference.automatic, which means that any insets specified on a
        /// `NSCollectionLayoutBoundarySupplementaryItem`will follow the layout configuration's
        /// `contentInsetsReference.`
        #[unsafe(method(supplementaryContentInsetsReference))]
        #[unsafe(method_family = none)]
        pub unsafe fn supplementaryContentInsetsReference(&self) -> UIContentInsetsReference;

        /// Setter for [`supplementaryContentInsetsReference`][Self::supplementaryContentInsetsReference].
        #[unsafe(method(setSupplementaryContentInsetsReference:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSupplementaryContentInsetsReference(
            &self,
            supplementary_content_insets_reference: UIContentInsetsReference,
        );

        #[unsafe(method(orthogonalScrollingBehavior))]
        #[unsafe(method_family = none)]
        pub unsafe fn orthogonalScrollingBehavior(
            &self,
        ) -> UICollectionLayoutSectionOrthogonalScrollingBehavior;

        /// Setter for [`orthogonalScrollingBehavior`][Self::orthogonalScrollingBehavior].
        #[unsafe(method(setOrthogonalScrollingBehavior:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setOrthogonalScrollingBehavior(
            &self,
            orthogonal_scrolling_behavior: UICollectionLayoutSectionOrthogonalScrollingBehavior,
        );

        #[unsafe(method(orthogonalScrollingProperties))]
        #[unsafe(method_family = none)]
        pub unsafe fn orthogonalScrollingProperties(
            &self,
        ) -> Retained<UICollectionLayoutSectionOrthogonalScrollingProperties>;

        #[unsafe(method(boundarySupplementaryItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn boundarySupplementaryItems(
            &self,
        ) -> Retained<NSArray<NSCollectionLayoutBoundarySupplementaryItem>>;

        /// Setter for [`boundarySupplementaryItems`][Self::boundarySupplementaryItems].
        #[unsafe(method(setBoundarySupplementaryItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBoundarySupplementaryItems(
            &self,
            boundary_supplementary_items: &NSArray<NSCollectionLayoutBoundarySupplementaryItem>,
        );

        #[cfg(all(
            feature = "UIDynamicBehavior",
            feature = "block2",
            feature = "objc2-core-foundation"
        ))]
        #[unsafe(method(visibleItemsInvalidationHandler))]
        #[unsafe(method_family = none)]
        pub unsafe fn visibleItemsInvalidationHandler(
            &self,
        ) -> NSCollectionLayoutSectionVisibleItemsInvalidationHandler;

        #[cfg(all(
            feature = "UIDynamicBehavior",
            feature = "block2",
            feature = "objc2-core-foundation"
        ))]
        /// Setter for [`visibleItemsInvalidationHandler`][Self::visibleItemsInvalidationHandler].
        #[unsafe(method(setVisibleItemsInvalidationHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setVisibleItemsInvalidationHandler(
            &self,
            visible_items_invalidation_handler: NSCollectionLayoutSectionVisibleItemsInvalidationHandler,
        );

        #[unsafe(method(decorationItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn decorationItems(&self)
            -> Retained<NSArray<NSCollectionLayoutDecorationItem>>;

        /// Setter for [`decorationItems`][Self::decorationItems].
        #[unsafe(method(setDecorationItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDecorationItems(
            &self,
            decoration_items: &NSArray<NSCollectionLayoutDecorationItem>,
        );
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutitem?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCollectionLayoutItem;
);

extern_conformance!(
    unsafe impl NSCopying for NSCollectionLayoutItem {}
);

unsafe impl CopyingHelper for NSCollectionLayoutItem {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionLayoutItem {}
);

impl NSCollectionLayoutItem {
    extern_methods!(
        #[unsafe(method(itemWithLayoutSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemWithLayoutSize(layout_size: &NSCollectionLayoutSize) -> Retained<Self>;

        #[unsafe(method(itemWithLayoutSize:supplementaryItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemWithLayoutSize_supplementaryItems(
            layout_size: &NSCollectionLayoutSize,
            supplementary_items: &NSArray<NSCollectionLayoutSupplementaryItem>,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(contentInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentInsets(&self) -> NSDirectionalEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        /// Setter for [`contentInsets`][Self::contentInsets].
        #[unsafe(method(setContentInsets:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContentInsets(&self, content_insets: NSDirectionalEdgeInsets);

        #[unsafe(method(edgeSpacing))]
        #[unsafe(method_family = none)]
        pub unsafe fn edgeSpacing(&self) -> Option<Retained<NSCollectionLayoutEdgeSpacing>>;

        /// Setter for [`edgeSpacing`][Self::edgeSpacing].
        #[unsafe(method(setEdgeSpacing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setEdgeSpacing(&self, edge_spacing: Option<&NSCollectionLayoutEdgeSpacing>);

        #[unsafe(method(layoutSize))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutSize(&self) -> Retained<NSCollectionLayoutSize>;

        #[unsafe(method(supplementaryItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn supplementaryItems(
            &self,
        ) -> Retained<NSArray<NSCollectionLayoutSupplementaryItem>>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutgroupcustomitem?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCollectionLayoutGroupCustomItem;
);

extern_conformance!(
    unsafe impl NSCopying for NSCollectionLayoutGroupCustomItem {}
);

unsafe impl CopyingHelper for NSCollectionLayoutGroupCustomItem {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionLayoutGroupCustomItem {}
);

impl NSCollectionLayoutGroupCustomItem {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(customItemWithFrame:))]
        #[unsafe(method_family = none)]
        pub unsafe fn customItemWithFrame(frame: CGRect, mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(customItemWithFrame:zIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn customItemWithFrame_zIndex(
            frame: CGRect,
            z_index: NSInteger,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(frame))]
        #[unsafe(method_family = none)]
        pub unsafe fn frame(&self) -> CGRect;

        #[unsafe(method(zIndex))]
        #[unsafe(method_family = none)]
        pub unsafe fn zIndex(&self) -> NSInteger;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutgroupcustomitemprovider?language=objc)
#[cfg(feature = "block2")]
pub type NSCollectionLayoutGroupCustomItemProvider = *mut block2::DynBlock<
    dyn Fn(
        NonNull<ProtocolObject<dyn NSCollectionLayoutEnvironment>>,
    ) -> NonNull<NSArray<NSCollectionLayoutGroupCustomItem>>,
>;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutgroup?language=objc)
    #[unsafe(super(NSCollectionLayoutItem, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCollectionLayoutGroup;
);

extern_conformance!(
    unsafe impl NSCopying for NSCollectionLayoutGroup {}
);

unsafe impl CopyingHelper for NSCollectionLayoutGroup {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionLayoutGroup {}
);

impl NSCollectionLayoutGroup {
    extern_methods!(
        /// Specifies a group that will horizontally repeat its subitem a fixed number of times.
        ///
        /// Parameter `layoutSize`: The group's size.
        ///
        /// Parameter `subitem`: The subitem to repeat. It is the caller's responsibility to ensure that the group's
        /// `layoutSize`can fit
        /// `count`repetitions of this item.
        ///
        /// Parameter `count`: The number of times to repeat the passed in subitem.
        #[unsafe(method(horizontalGroupWithLayoutSize:repeatingSubitem:count:))]
        #[unsafe(method_family = none)]
        pub unsafe fn horizontalGroupWithLayoutSize_repeatingSubitem_count(
            layout_size: &NSCollectionLayoutSize,
            subitem: &NSCollectionLayoutItem,
            count: NSInteger,
        ) -> Retained<Self>;

        #[unsafe(method(horizontalGroupWithLayoutSize:subitems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn horizontalGroupWithLayoutSize_subitems(
            layout_size: &NSCollectionLayoutSize,
            subitems: &NSArray<NSCollectionLayoutItem>,
        ) -> Retained<Self>;

        /// Specifies a group that will vertically repeat its subitem a fixed number of times.
        ///
        /// Parameter `layoutSize`: The group's size.
        ///
        /// Parameter `subitem`: The subitem to repeat. It is the caller's responsibility to ensure that the group's
        /// `layoutSize`can fit
        /// `count`repetitions of this item.
        ///
        /// Parameter `count`: The number of times to repeat the passed in subitem.
        #[unsafe(method(verticalGroupWithLayoutSize:repeatingSubitem:count:))]
        #[unsafe(method_family = none)]
        pub unsafe fn verticalGroupWithLayoutSize_repeatingSubitem_count(
            layout_size: &NSCollectionLayoutSize,
            subitem: &NSCollectionLayoutItem,
            count: NSInteger,
        ) -> Retained<Self>;

        #[unsafe(method(verticalGroupWithLayoutSize:subitems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn verticalGroupWithLayoutSize_subitems(
            layout_size: &NSCollectionLayoutSize,
            subitems: &NSArray<NSCollectionLayoutItem>,
        ) -> Retained<Self>;

        #[cfg(feature = "block2")]
        #[unsafe(method(customGroupWithLayoutSize:itemProvider:))]
        #[unsafe(method_family = none)]
        pub unsafe fn customGroupWithLayoutSize_itemProvider(
            layout_size: &NSCollectionLayoutSize,
            item_provider: NSCollectionLayoutGroupCustomItemProvider,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(supplementaryItems))]
        #[unsafe(method_family = none)]
        pub unsafe fn supplementaryItems(
            &self,
        ) -> Retained<NSArray<NSCollectionLayoutSupplementaryItem>>;

        /// Setter for [`supplementaryItems`][Self::supplementaryItems].
        #[unsafe(method(setSupplementaryItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSupplementaryItems(
            &self,
            supplementary_items: &NSArray<NSCollectionLayoutSupplementaryItem>,
        );

        #[unsafe(method(interItemSpacing))]
        #[unsafe(method_family = none)]
        pub unsafe fn interItemSpacing(&self) -> Option<Retained<NSCollectionLayoutSpacing>>;

        /// Setter for [`interItemSpacing`][Self::interItemSpacing].
        #[unsafe(method(setInterItemSpacing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setInterItemSpacing(
            &self,
            inter_item_spacing: Option<&NSCollectionLayoutSpacing>,
        );

        #[unsafe(method(subitems))]
        #[unsafe(method_family = none)]
        pub unsafe fn subitems(&self) -> Retained<NSArray<NSCollectionLayoutItem>>;

        #[unsafe(method(visualDescription))]
        #[unsafe(method_family = none)]
        pub unsafe fn visualDescription(&self) -> Retained<NSString>;
    );
}

/// Methods declared on superclass `NSCollectionLayoutItem`.
impl NSCollectionLayoutGroup {
    extern_methods!(
        #[unsafe(method(itemWithLayoutSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemWithLayoutSize(layout_size: &NSCollectionLayoutSize) -> Retained<Self>;

        #[unsafe(method(itemWithLayoutSize:supplementaryItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemWithLayoutSize_supplementaryItems(
            layout_size: &NSCollectionLayoutSize,
            supplementary_items: &NSArray<NSCollectionLayoutSupplementaryItem>,
        ) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutdimension?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCollectionLayoutDimension;
);

extern_conformance!(
    unsafe impl NSCopying for NSCollectionLayoutDimension {}
);

unsafe impl CopyingHelper for NSCollectionLayoutDimension {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionLayoutDimension {}
);

impl NSCollectionLayoutDimension {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(fractionalWidthDimension:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fractionalWidthDimension(
            fractional_width: CGFloat,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(fractionalHeightDimension:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fractionalHeightDimension(
            fractional_height: CGFloat,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(absoluteDimension:))]
        #[unsafe(method_family = none)]
        pub unsafe fn absoluteDimension(
            absolute_dimension: CGFloat,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(estimatedDimension:))]
        #[unsafe(method_family = none)]
        pub unsafe fn estimatedDimension(
            estimated_dimension: CGFloat,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        /// Items with this dimension type will receive at least as much room as the view requires, and will
        /// grow to match the dimension of the largest estimated sibling in their parent.
        /// When specified on the outermost group for a section, the largest size will be shared across the entire section.
        ///
        /// Eg: All `NSCollectionLayoutItem`s specified with a `uniformAcrossSiblingsWithEstimate:` `heightDimension` in a horizontal `NSCollectionLayoutGroup`
        /// will have a height equal to the height of the tallest item in that group.
        ///
        /// When computing the size for a dimension of this type, the layout will need to retrieve preferred attributes for all siblings
        /// in its parent, which in `UICollectionView` means creating views for all dependent items. This can be very expensive, so `uniformAcrossSiblingsWithEstimate` should
        /// only be used in layouts where the number of dependent items is known to be relatively small.
        #[unsafe(method(uniformAcrossSiblingsWithEstimate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn uniformAcrossSiblingsWithEstimate(
            estimated_dimension: CGFloat,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(isFractionalWidth))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFractionalWidth(&self) -> bool;

        #[unsafe(method(isFractionalHeight))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFractionalHeight(&self) -> bool;

        #[unsafe(method(isAbsolute))]
        #[unsafe(method_family = none)]
        pub unsafe fn isAbsolute(&self) -> bool;

        /// Returns `YES` if the receiver is `estimated` OR `uniformAcrossSiblings`.
        #[unsafe(method(isEstimated))]
        #[unsafe(method_family = none)]
        pub unsafe fn isEstimated(&self) -> bool;

        #[unsafe(method(isUniformAcrossSiblings))]
        #[unsafe(method_family = none)]
        pub unsafe fn isUniformAcrossSiblings(&self) -> bool;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(dimension))]
        #[unsafe(method_family = none)]
        pub unsafe fn dimension(&self) -> CGFloat;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutsize?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCollectionLayoutSize;
);

extern_conformance!(
    unsafe impl NSCopying for NSCollectionLayoutSize {}
);

unsafe impl CopyingHelper for NSCollectionLayoutSize {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionLayoutSize {}
);

impl NSCollectionLayoutSize {
    extern_methods!(
        #[unsafe(method(sizeWithWidthDimension:heightDimension:))]
        #[unsafe(method_family = none)]
        pub unsafe fn sizeWithWidthDimension_heightDimension(
            width: &NSCollectionLayoutDimension,
            height: &NSCollectionLayoutDimension,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(widthDimension))]
        #[unsafe(method_family = none)]
        pub unsafe fn widthDimension(&self) -> Retained<NSCollectionLayoutDimension>;

        #[unsafe(method(heightDimension))]
        #[unsafe(method_family = none)]
        pub unsafe fn heightDimension(&self) -> Retained<NSCollectionLayoutDimension>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutspacing?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCollectionLayoutSpacing;
);

extern_conformance!(
    unsafe impl NSCopying for NSCollectionLayoutSpacing {}
);

unsafe impl CopyingHelper for NSCollectionLayoutSpacing {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionLayoutSpacing {}
);

impl NSCollectionLayoutSpacing {
    extern_methods!(
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(flexibleSpacing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn flexibleSpacing(
            flexible_spacing: CGFloat,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(fixedSpacing:))]
        #[unsafe(method_family = none)]
        pub unsafe fn fixedSpacing(fixed_spacing: CGFloat, mtm: MainThreadMarker)
            -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(spacing))]
        #[unsafe(method_family = none)]
        pub unsafe fn spacing(&self) -> CGFloat;

        #[unsafe(method(isFlexibleSpacing))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFlexibleSpacing(&self) -> bool;

        #[unsafe(method(isFixedSpacing))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFixedSpacing(&self) -> bool;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutedgespacing?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCollectionLayoutEdgeSpacing;
);

extern_conformance!(
    unsafe impl NSCopying for NSCollectionLayoutEdgeSpacing {}
);

unsafe impl CopyingHelper for NSCollectionLayoutEdgeSpacing {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionLayoutEdgeSpacing {}
);

impl NSCollectionLayoutEdgeSpacing {
    extern_methods!(
        #[unsafe(method(spacingForLeading:top:trailing:bottom:))]
        #[unsafe(method_family = none)]
        pub unsafe fn spacingForLeading_top_trailing_bottom(
            leading: Option<&NSCollectionLayoutSpacing>,
            top: Option<&NSCollectionLayoutSpacing>,
            trailing: Option<&NSCollectionLayoutSpacing>,
            bottom: Option<&NSCollectionLayoutSpacing>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(leading))]
        #[unsafe(method_family = none)]
        pub unsafe fn leading(&self) -> Option<Retained<NSCollectionLayoutSpacing>>;

        #[unsafe(method(top))]
        #[unsafe(method_family = none)]
        pub unsafe fn top(&self) -> Option<Retained<NSCollectionLayoutSpacing>>;

        #[unsafe(method(trailing))]
        #[unsafe(method_family = none)]
        pub unsafe fn trailing(&self) -> Option<Retained<NSCollectionLayoutSpacing>>;

        #[unsafe(method(bottom))]
        #[unsafe(method_family = none)]
        pub unsafe fn bottom(&self) -> Option<Retained<NSCollectionLayoutSpacing>>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutsupplementaryitem?language=objc)
    #[unsafe(super(NSCollectionLayoutItem, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCollectionLayoutSupplementaryItem;
);

extern_conformance!(
    unsafe impl NSCopying for NSCollectionLayoutSupplementaryItem {}
);

unsafe impl CopyingHelper for NSCollectionLayoutSupplementaryItem {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionLayoutSupplementaryItem {}
);

impl NSCollectionLayoutSupplementaryItem {
    extern_methods!(
        #[unsafe(method(supplementaryItemWithLayoutSize:elementKind:containerAnchor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn supplementaryItemWithLayoutSize_elementKind_containerAnchor(
            layout_size: &NSCollectionLayoutSize,
            element_kind: &NSString,
            container_anchor: &NSCollectionLayoutAnchor,
        ) -> Retained<Self>;

        #[unsafe(method(supplementaryItemWithLayoutSize:elementKind:containerAnchor:itemAnchor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn supplementaryItemWithLayoutSize_elementKind_containerAnchor_itemAnchor(
            layout_size: &NSCollectionLayoutSize,
            element_kind: &NSString,
            container_anchor: &NSCollectionLayoutAnchor,
            item_anchor: &NSCollectionLayoutAnchor,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(zIndex))]
        #[unsafe(method_family = none)]
        pub unsafe fn zIndex(&self) -> NSInteger;

        /// Setter for [`zIndex`][Self::zIndex].
        #[unsafe(method(setZIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setZIndex(&self, z_index: NSInteger);

        #[unsafe(method(elementKind))]
        #[unsafe(method_family = none)]
        pub unsafe fn elementKind(&self) -> Retained<NSString>;

        #[unsafe(method(containerAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn containerAnchor(&self) -> Retained<NSCollectionLayoutAnchor>;

        #[unsafe(method(itemAnchor))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemAnchor(&self) -> Option<Retained<NSCollectionLayoutAnchor>>;
    );
}

/// Methods declared on superclass `NSCollectionLayoutItem`.
impl NSCollectionLayoutSupplementaryItem {
    extern_methods!(
        #[unsafe(method(itemWithLayoutSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemWithLayoutSize(layout_size: &NSCollectionLayoutSize) -> Retained<Self>;

        #[unsafe(method(itemWithLayoutSize:supplementaryItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemWithLayoutSize_supplementaryItems(
            layout_size: &NSCollectionLayoutSize,
            supplementary_items: &NSArray<NSCollectionLayoutSupplementaryItem>,
        ) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutboundarysupplementaryitem?language=objc)
    #[unsafe(super(NSCollectionLayoutSupplementaryItem, NSCollectionLayoutItem, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCollectionLayoutBoundarySupplementaryItem;
);

extern_conformance!(
    unsafe impl NSCopying for NSCollectionLayoutBoundarySupplementaryItem {}
);

unsafe impl CopyingHelper for NSCollectionLayoutBoundarySupplementaryItem {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionLayoutBoundarySupplementaryItem {}
);

impl NSCollectionLayoutBoundarySupplementaryItem {
    extern_methods!(
        #[cfg(feature = "UIGeometry")]
        #[unsafe(method(boundarySupplementaryItemWithLayoutSize:elementKind:alignment:))]
        #[unsafe(method_family = none)]
        pub unsafe fn boundarySupplementaryItemWithLayoutSize_elementKind_alignment(
            layout_size: &NSCollectionLayoutSize,
            element_kind: &NSString,
            alignment: NSRectAlignment,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(boundarySupplementaryItemWithLayoutSize:elementKind:alignment:absoluteOffset:))]
        #[unsafe(method_family = none)]
        pub unsafe fn boundarySupplementaryItemWithLayoutSize_elementKind_alignment_absoluteOffset(
            layout_size: &NSCollectionLayoutSize,
            element_kind: &NSString,
            alignment: NSRectAlignment,
            absolute_offset: CGPoint,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(extendsBoundary))]
        #[unsafe(method_family = none)]
        pub unsafe fn extendsBoundary(&self) -> bool;

        /// Setter for [`extendsBoundary`][Self::extendsBoundary].
        #[unsafe(method(setExtendsBoundary:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setExtendsBoundary(&self, extends_boundary: bool);

        #[unsafe(method(pinToVisibleBounds))]
        #[unsafe(method_family = none)]
        pub unsafe fn pinToVisibleBounds(&self) -> bool;

        /// Setter for [`pinToVisibleBounds`][Self::pinToVisibleBounds].
        #[unsafe(method(setPinToVisibleBounds:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPinToVisibleBounds(&self, pin_to_visible_bounds: bool);

        #[cfg(feature = "UIGeometry")]
        #[unsafe(method(alignment))]
        #[unsafe(method_family = none)]
        pub unsafe fn alignment(&self) -> NSRectAlignment;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(offset))]
        #[unsafe(method_family = none)]
        pub unsafe fn offset(&self) -> CGPoint;
    );
}

/// Methods declared on superclass `NSCollectionLayoutSupplementaryItem`.
impl NSCollectionLayoutBoundarySupplementaryItem {
    extern_methods!(
        #[unsafe(method(supplementaryItemWithLayoutSize:elementKind:containerAnchor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn supplementaryItemWithLayoutSize_elementKind_containerAnchor(
            layout_size: &NSCollectionLayoutSize,
            element_kind: &NSString,
            container_anchor: &NSCollectionLayoutAnchor,
        ) -> Retained<Self>;

        #[unsafe(method(supplementaryItemWithLayoutSize:elementKind:containerAnchor:itemAnchor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn supplementaryItemWithLayoutSize_elementKind_containerAnchor_itemAnchor(
            layout_size: &NSCollectionLayoutSize,
            element_kind: &NSString,
            container_anchor: &NSCollectionLayoutAnchor,
            item_anchor: &NSCollectionLayoutAnchor,
        ) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSCollectionLayoutItem`.
impl NSCollectionLayoutBoundarySupplementaryItem {
    extern_methods!(
        #[unsafe(method(itemWithLayoutSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemWithLayoutSize(layout_size: &NSCollectionLayoutSize) -> Retained<Self>;

        #[unsafe(method(itemWithLayoutSize:supplementaryItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemWithLayoutSize_supplementaryItems(
            layout_size: &NSCollectionLayoutSize,
            supplementary_items: &NSArray<NSCollectionLayoutSupplementaryItem>,
        ) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutdecorationitem?language=objc)
    #[unsafe(super(NSCollectionLayoutItem, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCollectionLayoutDecorationItem;
);

extern_conformance!(
    unsafe impl NSCopying for NSCollectionLayoutDecorationItem {}
);

unsafe impl CopyingHelper for NSCollectionLayoutDecorationItem {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionLayoutDecorationItem {}
);

impl NSCollectionLayoutDecorationItem {
    extern_methods!(
        #[unsafe(method(backgroundDecorationItemWithElementKind:))]
        #[unsafe(method_family = none)]
        pub unsafe fn backgroundDecorationItemWithElementKind(
            element_kind: &NSString,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[unsafe(method(zIndex))]
        #[unsafe(method_family = none)]
        pub unsafe fn zIndex(&self) -> NSInteger;

        /// Setter for [`zIndex`][Self::zIndex].
        #[unsafe(method(setZIndex:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setZIndex(&self, z_index: NSInteger);

        #[unsafe(method(elementKind))]
        #[unsafe(method_family = none)]
        pub unsafe fn elementKind(&self) -> Retained<NSString>;
    );
}

/// Methods declared on superclass `NSCollectionLayoutItem`.
impl NSCollectionLayoutDecorationItem {
    extern_methods!(
        #[unsafe(method(itemWithLayoutSize:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemWithLayoutSize(layout_size: &NSCollectionLayoutSize) -> Retained<Self>;

        #[unsafe(method(itemWithLayoutSize:supplementaryItems:))]
        #[unsafe(method_family = none)]
        pub unsafe fn itemWithLayoutSize_supplementaryItems(
            layout_size: &NSCollectionLayoutSize,
            supplementary_items: &NSArray<NSCollectionLayoutSupplementaryItem>,
        ) -> Retained<Self>;
    );
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutanchor?language=objc)
    #[unsafe(super(NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSCollectionLayoutAnchor;
);

extern_conformance!(
    unsafe impl NSCopying for NSCollectionLayoutAnchor {}
);

unsafe impl CopyingHelper for NSCollectionLayoutAnchor {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSCollectionLayoutAnchor {}
);

impl NSCollectionLayoutAnchor {
    extern_methods!(
        #[cfg(feature = "UIGeometry")]
        #[unsafe(method(layoutAnchorWithEdges:))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutAnchorWithEdges(
            edges: NSDirectionalRectEdge,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(layoutAnchorWithEdges:absoluteOffset:))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutAnchorWithEdges_absoluteOffset(
            edges: NSDirectionalRectEdge,
            absolute_offset: CGPoint,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(layoutAnchorWithEdges:fractionalOffset:))]
        #[unsafe(method_family = none)]
        pub unsafe fn layoutAnchorWithEdges_fractionalOffset(
            edges: NSDirectionalRectEdge,
            fractional_offset: CGPoint,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;

        #[cfg(feature = "UIGeometry")]
        #[unsafe(method(edges))]
        #[unsafe(method_family = none)]
        pub unsafe fn edges(&self) -> NSDirectionalRectEdge;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(offset))]
        #[unsafe(method_family = none)]
        pub unsafe fn offset(&self) -> CGPoint;

        #[unsafe(method(isAbsoluteOffset))]
        #[unsafe(method_family = none)]
        pub unsafe fn isAbsoluteOffset(&self) -> bool;

        #[unsafe(method(isFractionalOffset))]
        #[unsafe(method_family = none)]
        pub unsafe fn isFractionalOffset(&self) -> bool;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutcontainer?language=objc)
    pub unsafe trait NSCollectionLayoutContainer: NSObjectProtocol + MainThreadOnly {
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(contentSize))]
        #[unsafe(method_family = none)]
        unsafe fn contentSize(&self) -> CGSize;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(effectiveContentSize))]
        #[unsafe(method_family = none)]
        unsafe fn effectiveContentSize(&self) -> CGSize;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(contentInsets))]
        #[unsafe(method_family = none)]
        unsafe fn contentInsets(&self) -> NSDirectionalEdgeInsets;

        #[cfg(all(feature = "UIGeometry", feature = "objc2-core-foundation"))]
        #[unsafe(method(effectiveContentInsets))]
        #[unsafe(method_family = none)]
        unsafe fn effectiveContentInsets(&self) -> NSDirectionalEdgeInsets;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutenvironment?language=objc)
    pub unsafe trait NSCollectionLayoutEnvironment:
        NSObjectProtocol + MainThreadOnly
    {
        #[unsafe(method(container))]
        #[unsafe(method_family = none)]
        unsafe fn container(&self) -> Retained<ProtocolObject<dyn NSCollectionLayoutContainer>>;

        #[cfg(feature = "UITraitCollection")]
        #[unsafe(method(traitCollection))]
        #[unsafe(method_family = none)]
        unsafe fn traitCollection(&self) -> Retained<UITraitCollection>;
    }
);

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/nscollectionlayoutvisibleitem?language=objc)
    #[cfg(feature = "UIDynamicBehavior")]
    pub unsafe trait NSCollectionLayoutVisibleItem:
        NSObjectProtocol + UIDynamicItem + MainThreadOnly
    {
        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(alpha))]
        #[unsafe(method_family = none)]
        unsafe fn alpha(&self) -> CGFloat;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`alpha`][Self::alpha].
        #[unsafe(method(setAlpha:))]
        #[unsafe(method_family = none)]
        unsafe fn setAlpha(&self, alpha: CGFloat);

        #[unsafe(method(zIndex))]
        #[unsafe(method_family = none)]
        unsafe fn zIndex(&self) -> NSInteger;

        /// Setter for [`zIndex`][Self::zIndex].
        #[unsafe(method(setZIndex:))]
        #[unsafe(method_family = none)]
        unsafe fn setZIndex(&self, z_index: NSInteger);

        #[unsafe(method(isHidden))]
        #[unsafe(method_family = none)]
        unsafe fn isHidden(&self) -> bool;

        /// Setter for [`isHidden`][Self::isHidden].
        #[unsafe(method(setHidden:))]
        #[unsafe(method_family = none)]
        unsafe fn setHidden(&self, hidden: bool);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(center))]
        #[unsafe(method_family = none)]
        unsafe fn center(&self) -> CGPoint;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`center`][Self::center].
        #[unsafe(method(setCenter:))]
        #[unsafe(method_family = none)]
        unsafe fn setCenter(&self, center: CGPoint);

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(transform))]
        #[unsafe(method_family = none)]
        unsafe fn transform(&self) -> CGAffineTransform;

        #[cfg(feature = "objc2-core-foundation")]
        /// Setter for [`transform`][Self::transform].
        #[unsafe(method(setTransform:))]
        #[unsafe(method_family = none)]
        unsafe fn setTransform(&self, transform: CGAffineTransform);

        #[cfg(feature = "objc2-quartz-core")]
        #[cfg(not(target_os = "watchos"))]
        #[unsafe(method(transform3D))]
        #[unsafe(method_family = none)]
        unsafe fn transform3D(&self) -> CATransform3D;

        #[cfg(feature = "objc2-quartz-core")]
        #[cfg(not(target_os = "watchos"))]
        /// Setter for [`transform3D`][Self::transform3D].
        #[unsafe(method(setTransform3D:))]
        #[unsafe(method_family = none)]
        unsafe fn setTransform3D(&self, transform3_d: CATransform3D);

        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        unsafe fn name(&self) -> Retained<NSString>;

        #[unsafe(method(indexPath))]
        #[unsafe(method_family = none)]
        unsafe fn indexPath(&self) -> Retained<NSIndexPath>;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(frame))]
        #[unsafe(method_family = none)]
        unsafe fn frame(&self) -> CGRect;

        #[cfg(feature = "objc2-core-foundation")]
        #[unsafe(method(bounds))]
        #[unsafe(method_family = none)]
        unsafe fn bounds(&self) -> CGRect;

        #[cfg(feature = "UICollectionViewLayout")]
        #[unsafe(method(representedElementCategory))]
        #[unsafe(method_family = none)]
        unsafe fn representedElementCategory(&self) -> UICollectionElementCategory;

        #[unsafe(method(representedElementKind))]
        #[unsafe(method_family = none)]
        unsafe fn representedElementKind(&self) -> Option<Retained<NSString>>;
    }
);

/// Deprecated.
impl NSCollectionLayoutSection {
    extern_methods!(
        #[deprecated]
        #[unsafe(method(supplementariesFollowContentInsets))]
        #[unsafe(method_family = none)]
        pub unsafe fn supplementariesFollowContentInsets(&self) -> bool;

        /// Setter for [`supplementariesFollowContentInsets`][Self::supplementariesFollowContentInsets].
        #[deprecated]
        #[unsafe(method(setSupplementariesFollowContentInsets:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSupplementariesFollowContentInsets(
            &self,
            supplementaries_follow_content_insets: bool,
        );
    );
}

/// Deprecated.
impl NSCollectionLayoutGroup {
    extern_methods!(
        #[deprecated]
        #[unsafe(method(horizontalGroupWithLayoutSize:subitem:count:))]
        #[unsafe(method_family = none)]
        pub unsafe fn horizontalGroupWithLayoutSize_subitem_count(
            layout_size: &NSCollectionLayoutSize,
            subitem: &NSCollectionLayoutItem,
            count: NSInteger,
        ) -> Retained<Self>;

        #[deprecated]
        #[unsafe(method(verticalGroupWithLayoutSize:subitem:count:))]
        #[unsafe(method_family = none)]
        pub unsafe fn verticalGroupWithLayoutSize_subitem_count(
            layout_size: &NSCollectionLayoutSize,
            subitem: &NSCollectionLayoutItem,
            count: NSInteger,
        ) -> Retained<Self>;
    );
}
