/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.text.resources.cldr.ext;

import java.util.ListResourceBundle;

public class FormatData_gd extends ListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] metaValue_MonthNames = new String[] {
               "dhen Fhaoilleach",
               "dhen Ghearran",
               "dhen Mh\u00e0rt",
               "dhen Ghiblean",
               "dhen Ch\u00e8itean",
               "dhen \u00d2gmhios",
               "dhen Iuchar",
               "dhen L\u00f9nastal",
               "dhen t-Sultain",
               "dhen D\u00e0mhair",
               "dhen t-Samhain",
               "dhen D\u00f9bhlachd",
               "",
            };
        final String[] metaValue_MonthAbbreviations = new String[] {
               "Faoi",
               "Gearr",
               "M\u00e0rt",
               "Gibl",
               "C\u00e8it",
               "\u00d2gmh",
               "Iuch",
               "L\u00f9na",
               "Sult",
               "D\u00e0mh",
               "Samh",
               "D\u00f9bh",
               "",
            };
        final String[] metaValue_MonthNarrows = new String[] {
               "F",
               "G",
               "M",
               "G",
               "C",
               "\u00d2",
               "I",
               "L",
               "S",
               "D",
               "S",
               "D",
               "",
            };
        final String[] metaValue_DayNames = new String[] {
               "DiD\u00f2mhnaich",
               "DiLuain",
               "DiM\u00e0irt",
               "DiCiadain",
               "DiarDaoin",
               "DihAoine",
               "DiSathairne",
            };
        final String[] metaValue_DayAbbreviations = new String[] {
               "DiD",
               "DiL",
               "DiM",
               "DiC",
               "Dia",
               "Dih",
               "DiS",
            };
        final String[] metaValue_DayNarrows = new String[] {
               "D",
               "L",
               "M",
               "C",
               "A",
               "H",
               "S",
            };
        final String[] metaValue_QuarterNames = new String[] {
               "1d chairteal",
               "2na cairteal",
               "3s cairteal",
               "4mh cairteal",
            };
        final String[] metaValue_QuarterAbbreviations = new String[] {
               "C1",
               "C2",
               "C3",
               "C4",
            };
        final String[] metaValue_AmPmMarkers = new String[] {
               "m",
               "f",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] metaValue_TimePatterns = new String[] {
               "HH:mm:ss zzzz",
               "HH:mm:ss z",
               "HH:mm:ss",
               "HH:mm",
            };
        final String[] metaValue_buddhist_QuarterNarrows = new String[] {
               "1",
               "2",
               "3",
               "4",
            };
        final String[] metaValue_java_time_buddhist_DatePatterns = new String[] {
               "EEEE, d'mh' MMMM y G",
               "d'mh' MMMM y G",
               "d MMM y G",
               "d/M/y GGGGG",
            };
        final String[] metaValue_buddhist_DatePatterns = new String[] {
               "EEEE, d'mh' MMMM y GGGG",
               "d'mh' MMMM y GGGG",
               "d MMM y GGGG",
               "d/M/y G",
            };
        final String[] metaValue_japanese_DateTimePatterns = new String[] {
               "{1} 'aig' {0}",
               "{1} 'aig' {0}",
               "",
               "",
            };
        final String[] metaValue_java_time_roc_long_Eras = new String[] {
               "Ro Ph. na S\u00ecne",
               "M\u00edngu\u00f3",
            };
        final String[] metaValue_java_time_roc_Eras = new String[] {
               "Ro PnS",
               "M\u00edngu\u00f3",
            };
        final String metaValue_calendarname_gregorian = "Am M\u00ecosachan Griogarach";
        final String[] metaValue_adlm_NumberElements = new String[] {
               ".",
               ",",
               ";",
               "%",
               "0",
               "#",
               "-",
               "E",
               "\u2030",
               "\u221e",
               "NaN",
               "",
               "",
            };
        final String[] metaValue_adlm_NumberPatterns = new String[] {
               "#,##0.###",
               "\u00a4\u00a0#,##0.00",
               "#,##0%",
               "",
            };
        final String[] metaValue_fullwide_NumberPatterns = new String[] {
               "#,##0.###",
               "\u00a4#,##0.00",
               "#,##0%",
               "\u00a4#,##0.00;(\u00a4#,##0.00)",
            };
        final Object[][] data = new Object[][] {
            { "MonthNames", metaValue_MonthNames },
            { "rohg.NumberElements", metaValue_adlm_NumberElements },
            { "calendarname.islamic-umalqura", "Am M\u00ecosachan Ioslamach (Umm al-Qura)" },
            { "osma.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "roc.QuarterNames", metaValue_QuarterNames },
            { "lana.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1a80",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "calendarname.islamic-civil", "Am M\u00ecosachan Ioslamach (cl\u00e0rach, linn s\u00ecobhalta)" },
            { "talu.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u19d0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "gonm.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "mtei.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\uabf0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "japanese.MonthNames", metaValue_MonthNames },
            { "standalone.DayAbbreviations", metaValue_DayAbbreviations },
            { "islamic.DayNames", metaValue_DayNames },
            { "buddhist.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "cakm.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "DateTimePatterns",
                new String[] {
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "latn.NumberElements", metaValue_adlm_NumberElements },
            { "guru.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0a66",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "field.minute", "mionaid" },
            { "buddhist.AmPmMarkers", metaValue_AmPmMarkers },
            { "bali.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "standalone.MonthNarrows", metaValue_MonthNarrows },
            { "cham.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\uaa50",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "adlm.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "japanese.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "saur.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "arab.NumberElements",
                new String[] {
                    "\u066b",
                    "\u066c",
                    "\u061b",
                    "\u066a",
                    "\u0660",
                    "#",
                    "\u061c-",
                    "\u0627\u0633",
                    "\u0609",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "beng.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "shrd.NumberElements", metaValue_adlm_NumberElements },
            { "takr.NumberElements", metaValue_adlm_NumberElements },
            { "islamic.DatePatterns", metaValue_buddhist_DatePatterns },
            { "deva.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0966",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "roc.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "sund.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "arabext.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "field.second", "diog" },
            { "vaii.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "roc.DatePatterns", metaValue_buddhist_DatePatterns },
            { "calendarname.islamic", "Am M\u00ecosachan Ioslamach" },
            { "java.time.roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "buddhist.TimePatterns", metaValue_TimePatterns },
            { "brah.NumberElements", metaValue_adlm_NumberElements },
            { "standalone.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "gong.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "olck.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1c50",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "japanese.MonthNarrows", metaValue_MonthNarrows },
            { "tibt.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "khmr.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "islamic.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.DayAbbreviations", metaValue_DayAbbreviations },
            { "orya.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mymrshan.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1090",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "islamic.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\ua9d0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "TimePatterns", metaValue_TimePatterns },
            { "islamic.DayNarrows", metaValue_DayNarrows },
            { "roc.narrow.Eras", metaValue_java_time_roc_Eras },
            { "laoo.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0ed0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "sund.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1bb0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "telu.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "buddhist.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "kali.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\ua900",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "roc.DayNames", metaValue_DayNames },
            { "lanatham.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "japanese.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "islamic.DayAbbreviations", metaValue_DayAbbreviations },
            { "buddhist.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "mong.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "tamldec.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mymr.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "nkoo.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u07c0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "cakm.NumberElements", metaValue_adlm_NumberElements },
            { "tibt.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0f20",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "DayNames", metaValue_DayNames },
            { "buddhist.DatePatterns", metaValue_buddhist_DatePatterns },
            { "roc.MonthNames", metaValue_MonthNames },
            { "sora.NumberElements", metaValue_adlm_NumberElements },
            { "gujr.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0ae6",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "buddhist.MonthNarrows", metaValue_MonthNarrows },
            { "limb.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1946",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "roc.DayNarrows", metaValue_DayNarrows },
            { "shrd.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "java.time.buddhist.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "mlym.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "calendarname.gregorian", metaValue_calendarname_gregorian },
            { "timezone.regionFormat.daylight", "T\u00ecde samhraidh: {0}" },
            { "DatePatterns",
                new String[] {
                    "EEEE, d'mh' MMMM y",
                    "d'mh' MMMM y",
                    "d MMM y",
                    "dd/MM/y",
                }
            },
            { "islamic.TimePatterns", metaValue_TimePatterns },
            { "japanese.DateTimePatterns", metaValue_japanese_DateTimePatterns },
            { "MonthAbbreviations", metaValue_MonthAbbreviations },
            { "standalone.DayNames", metaValue_DayNames },
            { "vaii.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\ua620",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "adlm.NumberElements", metaValue_adlm_NumberElements },
            { "QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "calendarname.gregory", metaValue_calendarname_gregorian },
            { "field.year", "bliadhna" },
            { "arabext.NumberElements",
                new String[] {
                    "\u066b",
                    "\u066c",
                    "\u061b",
                    "\u066a",
                    "\u06f0",
                    "#",
                    "-",
                    "\u00d7\u06f1\u06f0^",
                    "\u0609",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "japanese.AmPmMarkers", metaValue_AmPmMarkers },
            { "AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.japanese.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "standalone.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "mtei.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "roc.MonthNarrows", metaValue_MonthNarrows },
            { "islamic.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "takr.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mymr.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1040",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "japanese.TimePatterns", metaValue_TimePatterns },
            { "roc.long.Eras", metaValue_java_time_roc_long_Eras },
            { "narrow.Eras",
                new String[] {
                    "R",
                    "A",
                }
            },
            { "timezone.regionFormat.standard", "Bun-\u00e0m: {0}" },
            { "tamldec.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0be6",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "japanese.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "calendarname.japanese", "Am M\u00ecosachan Seapanach" },
            { "roc.MonthAbbreviations", metaValue_MonthAbbreviations },
            { "beng.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u09e6",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "long.Eras",
                new String[] {
                    "Ro Chr\u00ecosta",
                    "An d\u00e8idh Chr\u00ecosta",
                }
            },
            { "roc.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "saur.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\ua8d0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "buddhist.MonthNames", metaValue_MonthNames },
            { "gong.NumberElements", metaValue_adlm_NumberElements },
            { "MonthNarrows", metaValue_MonthNarrows },
            { "japanese.DatePatterns", metaValue_buddhist_DatePatterns },
            { "buddhist.DayNames", metaValue_DayNames },
            { "field.era", "linn" },
            { "field.dayperiod", "m/f" },
            { "lana.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "calendarname.roc", "M\u00ecosachan Poblachd na S\u00ecne" },
            { "field.month", "m\u00ecos" },
            { "osma.NumberElements", metaValue_adlm_NumberElements },
            { "roc.Eras", metaValue_java_time_roc_Eras },
            { "DayAbbreviations", metaValue_DayAbbreviations },
            { "DayNarrows", metaValue_DayNarrows },
            { "gonm.NumberElements", metaValue_adlm_NumberElements },
            { "guru.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "knda.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0ce6",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "bali.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1b50",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "java.time.roc.narrow.Eras", metaValue_java_time_roc_Eras },
            { "japanese.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "sora.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "long.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0' 'mh\u00ecle two:0' 'mh\u00ecle few:0' 'm\u00ecltean other:0' 'm\u00ecle}",
                    "{one:00' 'mh\u00ecle two:00' 'mh\u00ecle few:00' 'm\u00ecltean other:00' 'm\u00ecle}",
                    "{one:000' 'mh\u00ecle two:000' 'mh\u00ecle few:000' 'm\u00ecltean other:000' 'm\u00ecle}",
                    "{one:0' 'mhillean two:0' 'mhillean few:0' 'milleanan other:0' 'millean}",
                    "{one:00' 'mhillean two:00' 'mhillean few:00' 'milleanan other:00' 'millean}",
                    "{one:000' 'mhillean two:000' 'mhillean few:000' 'milleanan other:000' 'millean}",
                    "{one:0' 'bhillean two:0' 'bhillean few:0' 'billeanan other:0' 'billean}",
                    "{one:00' 'bhillean two:00' 'bhillean few:00' 'billeanan other:00' 'billean}",
                    "{one:000' 'bhillean two:000' 'bhillean few:000' 'billeanan other:000' 'billean}",
                    "{one:0' 'trillean two:0' 'thrillean few:0' 'trilleanan other:0' 'trillean}",
                    "{one:00' 'trillean two:00' 'thrillean few:00' 'trilleanan other:00' 'trillean}",
                    "{one:000' 'trillean two:000' 'thrillean few:000' 'trilleanan other:000' 'trillean}",
                }
            },
            { "roc.narrow.AmPmMarkers", metaValue_AmPmMarkers },
            { "buddhist.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "standalone.QuarterNames", metaValue_QuarterNames },
            { "standalone.DayNarrows", metaValue_DayNarrows },
            { "mlym.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0d66",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "lepc.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1c40",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "gujr.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "fullwide.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\uff10",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "limb.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "java.time.roc.Eras", metaValue_java_time_roc_Eras },
            { "khmr.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u17e0",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "field.zone", "roinn-t\u00ecde" },
            { "japanese.QuarterAbbreviations", metaValue_QuarterAbbreviations },
            { "roc.DateTimePatterns",
                new String[] {
                    "{1} 'aig' {0}",
                    "{1} 'aig' {0}",
                    "{1} {0}",
                    "{1} {0}",
                }
            },
            { "arab.NumberPatterns",
                new String[] {
                    "#,##0.###",
                    "#,##0.00\u00a0\u00a4",
                    "#,##0%",
                    "",
                }
            },
            { "thai.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0e50",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "buddhist.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "Eras",
                new String[] {
                    "RC",
                    "AD",
                }
            },
            { "lepc.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "islamic.QuarterNames", metaValue_QuarterNames },
            { "mymrshan.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "islamic.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
            { "nkoo.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "mong.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1810",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "java.time.islamic.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "field.weekday", "latha na seachdaine" },
            { "islamic.DateTimePatterns", metaValue_japanese_DateTimePatterns },
            { "brah.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "java.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "thai.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "fullwide.NumberPatterns", metaValue_fullwide_NumberPatterns },
            { "japanese.QuarterNames", metaValue_QuarterNames },
            { "telu.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0c66",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "olck.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "japanese.DayNames", metaValue_DayNames },
            { "knda.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "japanese.DayAbbreviations", metaValue_DayAbbreviations },
            { "lanatham.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u1a90",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "laoo.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "talu.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "field.week", "seachdain" },
            { "buddhist.QuarterNames", metaValue_QuarterNames },
            { "islamic.QuarterNarrows", metaValue_buddhist_QuarterNarrows },
            { "orya.NumberElements",
                new String[] {
                    ".",
                    ",",
                    ";",
                    "%",
                    "\u0b66",
                    "#",
                    "-",
                    "E",
                    "\u2030",
                    "\u221e",
                    "NaN",
                    "",
                    "",
                }
            },
            { "roc.AmPmMarkers", metaValue_AmPmMarkers },
            { "java.time.roc.DatePatterns", metaValue_java_time_buddhist_DatePatterns },
            { "rohg.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "short.CompactNumberPatterns",
                new String[] {
                    "",
                    "",
                    "",
                    "{one:0K two:0K few:0K other:0K}",
                    "{one:00K two:00K few:00K other:00K}",
                    "{one:000K two:000K few:000K other:000K}",
                    "{one:0M two:0M few:0M other:0M}",
                    "{one:00M two:00M few:00M other:00M}",
                    "{one:000M two:000M few:000M other:000M}",
                    "{one:0B two:0B few:0B other:0B}",
                    "{one:00B two:00B few:00B other:00B}",
                    "{one:000B two:000B few:000B other:000B}",
                    "{one:0T two:0T few:0T other:0T}",
                    "{one:00T two:00T few:00T other:00T}",
                    "{one:000T two:000T few:000T other:000T}",
                }
            },
            { "buddhist.DayAbbreviations", metaValue_DayAbbreviations },
            { "cham.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "PluralRules", "one:n = 1,11;few:n = 3..10,13..19;two:n = 2,12" },
            { "field.hour", "uair a th\u00ecde" },
            { "calendarname.buddhist", "Am M\u00ecosachan Budach" },
            { "kali.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "latn.NumberPatterns", metaValue_fullwide_NumberPatterns },
            { "standalone.MonthNames",
                new String[] {
                    "Am Faoilleach",
                    "An Gearran",
                    "Am M\u00e0rt",
                    "An Giblean",
                    "An C\u00e8itean",
                    "An t-\u00d2gmhios",
                    "An t-Iuchar",
                    "An L\u00f9nastal",
                    "An t-Sultain",
                    "An D\u00e0mhair",
                    "An t-Samhain",
                    "An D\u00f9bhlachd",
                    "",
                }
            },
            { "buddhist.DayNarrows", metaValue_DayNarrows },
            { "japanese.DayNarrows", metaValue_DayNarrows },
            { "QuarterNames", metaValue_QuarterNames },
            { "roc.TimePatterns", metaValue_TimePatterns },
            { "deva.NumberPatterns", metaValue_adlm_NumberPatterns },
            { "roc.abbreviated.AmPmMarkers", metaValue_AmPmMarkers },
        };
        return data;
    }
}
