/*
 * Decompiled with CFR 0.152.
 */
package pl.com.salsoft.sqlitestudioremote.internal;

import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.os.OperationCanceledException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import pl.com.salsoft.sqlitestudioremote.internal.ErrorCode;

public class QueryResults {
    private List<String> columnNames;
    private List<HashMap<String, Object>> data;
    private ErrorCode errorCode = ErrorCode.SQLITE_OK;
    private String errorMessage;

    public QueryResults() {
    }

    public void readResults(Cursor cursor) {
        this.columnNames = Arrays.asList(cursor.getColumnNames());
        this.data = new ArrayList<HashMap<String, Object>>();
        boolean ok = cursor.moveToFirst();
        while (ok) {
            this.data.add(this.readRow(cursor));
            ok = cursor.moveToNext();
        }
    }

    public QueryResults(OperationCanceledException e) {
        this.errorMessage = e.getMessage();
        this.errorCode = ErrorCode.SQLITE_INTERRUPT;
    }

    public QueryResults(SQLiteException e, ErrorCode code) {
        this.errorMessage = e.getMessage();
        this.errorCode = code;
    }

    public boolean isError() {
        return this.errorCode != ErrorCode.SQLITE_OK;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<HashMap<String, Object>> getData() {
        return this.data;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private HashMap<String, Object> readRow(Cursor cursor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < cursor.getColumnCount(); ++i) {
            Object val = this.getValue(i, cursor);
            map.put(this.columnNames.get(i), val);
        }
        return map;
    }

    private Object getValue(int i, Cursor cursor) {
        switch (cursor.getType(i)) {
            case 4: {
                return cursor.getBlob(i);
            }
            case 2: {
                return cursor.getDouble(i);
            }
            case 1: {
                return cursor.getLong(i);
            }
            case 0: {
                return null;
            }
            case 3: {
                return cursor.getString(i);
            }
        }
        throw new SQLiteException("Unknown field type for column number: " + i);
    }
}

