/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.runtime.Assert;

public class RefactoringTickProvider {
    public static final RefactoringTickProvider DEFAULT = new RefactoringTickProvider(4, 40, 22, 11);
    private final int[] fValues;
    private static final int CHECK_INITIAL_CONDITIONS = 0;
    private static final int CHECK_FINAL_CONDITIONS = 1;
    private static final int CREATE_CHANGE = 2;
    private static final int INITIALIZE_CHANGE = 3;

    public RefactoringTickProvider(int checkInitialConditionsTicks, int checkFinalConditionsTicks, int createChangeTicks, int initializeChangeTicks) {
        Assert.isTrue((checkInitialConditionsTicks >= 0 && checkFinalConditionsTicks >= 0 && createChangeTicks >= 0 && initializeChangeTicks >= 0 ? 1 : 0) != 0);
        this.fValues = new int[4];
        this.fValues[0] = checkInitialConditionsTicks;
        this.fValues[1] = checkFinalConditionsTicks;
        this.fValues[2] = createChangeTicks;
        this.fValues[3] = initializeChangeTicks;
    }

    public int getAllTicks() {
        return this.getCheckAllConditionsTicks() + this.fValues[2] + this.fValues[3];
    }

    public int getCheckAllConditionsTicks() {
        return this.fValues[0] + this.fValues[1];
    }

    public int getCheckInitialConditionsTicks() {
        return this.fValues[0];
    }

    public int getCheckFinalConditionsTicks() {
        return this.fValues[1];
    }

    public int getCreateChangeTicks() {
        return this.fValues[2];
    }

    public int getInitializeChangeTicks() {
        return this.fValues[3];
    }
}

