/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.fsm;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.c2s.XmppClientToServerTransport;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.c2s.internal.WalkStateGraphContext;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateTransitionResult;

public abstract class State {
    protected final StateDescriptor stateDescriptor;
    protected final ModularXmppClientToServerConnectionInternal connectionInternal;

    protected State(StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
        this.stateDescriptor = stateDescriptor;
        this.connectionInternal = connectionInternal;
    }

    public StateTransitionResult.TransitionImpossible isTransitionToPossible(WalkStateGraphContext walkStateGraphContext) throws SmackException {
        return null;
    }

    public abstract StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext var1) throws IOException, SmackException, InterruptedException, XMPPException;

    public StateDescriptor getStateDescriptor() {
        return this.stateDescriptor;
    }

    public void resetState() {
    }

    public String toString() {
        return "State " + String.valueOf(this.stateDescriptor) + " " + String.valueOf(this.connectionInternal.connection);
    }

    protected final void ensureNotOnOurWayToAuthenticatedAndResourceBound(WalkStateGraphContext walkStateGraphContext) {
        if (walkStateGraphContext.isFinalStateAuthenticatedAndResourceBound()) {
            throw new IllegalStateException("Smack should never attempt to reach the authenticated and resource bound state over " + String.valueOf(this) + ". This is probably a programming error within Smack, please report it to the develoeprs.");
        }
    }

    public static abstract class AbstractTransport
    extends State {
        private final XmppClientToServerTransport transport;

        protected AbstractTransport(XmppClientToServerTransport transport, StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(stateDescriptor, connectionInternal);
            this.transport = transport;
        }

        @Override
        public StateTransitionResult.TransitionImpossible isTransitionToPossible(WalkStateGraphContext walkStateGraphContext) throws SmackException {
            if (!this.transport.hasUseableConnectionEndpoints()) {
                return new StateTransitionResult.TransitionImpossibleBecauseNoEndpointsDiscovered(this.transport);
            }
            return super.isTransitionToPossible(walkStateGraphContext);
        }
    }
}

