/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.util.WriterListener;

public class ObservableWriter
extends Writer {
    private static final int MAX_STRING_BUILDER_SIZE = 4096;
    Writer wrappedWriter = null;
    final List<WriterListener> listeners = new ArrayList<WriterListener>();
    private final StringBuilder stringBuilder = new StringBuilder(4096);

    public ObservableWriter(Writer wrappedWriter) {
        this.wrappedWriter = wrappedWriter;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.wrappedWriter.write(cbuf, off, len);
        String str = new String(cbuf, off, len);
        this.maybeNotifyListeners(str);
    }

    @Override
    public void flush() throws IOException {
        this.notifyListeners();
        this.wrappedWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.wrappedWriter.close();
    }

    @Override
    public void write(int c) throws IOException {
        this.wrappedWriter.write(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.wrappedWriter.write(cbuf);
        String str = new String(cbuf);
        this.maybeNotifyListeners(str);
    }

    @Override
    public void write(String str) throws IOException {
        this.wrappedWriter.write(str);
        this.maybeNotifyListeners(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.wrappedWriter.write(str, off, len);
        str = str.substring(off, off + len);
        this.maybeNotifyListeners(str);
    }

    private void maybeNotifyListeners(String s) {
        this.stringBuilder.append(s);
        if (this.stringBuilder.length() > 4096) {
            this.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        WriterListener[] writerListeners;
        List<WriterListener> list2 = this.listeners;
        synchronized (list2) {
            writerListeners = new WriterListener[this.listeners.size()];
            this.listeners.toArray(writerListeners);
        }
        String str = this.stringBuilder.toString();
        this.stringBuilder.setLength(0);
        for (WriterListener writerListener : writerListeners) {
            writerListener.write(str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWriterListener(WriterListener writerListener) {
        if (writerListener == null) {
            return;
        }
        List<WriterListener> list2 = this.listeners;
        synchronized (list2) {
            if (!this.listeners.contains(writerListener)) {
                this.listeners.add(writerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWriterListener(WriterListener writerListener) {
        List<WriterListener> list2 = this.listeners;
        synchronized (list2) {
            this.listeners.remove(writerListener);
        }
    }
}

