/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqversion.packet;

import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.iqversion.packet.VersionBuilder;
import org.jivesoftware.smackx.iqversion.packet.VersionView;

public class Version
extends IQ
implements VersionView {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "jabber:iq:version";
    private final String name;
    private final String version;
    private String os;

    Version(VersionBuilder versionBuilder) {
        super(versionBuilder, ELEMENT, NAMESPACE);
        this.name = versionBuilder.getName();
        this.version = versionBuilder.getVersion();
        this.os = versionBuilder.getOs();
        if (this.getType() != IQ.Type.result) {
            return;
        }
        StringUtils.requireNotNullNorEmpty(this.name, "Version results must contain a name");
        StringUtils.requireNotNullNorEmpty(this.version, "Version results must contain a version");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getOs() {
        return this.os;
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.rightAngleBracket();
        xml.optElement("name", this.name);
        xml.optElement("version", this.version);
        xml.optElement("os", this.os);
        return xml;
    }

    public static VersionBuilder builder(XMPPConnection connection) {
        return new VersionBuilder(connection);
    }

    public static VersionBuilder builder(IqData iqData) {
        return new VersionBuilder(iqData);
    }

    public static VersionBuilder builder(Version versionRequest) {
        IqData iqData = IqData.createResponseData(versionRequest);
        return Version.builder(iqData);
    }
}

