/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.urldata.provider;

import java.io.IOException;
import java.util.ArrayList;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.urldata.element.UrlDataElement;
import org.jivesoftware.smackx.urldata.http.element.AuthParamElement;
import org.jivesoftware.smackx.urldata.http.element.CookieElement;
import org.jivesoftware.smackx.urldata.http.element.HeaderElement;
import org.jivesoftware.smackx.urldata.http.element.HttpAuthElement;
import org.jxmpp.JxmppContext;

public class UrlDataElementProvider
extends ExtensionElementProvider<UrlDataElement> {
    @Override
    public UrlDataElement parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, SmackParsingException {
        String target = parser.getAttributeValue("target");
        String sid = parser.getAttributeValue("sid");
        ArrayList<HttpAuthElement> authElements = new ArrayList<HttpAuthElement>();
        ArrayList<CookieElement> cookieElements = new ArrayList<CookieElement>();
        ArrayList<HeaderElement> headerElements = new ArrayList<HeaderElement>();
        do {
            XmlPullParser.TagEvent event = parser.nextTag();
            String name = parser.getName();
            if (event != XmlPullParser.TagEvent.START_ELEMENT) continue;
            switch (name) {
                case "url-data": {
                    break;
                }
                case "auth": {
                    String scheme = parser.getAttributeValue("scheme");
                    ArrayList<AuthParamElement> authParamElements = new ArrayList<AuthParamElement>();
                    int innerDepth = parser.getDepth();
                    do {
                        XmlPullParser.TagEvent innerTag = parser.nextTag();
                        String innerName = parser.getName();
                        if (!innerTag.equals((Object)XmlPullParser.TagEvent.START_ELEMENT) || !innerName.equals("auth-param")) continue;
                        String attrName = ParserUtils.getRequiredAttribute(parser, "name");
                        String attrVal = ParserUtils.getRequiredAttribute(parser, "value");
                        authParamElements.add(new AuthParamElement(attrName, attrVal));
                    } while (parser.getDepth() != innerDepth);
                    authElements.add(new HttpAuthElement(scheme, authParamElements));
                    break;
                }
                case "cookie": {
                    String cookieName = ParserUtils.getRequiredAttribute(parser, "name");
                    String cookieValue = ParserUtils.getRequiredAttribute(parser, "value");
                    String cookieDomain = parser.getAttributeValue("domain");
                    Integer cookieMaxAge = ParserUtils.getIntegerAttribute(parser, "max-age");
                    String cookiePath = parser.getAttributeValue("path");
                    String cookieComment = parser.getAttributeValue("comment");
                    Boolean cookieSecure = ParserUtils.getBooleanAttribute(parser, "secure");
                    String cookieVersion = parser.getAttributeValue("version");
                    cookieElements.add(new CookieElement(cookieName, cookieValue, cookieDomain, cookieMaxAge, cookiePath, cookieComment, cookieVersion, cookieSecure));
                    break;
                }
                case "header": {
                    String headerName = ParserUtils.getRequiredAttribute(parser, "name");
                    String headerValue = ParserUtils.getRequiredAttribute(parser, "value");
                    headerElements.add(new HeaderElement(headerName, headerValue));
                }
            }
        } while (parser.getDepth() != initialDepth);
        return new UrlDataElement(target, sid, authElements, cookieElements, headerElements);
    }
}

