/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.JxmppContext;
import org.jxmpp.jid.Jid;

public class AgentWorkgroups
extends IQ {
    private Jid agentJID;
    private List<String> workgroups;

    private AgentWorkgroups() {
        super("workgroups", "http://jabber.org/protocol/workgroup");
    }

    public AgentWorkgroups(Jid agentJID) {
        this();
        this.agentJID = agentJID;
        this.workgroups = new ArrayList<String>();
    }

    public AgentWorkgroups(Jid agentJID, List<String> workgroups) {
        this();
        this.agentJID = agentJID;
        this.workgroups = workgroups;
    }

    public Jid getAgentJID() {
        return this.agentJID;
    }

    public List<String> getWorkgroups() {
        return Collections.unmodifiableList(this.workgroups);
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.attribute("jid", this.agentJID).rightAngleBracket();
        for (String workgroupJID : this.workgroups) {
            buf.append("<workgroup jid=\"" + workgroupJID + "\"/>");
        }
        return buf;
    }

    public static class Provider
    extends IqProvider<AgentWorkgroups> {
        @Override
        public AgentWorkgroups parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
            Jid agentJID = ParserUtils.getJidAttribute(parser, jxmppContext);
            ArrayList<String> workgroups = new ArrayList<String>();
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT) {
                    if (!parser.getName().equals("workgroup")) continue;
                    workgroups.add(parser.getAttributeValue("", "jid"));
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("workgroups")) continue;
                done = true;
            }
            return new AgentWorkgroups(agentJID, workgroups);
        }
    }
}

